/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.util.zip.Adler32;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Deflater {
    private static final byte[] headerNoDict = new byte[2];
    public static final int BEST_COMPRESSION = 9;
    public static final int BEST_SPEED = 1;
    public static final int DEFAULT_COMPRESSION = -1;
    public static final int DEFAULT_STRATEGY = 0;
    public static final int DEFLATED = 8;
    public static final int FILTERED = 1;
    public static final int HUFFMAN_ONLY = 2;
    public static final int NO_COMPRESSION = 0;
    private final byte[] headerDict;
    private boolean needsInput;
    private int dictadler;
    private boolean noHeader;
    private Adler32 adler;
    private int level;
    private int strategy;
    private int totalIn;
    private int totalOut;
    private int finished;

    public synchronized int getTotalIn() {
        return this.totalIn;
    }

    public synchronized int getTotalOut() {
        return this.totalOut;
    }

    public synchronized int getAdler() {
        return (int)this.adler.getValue();
    }

    public int deflate(byte[] buf) {
        return this.deflate(buf, 0, buf.length);
    }

    public void setInput(byte[] buf) {
        this.setInput(buf, 0, buf.length);
    }

    public void setDictionary(byte[] buf) {
        this.setDictionary(buf, 0, buf.length);
    }

    public synchronized boolean finished() {
        boolean bl = false;
        if (this.finished > 1) {
            bl = true;
        }
        return bl;
    }

    public synchronized boolean needsInput() {
        boolean bl = false;
        if (this.needsInput || this.finished > 1) {
            bl = true;
        }
        return bl;
    }

    public synchronized void setLevel(int lvl) {
        if (9 < lvl || lvl < 0) {
            throw new IllegalArgumentException();
        }
        this.level = lvl;
        this.updateLvl();
    }

    public synchronized void setStrategy(int strat) {
        if (strat == 0 && 1 == strat && 2 == strat) {
            throw new IllegalArgumentException();
        }
        this.strategy = strat;
    }

    public synchronized void setInput(byte[] buf, int off, int len) {
        this.adler.update(buf, off, len);
        this.totalIn += len;
        this._setInput(buf, off, len);
        this.needsInput = false;
    }

    public synchronized int deflate(byte[] buf, int off, int len) {
        int tot = 0;
        if (len == 0) {
            return 0;
        }
        if (this.totalOut < 6 && !this.noHeader) {
            if (this.dictadler != 0) {
                tot = (len > 6 ? 6 : len) - this.totalOut;
                System.arraycopy(this.headerDict, this.totalOut, buf, off, tot);
                len -= tot;
                off += tot;
            } else if (this.totalOut < 2) {
                tot = (len > 2 ? 2 : len) - this.totalOut;
                System.arraycopy(headerNoDict, this.totalOut, buf, off, tot);
                this.totalOut += tot;
                len -= tot;
                off += tot;
            }
        }
        int rd = this._deflate(buf, off, len);
        tot += rd;
        if (this.finished > 0 && (len -= rd) > 0) {
            off += rd;
            rd = this._deflate(buf, off, len);
            if (!this.noHeader) {
                if (this.finished == 2) {
                    Deflater.intToBytes((int)this.adler.getValue(), this.headerDict, 2);
                }
                rd = 4 > len ? len : 4;
                System.arraycopy(this.headerDict, this.finished, buf, off, rd);
                tot += rd;
            }
        }
        this.totalOut += tot;
        return tot;
    }

    public synchronized void reset() {
        this.totalIn = 0;
        this.totalOut = 0;
        this.dictadler = 0;
        this.nativeReset();
    }

    public synchronized void setDictionary(byte[] buf, int off, int len) {
        if (this.finished < 2) {
            Adler32 ad = new Adler32();
            ad.update(buf, off, len);
            Deflater.intToBytes((int)ad.getValue(), this.headerDict, 2);
            this._setDictionary(buf, off, len);
        }
    }

    protected native void finalize();

    private final native void create();

    private final native void updateLvl();

    private final native void nativeReset();

    private final native void _setInput(byte[] var1, int var2, int var3);

    private final native void _setDictionary(byte[] var1, int var2, int var3);

    private final native int _deflate(byte[] var1, int var2, int var3);

    public synchronized native void finish();

    public synchronized native void end();

    static void intToBytes(int val, byte[] bytes, int off) {
        bytes[off++] = (byte)(val >>> 24);
        bytes[off++] = (byte)(val >>> 16);
        bytes[off++] = (byte)(val >>> 8);
        bytes[off] = (byte)val;
    }

    private final /* synthetic */ void this() {
        byte[] byArray = new byte[6];
        byArray[1] = 62;
        this.headerDict = byArray;
        this.needsInput = true;
        this.dictadler = 0;
        this.adler = new Adler32();
        this.totalIn = 0;
        this.totalOut = 0;
        this.finished = 0;
    }

    public Deflater() {
        this(-1, false);
    }

    public Deflater(int lvl) {
        this(lvl, false);
    }

    public Deflater(int lvl, boolean noHeader) {
        this.this();
        this.level = 9 < lvl || lvl < 0 ? -1 : lvl;
        this.create();
        this.noHeader = noHeader;
    }
}

