/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.Checksum;

public class CheckedInputStream
extends FilterInputStream {
    private Checksum checksum;

    public Checksum getChecksum() {
        return this.checksum;
    }

    public int read() throws IOException {
        int rd = this.in.read();
        if (rd != -1) {
            this.checksum.update(rd);
        }
        return rd;
    }

    public int read(byte[] buf, int offset, int len) throws IOException {
        int rd = this.in.read(buf, offset, len);
        if (rd != -1) {
            this.checksum.update(buf, offset, rd);
        }
        return rd;
    }

    public long skip(long n) throws IOException {
        if (n < 0L) {
            throw new IllegalArgumentException();
        }
        long skipped = 0L;
        int count = n > 1024L ? 1024 : (int)n;
        byte[] buf = new byte[count];
        while (n > 0L) {
            int rd = this.in.read(buf, 0, count);
            if (rd == -1) break;
            skipped += (long)rd;
            this.checksum.update(buf, 0, rd);
            n -= (long)rd;
        }
        return skipped;
    }

    public CheckedInputStream(InputStream in, Checksum cs) {
        super(in);
        if (cs == null) {
            throw new NullPointerException();
        }
        this.checksum = cs;
    }
}

