/*
 * Decompiled with CFR 0.152.
 */
package java.util.jar;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.GetSystemProperty;

public class Manifest
implements Cloneable {
    private Attributes mainAttributes;
    private HashMap entries;
    private static final String NVSep = ": ";
    private static final String LineSep = GetSystemProperty.LINE_SEPARATOR;
    private static final byte[] newline = LineSep.getBytes();
    private static final int MAX_LINELENGTH = 72 - newline.length;

    public Manifest() {
        this.mainAttributes = new Attributes();
        this.entries = new HashMap();
    }

    public Manifest(InputStream is) throws IOException {
        this.mainAttributes = new Attributes();
        this.entries = new HashMap();
        this.read(is);
    }

    public Manifest(Manifest man) {
        this.mainAttributes = (Attributes)man.mainAttributes.clone();
        this.entries = (HashMap)man.entries.clone();
    }

    public Attributes getMainAttributes() {
        return this.mainAttributes;
    }

    public Map getEntries() {
        return this.entries;
    }

    public Attributes getAttributes(String name) {
        return (Attributes)this.getEntries().get(name);
    }

    public void clear() {
        this.mainAttributes.clear();
        this.entries.clear();
    }

    public Object clone() {
        Manifest cloned = null;
        try {
            cloned = (Manifest)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        cloned.mainAttributes = (Attributes)this.mainAttributes.clone();
        cloned.entries = (HashMap)this.entries.clone();
        return cloned;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Manifest)) {
            return false;
        }
        Manifest eq = (Manifest)o;
        return eq.mainAttributes.equals(this.mainAttributes) && eq.entries.equals(this.entries);
    }

    public void read(InputStream in) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        Attributes attributes = this.mainAttributes;
        String at = br.readLine();
        boolean validEntry = true;
        while (at != null) {
            String att = at;
            at = br.readLine();
            while (at != null && at.startsWith(" ")) {
                att = att + at.substring(1);
                at = br.readLine();
            }
            if (!att.equals("")) {
                int sep = att.indexOf(NVSep);
                if (sep < 0) {
                    throw new IOException("Invalid manifest entry: '" + att + "'");
                }
                if (!validEntry) continue;
                String name = att.substring(0, sep);
                String value = att.substring(sep + 2);
                if (attributes == null) {
                    if (name.equals("Name")) {
                        attributes = (Attributes)this.entries.get(value);
                        if (attributes != null) continue;
                        attributes = new Attributes(13);
                        this.entries.put(name, attributes);
                        continue;
                    }
                    validEntry = false;
                    continue;
                }
                attributes.putValue(name, value);
                continue;
            }
            attributes = null;
            validEntry = true;
        }
    }

    public void write(OutputStream os) throws IOException {
        this.writeAttributes(os, this.mainAttributes);
        Iterator it = this.entries.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry me = (Map.Entry)it.next();
            StringBuffer buf = new StringBuffer(LineSep);
            buf.append("Name: ");
            buf.append((String)me.getKey());
            os.write(newline);
            this.writeBuffer(os, buf);
            this.writeAttributes(os, (Attributes)me.getValue());
        }
    }

    private void writeAttributes(OutputStream os, Attributes at) throws IOException {
        Iterator it = at.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry me = (Map.Entry)it.next();
            StringBuffer buf = new StringBuffer(((Attributes.Name)me.getKey()).toString());
            buf.append(NVSep);
            buf.append((String)me.getValue());
            this.writeBuffer(os, buf);
        }
    }

    private void writeBuffer(OutputStream os, StringBuffer buf) throws IOException {
        int len = buf.length();
        int offset = 0;
        byte[] bytes = new String(buf).getBytes();
        while (len > 0) {
            if (len > MAX_LINELENGTH) {
                os.write(bytes, offset, len);
                os.write(newline);
                os.write(32);
                len -= MAX_LINELENGTH;
                offset += MAX_LINELENGTH;
                continue;
            }
            os.write(bytes, offset, len);
            os.write(newline);
            break;
        }
    }
}

