/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.Date;
import java.util.TimerTask;
import java.util.TimerThread;

public class Timer {
    private TimerThread thread;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void cancel() {
        if (this.thread.cancelled) return;
        TimerThread timerThread = this.thread;
        synchronized (timerThread) {
            this.thread.cancelled = true;
            if (!this.thread.waiting) return;
            this.thread.notifyAll();
            return;
        }
    }

    public void schedule(TimerTask task, Date date) {
        this.thread.scheduleAtTime(task, date.getTime(), -1, false);
    }

    public void schedule(TimerTask task, Date date, long period) {
        if (period <= 0L) {
            throw new IllegalArgumentException();
        }
        this.thread.scheduleAtTime(task, date.getTime(), period, false);
    }

    public void schedule(TimerTask task, long delay) {
        this.thread.schedule(task, delay, -1, false);
    }

    public void schedule(TimerTask task, long delay, long period) {
        if (period <= 0L) {
            throw new IllegalArgumentException();
        }
        this.thread.schedule(task, delay, period, false);
    }

    public void scheduleAtFixedRate(TimerTask task, Date date, long period) {
        if (period <= 0L) {
            throw new IllegalArgumentException();
        }
        this.thread.scheduleAtTime(task, date.getTime(), period, true);
    }

    public void scheduleAtFixedRate(TimerTask task, long delay, long period) {
        if (period <= 0L) {
            throw new IllegalArgumentException();
        }
        this.thread.schedule(task, delay, period, true);
    }

    public Timer() {
        this(false);
    }

    public Timer(boolean daemon) {
        this.thread = new TimerThread(this, daemon);
    }
}

