/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;

public abstract class ResourceBundle {
    private Locale locale;
    protected ResourceBundle parent = null;
    private static final Hashtable cache = new Hashtable();
    private static final char underscore = '_';

    protected void setParent(ResourceBundle p) {
        this.parent = p;
    }

    protected abstract Object handleGetObject(String var1) throws MissingResourceException;

    public abstract Enumeration getKeys();

    public Locale getLocale() {
        return this.locale;
    }

    public final Object getObject(String key) throws MissingResourceException {
        ResourceBundle check = this;
        Object o = null;
        while (check != null) {
            o = check.handleGetObject(key);
            if (o != null) {
                return o;
            }
            check = check.parent;
        }
        throw new MissingResourceException("key not found", this.getClass().getName(), key);
    }

    public final String getString(String key) throws MissingResourceException {
        return (String)this.getObject(key);
    }

    public final String[] getStringArray(String key) throws MissingResourceException {
        return (String[])this.getObject(key);
    }

    public static final ResourceBundle getBundle(String baseName) throws MissingResourceException {
        return ResourceBundle.getBundle(baseName, Locale.getDefault(), ResourceBundle.getCallingClassLoader(), true);
    }

    public static final ResourceBundle getBundle(String baseName, Locale locale) throws MissingResourceException {
        return ResourceBundle.getBundle(baseName, locale, ResourceBundle.getCallingClassLoader(), locale.equals(Locale.getDefault()));
    }

    public static final ResourceBundle getBundle(String baseName, Locale locale, ClassLoader loader) throws MissingResourceException {
        return ResourceBundle.getBundle(baseName, locale, loader, locale.equals(Locale.getDefault()));
    }

    private static native ClassLoader getCallingClassLoader();

    private static String cutEnd(String name) {
        int i = name.lastIndexOf(95);
        return i == -1 ? "" : name.substring(0, i);
    }

    private static final ResourceBundle getBundle(String baseName, Locale locale, ClassLoader loader, boolean defaultLoc) throws MissingResourceException {
        String local;
        ResourceBundle newBundle;
        block11: {
            if (baseName == null) {
                throw new NullPointerException();
            }
            Class rbClass = null;
            newBundle = null;
            local = baseName + "_" + locale.toString();
            while (true) {
                if ((newBundle = (ResourceBundle)cache.get(local)) != null) {
                    return newBundle;
                }
                try {
                    rbClass = Class.forName(local, true, loader);
                }
                catch (ClassNotFoundException cnfe) {
                    InputStream in;
                    InputStream inputStream = in = loader == null ? ClassLoader.getSystemResourceAsStream(local.replace('.', '/') + ".properties") : loader.getResourceAsStream(local.replace('.', '/') + ".properties");
                    if (in == null) {
                        if ((!(local = ResourceBundle.cutEnd(local)).equals(baseName) || defaultLoc) && !local.equals("")) continue;
                        if (!defaultLoc) {
                            defaultLoc = true;
                            local = baseName + "_" + Locale.getDefault().toString();
                            continue;
                        }
                        throw new MissingResourceException("couldn't find resourceBundle", baseName, locale.toString());
                    }
                    try {
                        newBundle = new PropertyResourceBundle(in);
                        break block11;
                    }
                    catch (IOException ioe) {
                        continue;
                    }
                }
                break;
            }
            try {
                newBundle = (ResourceBundle)rbClass.newInstance();
            }
            catch (Exception e) {
                throw new MissingResourceException("got exception while instantiating resourceBundle", local, e.toString());
            }
        }
        newBundle.setParent(ResourceBundle.findParent(ResourceBundle.cutEnd(local), loader));
        newBundle.locale = locale;
        cache.put(local, newBundle);
        return newBundle;
    }

    private static ResourceBundle findParent(String name, ClassLoader loader) {
        if (name.equals("")) {
            return null;
        }
        ResourceBundle rb = (ResourceBundle)cache.get(name);
        if (rb != null) {
            return rb;
        }
        try {
            rb = (ResourceBundle)Class.forName(name, true, loader).newInstance();
        }
        catch (Exception e) {
            try {
                rb = new PropertyResourceBundle(loader == null ? ClassLoader.getSystemResourceAsStream(name.replace('.', '/') + ".properties") : loader.getResourceAsStream(name.replace('.', '/') + ".properties"));
            }
            catch (Exception pe) {
                return null;
            }
        }
        rb.setParent(ResourceBundle.findParent(ResourceBundle.cutEnd(name), loader));
        cache.put(name, rb);
        return rb;
    }
}

