/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;

public class Random
implements Serializable {
    private static final long serialVersionUID = 3905348978240129619L;
    protected long seed;
    protected double nextNextGaussian;
    protected boolean haveNextNextGaussian;
    private transient Long saved_seed;

    public Random() {
        if (this.saved_seed == null) {
            this.saved_seed = new Long(System.currentTimeMillis());
            this.seed = (this.saved_seed ^ 0x5DEECE66DL) & 0xFFFFFFFFFFFFL;
        }
        this.setSeed(this.saved_seed);
    }

    public Random(long seed) {
        this.setSeed(seed);
    }

    public void setSeed(long seed) {
        this.seed = (seed ^ 0x5DEECE66DL) & 0xFFFFFFFFFFFFL;
        this.haveNextNextGaussian = false;
    }

    protected int next(int bits) {
        this.seed = this.seed * 25214903917L + 11L & 0xFFFFFFFFFFFFL;
        return (int)(this.seed >>> 48 - bits);
    }

    public int nextInt() {
        return this.next(32);
    }

    public int nextInt(int n) {
        int val;
        int bits;
        if (n <= 0) {
            throw new IllegalArgumentException("n must be positive");
        }
        if ((n & -n) == n) {
            return (int)((long)n * (long)this.next(31) >> 31);
        }
        while ((bits = this.next(31)) - (val = bits % n) + (n - 1) < 0) {
        }
        return val;
    }

    public long nextLong() {
        return ((long)this.next(32) << 32) + (long)this.next(32);
    }

    public float nextFloat() {
        return (float)this.next(24) / 1.6777216E7f;
    }

    public double nextDouble() {
        return (double)(((long)this.next(26) << 27) + (long)this.next(27)) / 9.007199254740992E15;
    }

    public double nextGaussian() {
        double v2;
        double v1;
        double s;
        if (this.haveNextNextGaussian) {
            this.haveNextNextGaussian = false;
            return this.nextNextGaussian;
        }
        while ((s = (v1 = 2.0 * this.nextDouble() - 1.0) * v1 + (v2 = 2.0 * this.nextDouble() - 1.0) * v2) >= 1.0) {
        }
        double norm = Math.sqrt(-2.0 * Math.log(s) / s);
        this.nextNextGaussian = v2 * norm;
        this.haveNextNextGaussian = true;
        return v1 * norm;
    }

    public void nextBytes(byte[] buf) {
        for (int i = 0; i < buf.length; ++i) {
            buf[i] = (byte)this.next(8);
        }
    }

    public boolean nextBoolean() {
        return this.next(1) != 0;
    }
}

