/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Observer;

public class Observable {
    private HashSet observers = new HashSet(11);
    private boolean changed;

    protected void clearChanged() {
        this.changed = false;
    }

    protected void setChanged() {
        this.changed = true;
    }

    public void addObserver(Observer o) {
        if (o == null) {
            throw new NullPointerException();
        }
        this.observers.add(o);
    }

    public int countObservers() {
        return this.observers.size();
    }

    public void deleteObserver(Observer o) {
        this.observers.remove(o);
    }

    public void deleteObservers() {
        this.observers.clear();
    }

    public boolean hasChanged() {
        return this.changed;
    }

    public void notifyObservers() {
        this.notifyObservers(null);
    }

    public void notifyObservers(Object arg) {
        if (this.changed) {
            Iterator it = this.observers.iterator();
            while (it.hasNext()) {
                ((Observer)it.next()).update(this, arg);
            }
            this.changed = false;
        }
    }
}

