/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractSequentialList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class LinkedList
extends AbstractSequentialList
implements List,
Cloneable,
Serializable {
    private static final long serialVersionUID = 876323262645176354L;
    private transient int size = 0;
    private transient Link first;
    private transient Link stop = new Link(null, null, "BUG: the LinkedList got screwed up! --> last element is bad");

    public LinkedList() {
        this.first = new Link(null, this.stop, "BUG: the LinkedList got screwed up! --> first element is bad");
        this.stop.after = this.stop;
        this.stop.before = this.first;
        this.first.before = this.first;
        this.first.after = this.stop;
    }

    public LinkedList(Collection c) {
        this();
        this.addAll(c);
    }

    public boolean add(Object e) {
        Link l;
        ++this.modCount;
        l.before.after = l = new Link(this.stop.before, this.stop, e);
        this.stop.before = l;
        ++this.size;
        return true;
    }

    public void addLast(Object e) {
        this.add(e);
    }

    public void addFirst(Object e) {
        Link l;
        ++this.modCount;
        l.after.before = l = new Link(this.first, this.first.after, e);
        this.first.after = l;
        ++this.size;
    }

    public void clear() {
        ++this.modCount;
        this.size = 0;
        this.first.after = this.stop;
        this.stop.before = this.first;
    }

    public Object getFirst() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.first.after.data;
    }

    public Object getLast() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.stop.before.data;
    }

    public Object removeFirst() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        Link l = this.first.after;
        Object o = l.data;
        ++this.modCount;
        this.first.after = l.after;
        l.after.before = this.first;
        --this.size;
        return o;
    }

    public Object removeLast() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        Link last = this.stop.before;
        Object o = last.data;
        ++this.modCount;
        last.before.after = this.stop;
        this.stop.before = last.before;
        --this.size;
        return o;
    }

    public boolean addAll(Collection c) {
        int sz = c.size();
        if (sz == 0) {
            return false;
        }
        Iterator it = c.iterator();
        ++this.modCount;
        this.size += sz;
        Link l = this.stop.before;
        while (it.hasNext()) {
            l = l.after = new Link(l, this.stop, it.next());
        }
        this.stop.before = l;
        return true;
    }

    private Link findLink(int position) {
        Link l = null;
        if (position < this.size / 2 + 1) {
            l = this.first.after;
            while (position-- > 0) {
                l = l.after;
            }
        } else {
            l = this.stop;
            while (position++ < this.size) {
                l = l.before;
            }
        }
        return l;
    }

    public boolean addAll(int idx, Collection c) {
        if (idx < 0 || idx > this.size) {
            throw new IndexOutOfBoundsException();
        }
        int sz = c.size();
        if (sz == 0) {
            return false;
        }
        Iterator it = c.iterator();
        ++this.modCount;
        Link next = this.stop;
        if (idx != this.size) {
            next = this.findLink(idx);
        }
        Link l = next.before;
        this.size += sz;
        while (it.hasNext()) {
            l = l.after = new Link(l, next, it.next());
        }
        next.before = l;
        return true;
    }

    public void add(int idx, Object e) {
        if (idx < 0 || idx > this.size) {
            throw new IndexOutOfBoundsException();
        }
        Link l = this.stop;
        if (idx < this.size) {
            l = this.findLink(idx);
        }
        ++this.modCount;
        ++this.size;
        l.before.after = l = new Link(l.before, l, e);
        l.after.before = l;
    }

    public Object remove(int idx) {
        if (idx < 0 || idx >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        Link l = this.findLink(idx);
        ++this.modCount;
        --this.size;
        l.before.after = l.after;
        l.after.before = l.before;
        return l.data;
    }

    public Object set(int idx, Object e) {
        if (idx < 0 || idx >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        Link l = this.findLink(idx);
        Object d = l.data;
        l.data = e;
        return d;
    }

    public boolean contains(Object o) {
        Link l = this.first.after;
        if (o == null) {
            for (int i = 0; i < this.size; ++i) {
                if (l.data == null) {
                    return true;
                }
                l = l.after;
            }
        } else {
            for (int i = 0; i < this.size; ++i) {
                if (o.equals(l.data)) {
                    return true;
                }
                l = l.after;
            }
        }
        return false;
    }

    public int indexOf(Object o) {
        Link l = this.first.after;
        if (o == null) {
            for (int i = 0; i < this.size; ++i) {
                if (l.data == null) {
                    return i;
                }
                l = l.after;
            }
        } else {
            for (int i = 0; i < this.size; ++i) {
                if (o.equals(l.data)) {
                    return i;
                }
                l = l.after;
            }
        }
        return -1;
    }

    public int lastIndexOf(Object o) {
        Link l = this.stop.before;
        if (o == null) {
            for (int i = this.size - 1; i >= 0; --i) {
                if (l.data == null) {
                    return i;
                }
                l = l.before;
            }
        } else {
            for (int i = this.size - 1; i >= 0; --i) {
                if (o.equals(l.data)) {
                    return i;
                }
                l = l.before;
            }
        }
        return -1;
    }

    public boolean remove(Object e) {
        Link l = this.first.after;
        if (e == null) {
            for (int i = 0; i < this.size; ++i) {
                if (l.data == null) {
                    l.before.after = l.after;
                    l.after.before = l.before;
                    --this.size;
                    return true;
                }
                l = l.after;
            }
        } else {
            for (int i = 0; i < this.size; ++i) {
                if (e.equals(l.data)) {
                    l.before.after = l.after;
                    l.after.before = l.before;
                    --this.size;
                    return true;
                }
                l = l.after;
            }
        }
        return false;
    }

    public Object[] toArray() {
        Object[] array = new Object[this.size];
        Link l = this.first.after;
        for (int i = 0; i < this.size; ++i) {
            array[i] = l.data;
            l = l.after;
        }
        return array;
    }

    public Object[] toArray(Object[] arr) {
        Object[] array = arr;
        if (array.length < this.size) {
            array = (Object[])Array.newInstance(arr.getClass().getComponentType(), this.size);
        }
        if (array.length > this.size) {
            array[this.size] = null;
        }
        Link l = this.first.after;
        for (int i = 0; i < this.size; ++i) {
            array[i] = l.data;
            l = l.after;
        }
        return array;
    }

    public Object clone() {
        LinkedList ll = null;
        try {
            ll = (LinkedList)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        ll.size = 0;
        ll.stop = new Link(null, null, "BUG: the LinkedList got screwed up! --> last element is bad");
        ll.first = new Link(null, ll.stop, "BUG: the LinkedList got screwed up! --> first element is bad");
        ll.stop.after = ll.stop;
        ll.stop.before = ll.first;
        ll.first.before = ll.first;
        ll.addAll(this);
        return ll;
    }

    public int size() {
        return this.size;
    }

    public ListIterator listIterator(int i) {
        if (i < 0 || i > this.size) {
            throw new IndexOutOfBoundsException();
        }
        return new LListIterator(i);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int s = in.readInt();
        for (int i = 0; i < s; ++i) {
            this.add(in.readObject());
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        int s = this.size;
        out.writeInt(s);
        Link l = this.first.after;
        for (int i = 0; i < s; ++i) {
            out.writeObject(l.data);
            l = l.after;
        }
    }

    private class Link {
        public Link before;
        public Link after;
        public Object data;

        public Link(Link f, Link a, Object d) {
            this.before = f;
            this.after = a;
            this.data = d;
        }

        public Link(Object d) {
            this.before = null;
            this.after = null;
            this.data = d;
        }
    }

    private class LListIterator
    implements ListIterator {
        private int index;
        private int status = 0;
        private int m;
        private Link link;

        public LListIterator(int idx) {
            this.m = LinkedList.this.modCount;
            this.index = idx;
            this.link = LinkedList.this.findLink(idx);
        }

        public Object next() {
            if (LinkedList.this.modCount != this.m) {
                throw new ConcurrentModificationException();
            }
            if (LinkedList.this.size <= this.index) {
                throw new NoSuchElementException("No next element");
            }
            Object answer = this.link.data;
            ++this.index;
            this.link = this.link.after;
            this.status = -1;
            return answer;
        }

        public Object previous() {
            if (LinkedList.this.modCount != this.m) {
                throw new ConcurrentModificationException();
            }
            if (this.index <= 0) {
                throw new NoSuchElementException("No previous element");
            }
            --this.index;
            this.status = 1;
            this.link = this.link.before;
            Object answer = this.link.data;
            return answer;
        }

        public boolean hasNext() {
            return this.index < LinkedList.this.size;
        }

        public boolean hasPrevious() {
            return this.index > 0;
        }

        public int nextIndex() {
            return this.index;
        }

        public int previousIndex() {
            return this.index - 1;
        }

        public void add(Object e) {
            Link l;
            if (LinkedList.this.modCount != this.m) {
                throw new ConcurrentModificationException();
            }
            this.status = 0;
            ++this.m;
            this.link.before = l = new Link(this.link.before, this.link, e);
            l.before.after = l;
            ++LinkedList.this.modCount;
            LinkedList.this.size++;
            ++this.index;
            if (LinkedList.this.modCount != this.m) {
                throw new ConcurrentModificationException("warning: the original LinkedList might be corrupted");
            }
        }

        public void remove() {
            if (LinkedList.this.modCount != this.m) {
                throw new ConcurrentModificationException();
            }
            if (this.status == 0) {
                throw new IllegalStateException("remove must be called after next or previous");
            }
            if (this.status == -1) {
                --this.index;
                this.link = this.link.before;
            }
            this.status = 0;
            ++this.m;
            ++LinkedList.this.modCount;
            LinkedList.this.size--;
            Link l = this.link.after;
            l.before = this.link.before;
            this.link.before.after = l;
            this.link = l;
            if (LinkedList.this.modCount != this.m) {
                throw new ConcurrentModificationException("warning: the original LinkedList might be corrupted");
            }
        }

        public void set(Object e) {
            if (LinkedList.this.modCount != this.m) {
                throw new ConcurrentModificationException();
            }
            if (this.status == 0) {
                throw new IllegalStateException("set must be called after next or previous");
            }
            ++this.m;
            ++LinkedList.this.modCount;
            if (this.status == -1) {
                this.link.before.data = e;
            } else {
                this.link.data = e;
            }
            if (LinkedList.this.modCount != this.m) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

