/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.AbstractList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class Arrays {
    public static List asList(Object[] arr) {
        if (arr == null) {
            throw new NullPointerException();
        }
        return new AsList(arr);
    }

    public static int binarySearch(byte[] arr, byte e) {
        int size = arr.length;
        for (int i = 0; i < size; ++i) {
            if (e == arr[i]) {
                return i;
            }
            if (e >= arr[i]) continue;
            size = i;
        }
        return -(size + 1);
    }

    public static int binarySearch(short[] arr, short e) {
        int size = arr.length;
        for (int i = 0; i < size; ++i) {
            if (e == arr[i]) {
                return i;
            }
            if (e >= arr[i]) continue;
            size = i;
        }
        return -(size + 1);
    }

    public static int binarySearch(char[] arr, char e) {
        int size = arr.length;
        for (int i = 0; i < size; ++i) {
            if (e == arr[i]) {
                return i;
            }
            if (e >= arr[i]) continue;
            size = i;
        }
        return -(size + 1);
    }

    public static int binarySearch(int[] arr, int e) {
        int size = arr.length;
        for (int i = 0; i < size; ++i) {
            if (e == arr[i]) {
                return i;
            }
            if (e >= arr[i]) continue;
            size = i;
        }
        return -(size + 1);
    }

    public static int binarySearch(long[] arr, long e) {
        int size = arr.length;
        for (int i = 0; i < size; ++i) {
            if (e == arr[i]) {
                return i;
            }
            if (e >= arr[i]) continue;
            size = i;
        }
        return -(size + 1);
    }

    public static int binarySearch(float[] arr, float e) {
        int size = arr.length;
        for (int i = 0; i < size; ++i) {
            if (e == arr[i]) {
                return i;
            }
            if (!(e < arr[i])) continue;
            size = i;
        }
        return -(size + 1);
    }

    public static int binarySearch(double[] arr, double e) {
        int size = arr.length;
        for (int i = 0; i < size; ++i) {
            if (e == arr[i]) {
                return i;
            }
            if (!(e < arr[i])) continue;
            size = i;
        }
        return -(size + 1);
    }

    public static int binarySearch(Object[] arr, Object e) {
        return Arrays.binarySearch(arr, e, new Collections.StdComparator());
    }

    public static int binarySearch(Object[] arr, Object e, Comparator comp) {
        int size = arr.length;
        for (int i = 0; i < size; ++i) {
            int cmp = comp.compare(e, arr[i]);
            if (cmp == 0) {
                return i;
            }
            if (cmp >= 0) continue;
            size = i;
        }
        return -(size + 1);
    }

    public static native void fill(boolean[] var0, boolean var1);

    public static void fill(boolean[] arr, int from, int to, boolean val) {
        if (from < 0 || to < 0 || from > arr.length || to > arr.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (from > to) {
            throw new IllegalArgumentException();
        }
        for (int i = from; i < to; ++i) {
            arr[i] = val;
        }
    }

    public static native void fill(byte[] var0, byte var1);

    public static native void fill(byte[] var0, int var1, int var2, byte var3);

    public static void fill(char[] arr, char val) {
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = val;
        }
    }

    public static void fill(char[] arr, int from, int to, char val) {
        if (from < 0 || to < 0 || from > arr.length || to > arr.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (from > to) {
            throw new IllegalArgumentException();
        }
        for (int i = from; i < to; ++i) {
            arr[i] = val;
        }
    }

    public static void fill(short[] arr, short val) {
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = val;
        }
    }

    public static void fill(short[] arr, int from, int to, short val) {
        if (from < 0 || to < 0 || from > arr.length || to > arr.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (from > to) {
            throw new IllegalArgumentException();
        }
        for (int i = from; i < to; ++i) {
            arr[i] = val;
        }
    }

    public static void fill(int[] arr, int val) {
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = val;
        }
    }

    public static void fill(int[] arr, int from, int to, int val) {
        if (from < 0 || to < 0 || from > arr.length || to > arr.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (from > to) {
            throw new IllegalArgumentException();
        }
        for (int i = from; i < to; ++i) {
            arr[i] = val;
        }
    }

    public static void fill(long[] arr, long val) {
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = val;
        }
    }

    public static void fill(long[] arr, int from, int to, long val) {
        if (from < 0 || to < 0 || from > arr.length || to > arr.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (from > to) {
            throw new IllegalArgumentException();
        }
        for (int i = from; i < to; ++i) {
            arr[i] = val;
        }
    }

    public static void fill(float[] arr, float val) {
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = val;
        }
    }

    public static void fill(float[] arr, int from, int to, float val) {
        if (from < 0 || to < 0 || from > arr.length || to > arr.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (from > to) {
            throw new IllegalArgumentException();
        }
        for (int i = from; i < to; ++i) {
            arr[i] = val;
        }
    }

    public static void fill(double[] arr, double val) {
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = val;
        }
    }

    public static void fill(double[] arr, int from, int to, double val) {
        if (from < 0 || to < 0 || from > arr.length || to > arr.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (from > to) {
            throw new IllegalArgumentException();
        }
        for (int i = from; i < to; ++i) {
            arr[i] = val;
        }
    }

    public static void fill(Object[] arr, Object val) {
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = val;
        }
    }

    public static void fill(Object[] arr, int from, int to, Object val) {
        if (from < 0 || to < 0 || from > arr.length || to > arr.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (from > to) {
            throw new IllegalArgumentException();
        }
        for (int i = from; i < to; ++i) {
            arr[i] = val;
        }
    }

    public static void sort(Object[] a, int start, int end, Comparator c) {
        if (end < start) {
            throw new IllegalArgumentException();
        }
        Arrays.quicksort(a, start, end - 1, c);
    }

    public static void sort(Object[] a, Comparator c) {
        Arrays.quicksort(a, 0, a.length - 1, c);
    }

    public static void sort(Object[] a) {
        Arrays.quicksort(a, 0, a.length - 1, new Collections.StdComparator());
    }

    public static void sort(Object[] a, int start, int end) {
        if (end < start) {
            throw new IllegalArgumentException();
        }
        Arrays.quicksort(a, start, end - 1, new Collections.StdComparator());
    }

    private static void quicksort(Object[] list, int start, int end, Comparator c) {
        if (start < end) {
            int split = Arrays.partition(list, start, end, c);
            Arrays.quicksort(list, start, split - 1, c);
            Arrays.quicksort(list, split + 1, end, c);
        }
    }

    private static int partition(Object[] list, int start, int end, Comparator c) {
        Object pivot = list[end];
        int bottom = start - 1;
        int top = end;
        boolean done = false;
        block0: while (!done) {
            while (!done) {
                if (++bottom == top) {
                    done = true;
                    break;
                }
                if (c.compare(list[bottom], pivot) <= 0) continue;
                list[top] = list[bottom];
                break;
            }
            while (!done) {
                if (--top == bottom) {
                    done = true;
                    continue block0;
                }
                if (c.compare(list[top], pivot) >= 0) continue;
                list[bottom] = list[top];
                continue block0;
            }
        }
        list[top] = pivot;
        return top;
    }

    public static void sort(short[] s) {
        Arrays.quicksort(s, 0, s.length - 1);
    }

    public static void sort(short[] s, int start, int end) {
        if (end < start) {
            throw new IllegalArgumentException();
        }
        Arrays.quicksort(s, start, end - 1);
    }

    private static void quicksort(short[] list, int start, int end) {
        if (start < end) {
            int split = Arrays.partition(list, start, end);
            Arrays.quicksort(list, start, split - 1);
            Arrays.quicksort(list, split + 1, end);
        }
    }

    private static int partition(short[] list, int start, int end) {
        short pivot = list[end];
        int bottom = start - 1;
        int top = end;
        boolean done = false;
        block0: while (!done) {
            while (!done) {
                if (++bottom == top) {
                    done = true;
                    break;
                }
                if (list[bottom] <= pivot) continue;
                list[top] = list[bottom];
                break;
            }
            while (!done) {
                if (--top == bottom) {
                    done = true;
                    continue block0;
                }
                if (list[top] >= pivot) continue;
                list[bottom] = list[top];
                continue block0;
            }
        }
        list[top] = pivot;
        return top;
    }

    public static boolean equals(boolean[] a, boolean[] a2) {
        if (a == null && a2 == null) {
            return true;
        }
        if (a == null && a2 != null || a != null && a2 == null) {
            return false;
        }
        if (a.length != a2.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == a2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(byte[] a, byte[] a2) {
        if (a == null && a2 == null) {
            return true;
        }
        if (a == null && a2 != null || a != null && a2 == null) {
            return false;
        }
        if (a.length != a2.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == a2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(char[] a, char[] a2) {
        if (a == null && a2 == null) {
            return true;
        }
        if (a == null && a2 != null || a != null && a2 == null) {
            return false;
        }
        if (a.length != a2.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == a2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(double[] a, double[] a2) {
        if (a == null && a2 == null) {
            return true;
        }
        if (a == null && a2 != null || a != null && a2 == null) {
            return false;
        }
        if (a.length != a2.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (new Double(a[i]).equals(new Double(a2[i]))) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(float[] a, float[] a2) {
        if (a == null && a2 == null) {
            return true;
        }
        if (a == null && a2 != null || a != null && a2 == null) {
            return false;
        }
        if (a.length != a2.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (new Float(a[i]).equals(new Float(a2[i]))) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(int[] a, int[] a2) {
        if (a == null && a2 == null) {
            return true;
        }
        if (a == null && a2 != null || a != null && a2 == null) {
            return false;
        }
        if (a.length != a2.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == a2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(long[] a, long[] a2) {
        if (a == null && a2 == null) {
            return true;
        }
        if (a == null && a2 != null || a != null && a2 == null) {
            return false;
        }
        if (a.length != a2.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == a2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(Object[] a, Object[] a2) {
        if (a == null && a2 == null) {
            return true;
        }
        if (a == null || a2 == null) {
            return false;
        }
        if (a.length != a2.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i] != null ? a[i].equals(a2[i]) : a2[i] == null) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(short[] a, short[] a2) {
        if (a == null && a2 == null) {
            return true;
        }
        if (a == null && a2 != null || a != null && a2 == null) {
            return false;
        }
        if (a.length != a2.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == a2[i]) continue;
            return false;
        }
        return true;
    }

    public static void sort(byte[] s) {
        Arrays.quicksort(s, 0, s.length - 1);
    }

    public static void sort(byte[] s, int start, int end) {
        if (end < start) {
            throw new IllegalArgumentException();
        }
        Arrays.quicksort(s, start, end - 1);
    }

    private static void quicksort(byte[] list, int start, int end) {
        if (start < end) {
            int split = Arrays.partition(list, start, end);
            Arrays.quicksort(list, start, split - 1);
            Arrays.quicksort(list, split + 1, end);
        }
    }

    private static int partition(byte[] list, int start, int end) {
        byte pivot = list[end];
        int bottom = start - 1;
        int top = end;
        boolean done = false;
        block0: while (!done) {
            while (!done) {
                if (++bottom == top) {
                    done = true;
                    break;
                }
                if (list[bottom] <= pivot) continue;
                list[top] = list[bottom];
                break;
            }
            while (!done) {
                if (--top == bottom) {
                    done = true;
                    continue block0;
                }
                if (list[top] >= pivot) continue;
                list[bottom] = list[top];
                continue block0;
            }
        }
        list[top] = pivot;
        return top;
    }

    public static void sort(char[] s) {
        Arrays.quicksort(s, 0, s.length - 1);
    }

    public static void sort(char[] s, int start, int end) {
        if (end < start) {
            throw new IllegalArgumentException();
        }
        Arrays.quicksort(s, start, end - 1);
    }

    private static void quicksort(char[] list, int start, int end) {
        if (start < end) {
            int split = Arrays.partition(list, start, end);
            Arrays.quicksort(list, start, split - 1);
            Arrays.quicksort(list, split + 1, end);
        }
    }

    private static int partition(char[] list, int start, int end) {
        char pivot = list[end];
        int bottom = start - 1;
        int top = end;
        boolean done = false;
        block0: while (!done) {
            while (!done) {
                if (++bottom == top) {
                    done = true;
                    break;
                }
                if (list[bottom] <= pivot) continue;
                list[top] = list[bottom];
                break;
            }
            while (!done) {
                if (--top == bottom) {
                    done = true;
                    continue block0;
                }
                if (list[top] >= pivot) continue;
                list[bottom] = list[top];
                continue block0;
            }
        }
        list[top] = pivot;
        return top;
    }

    public static void sort(double[] s) {
        Arrays.quicksort(s, 0, s.length - 1);
    }

    public static void sort(double[] s, int start, int end) {
        if (end < start) {
            throw new IllegalArgumentException();
        }
        Arrays.quicksort(s, start, end - 1);
    }

    private static void quicksort(double[] list, int start, int end) {
        if (start < end) {
            int split = Arrays.partition(list, start, end);
            Arrays.quicksort(list, start, split - 1);
            Arrays.quicksort(list, split + 1, end);
        }
    }

    private static int partition(double[] list, int start, int end) {
        double pivot = list[end];
        int bottom = start - 1;
        int top = end;
        boolean done = false;
        block0: while (!done) {
            while (!done) {
                if (++bottom == top) {
                    done = true;
                    break;
                }
                if (!(list[bottom] > pivot)) continue;
                list[top] = list[bottom];
                break;
            }
            while (!done) {
                if (--top == bottom) {
                    done = true;
                    continue block0;
                }
                if (!(list[top] < pivot)) continue;
                list[bottom] = list[top];
                continue block0;
            }
        }
        list[top] = pivot;
        return top;
    }

    public static void sort(float[] s) {
        Arrays.quicksort(s, 0, s.length - 1);
    }

    public static void sort(float[] s, int start, int end) {
        if (end < start) {
            throw new IllegalArgumentException();
        }
        Arrays.quicksort(s, start, end - 1);
    }

    private static void quicksort(float[] list, int start, int end) {
        if (start < end) {
            int split = Arrays.partition(list, start, end);
            Arrays.quicksort(list, start, split - 1);
            Arrays.quicksort(list, split + 1, end);
        }
    }

    private static int partition(float[] list, int start, int end) {
        float pivot = list[end];
        int bottom = start - 1;
        int top = end;
        boolean done = false;
        block0: while (!done) {
            while (!done) {
                if (++bottom == top) {
                    done = true;
                    break;
                }
                if (!(list[bottom] > pivot)) continue;
                list[top] = list[bottom];
                break;
            }
            while (!done) {
                if (--top == bottom) {
                    done = true;
                    continue block0;
                }
                if (!(list[top] < pivot)) continue;
                list[bottom] = list[top];
                continue block0;
            }
        }
        list[top] = pivot;
        return top;
    }

    public static void sort(int[] s) {
        Arrays.quicksort(s, 0, s.length - 1);
    }

    public static void sort(int[] s, int start, int end) {
        if (end < start) {
            throw new IllegalArgumentException();
        }
        Arrays.quicksort(s, start, end - 1);
    }

    private static void quicksort(int[] list, int start, int end) {
        if (start < end) {
            int split = Arrays.partition(list, start, end);
            Arrays.quicksort(list, start, split - 1);
            Arrays.quicksort(list, split + 1, end);
        }
    }

    private static int partition(int[] list, int start, int end) {
        int pivot = list[end];
        int bottom = start - 1;
        int top = end;
        boolean done = false;
        block0: while (!done) {
            while (!done) {
                if (++bottom == top) {
                    done = true;
                    break;
                }
                if (list[bottom] <= pivot) continue;
                list[top] = list[bottom];
                break;
            }
            while (!done) {
                if (--top == bottom) {
                    done = true;
                    continue block0;
                }
                if (list[top] >= pivot) continue;
                list[bottom] = list[top];
                continue block0;
            }
        }
        list[top] = pivot;
        return top;
    }

    public static void sort(long[] s) {
        Arrays.quicksort(s, 0, s.length - 1);
    }

    public static void sort(long[] s, int start, int end) {
        if (end < start) {
            throw new IllegalArgumentException();
        }
        Arrays.quicksort(s, start, end - 1);
    }

    private static void quicksort(long[] list, int start, int end) {
        if (start < end) {
            int split = Arrays.partition(list, start, end);
            Arrays.quicksort(list, start, split - 1);
            Arrays.quicksort(list, split + 1, end);
        }
    }

    private static int partition(long[] list, int start, int end) {
        long pivot = list[end];
        int bottom = start - 1;
        int top = end;
        boolean done = false;
        block0: while (!done) {
            while (!done) {
                if (++bottom == top) {
                    done = true;
                    break;
                }
                if (list[bottom] <= pivot) continue;
                list[top] = list[bottom];
                break;
            }
            while (!done) {
                if (--top == bottom) {
                    done = true;
                    continue block0;
                }
                if (list[top] >= pivot) continue;
                list[bottom] = list[top];
                continue block0;
            }
        }
        list[top] = pivot;
        return top;
    }

    private static class AsList
    extends AbstractList {
        private Object[] back;

        public AsList(Object[] arr) {
            this.back = arr;
        }

        public Object set(int idx, Object e) {
            Object old = this.back[idx];
            this.back[idx] = e;
            return old;
        }

        public int size() {
            return this.back.length;
        }

        public Object get(int idx) {
            return this.back[idx];
        }
    }
}

