/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public abstract class AbstractList
extends AbstractCollection
implements List {
    protected transient int modCount = 0;

    protected AbstractList() {
    }

    public abstract Object get(int var1);

    public Object set(int index, Object element) throws UnsupportedOperationException, ClassCastException, IllegalArgumentException {
        throw new UnsupportedOperationException("method set from AbtstractList, called by " + this.getClass());
    }

    public Object remove(int index) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("method remove from AbtstractList, called by " + this.getClass());
    }

    public void add(int index, Object Element) throws UnsupportedOperationException, ClassCastException, IllegalArgumentException {
        throw new UnsupportedOperationException("method add from AbtstractList, called by " + this.getClass());
    }

    public boolean add(Object o) throws UnsupportedOperationException, ClassCastException, IllegalArgumentException {
        this.add(this.size(), o);
        return true;
    }

    public boolean addAll(int index, Collection c) {
        boolean changedList = false;
        Iterator it = c.iterator();
        while (it.hasNext()) {
            this.add(index++, it.next());
            changedList = true;
        }
        return changedList;
    }

    public int indexOf(Object o) throws UnsupportedOperationException {
        Iterator it = this.iterator();
        int i = 0;
        if (o == null) {
            while (it.hasNext()) {
                if (it.next() == null) {
                    return i;
                }
                ++i;
            }
        } else {
            while (it.hasNext()) {
                if (o.equals(it.next())) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public int hashCode() {
        int hash = 1;
        Iterator it = this.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            hash = hash * 31 + (o == null ? 0 : o.hashCode());
        }
        return hash;
    }

    public boolean equals(Object o) {
        if (!(o instanceof List)) {
            return false;
        }
        List l = (List)o;
        if (l.size() != this.size()) {
            return false;
        }
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (this.get(i) != null ? this.get(i).equals(l.get(i)) : l.get(i) == null) continue;
            return false;
        }
        return true;
    }

    public int lastIndexOf(Object o) throws UnsupportedOperationException {
        int i = this.size();
        ListIterator lit = this.listIterator(i);
        if (o == null) {
            while (lit.hasPrevious()) {
                --i;
                if (lit.previous() != null) continue;
                return i;
            }
        } else {
            while (lit.hasPrevious()) {
                --i;
                if (!o.equals(lit.previous())) continue;
                return i;
            }
        }
        return -1;
    }

    public void clear() {
        this.removeRange(0, this.size());
    }

    protected void removeRange(int frix, int toix) {
        if (frix < 0) {
            throw new IndexOutOfBoundsException("starting index < 0");
        }
        try {
            while (frix < toix) {
                this.remove(frix);
                --toix;
            }
        }
        catch (IndexOutOfBoundsException ioobe) {
            throw new NoSuchElementException("reached the end of the list --> stopped removing");
        }
    }

    private void deletefrominner(int i) {
        this.remove(i);
    }

    private void addfrominner(int i, Object o) {
        this.add(i, o);
    }

    private void setfrominner(int i, Object o) {
        this.set(i, o);
    }

    public Iterator iterator() {
        return new _Iterator();
    }

    public ListIterator listIterator() throws UnsupportedOperationException {
        return this.listIterator(0);
    }

    public ListIterator listIterator(int index) throws UnsupportedOperationException {
        return new _ListIterator(index);
    }

    public List subList(int fromIndex, int toIndex) throws UnsupportedOperationException {
        if (fromIndex < 0 || toIndex > this.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (toIndex < fromIndex) {
            throw new IllegalArgumentException();
        }
        return new SubList(fromIndex, toIndex, this.modCount, this);
    }

    private class SubListListIterator
    implements ListIterator {
        private int current;
        private int status = 0;
        private int m;
        private int size;
        private int start;

        SubListListIterator(int start, int length) {
            this(0, start, length);
        }

        SubListListIterator(int first, int startidx, int length) {
            this.m = AbstractList.this.modCount;
            this.current = first;
            this.start = startidx;
            this.size = length;
        }

        public boolean hasNext() {
            return this.size > this.current;
        }

        public Object next() {
            if (AbstractList.this.modCount != this.m) {
                throw new ConcurrentModificationException();
            }
            if (this.size <= this.current) {
                throw new NoSuchElementException("No next element");
            }
            Object answer = AbstractList.this.get(this.current);
            ++this.current;
            this.status = -1;
            return answer;
        }

        public boolean hasPrevious() {
            return this.current > 0;
        }

        public Object previous() {
            if (AbstractList.this.modCount != this.m) {
                throw new ConcurrentModificationException();
            }
            if (this.current <= 0) {
                throw new NoSuchElementException("No previous element");
            }
            --this.current;
            this.status = 1;
            return AbstractList.this.get(this.current);
        }

        public int nextIndex() {
            return this.current;
        }

        public int previousIndex() {
            return this.current - 1;
        }

        public void remove() {
            if (AbstractList.this.modCount != this.m) {
                throw new ConcurrentModificationException();
            }
            if (this.status == 0) {
                throw new IllegalStateException("remove must be called after next or previous");
            }
            AbstractList.this.deletefrominner(this.start + this.current + this.status);
            if (this.status == -1) {
                --this.current;
            }
            this.status = 0;
            --this.size;
            ++this.m;
        }

        public void set(Object o) {
            if (AbstractList.this.modCount != this.m) {
                throw new ConcurrentModificationException();
            }
            if (this.status == 0) {
                throw new IllegalStateException("set must be called after next or previous");
            }
            AbstractList.this.setfrominner(this.start + this.current + this.status, o);
            ++this.m;
        }

        public void add(Object o) {
            if (AbstractList.this.modCount != this.m) {
                throw new ConcurrentModificationException();
            }
            if (this.status == 1) {
                ++this.current;
            }
            AbstractList.this.addfrominner(this.start + this.current, o);
            this.status = 0;
            ++this.m;
            ++this.size;
        }
    }

    private class SubList
    extends AbstractList {
        private int start;
        private int length;
        private AbstractList backList;

        public SubList(int from, int to, int mod, AbstractList backing) {
            this.start = from;
            this.length = to - from;
            this.modCount = mod;
            this.backList = backing;
        }

        public int size() {
            if (this.modCount != this.backList.modCount) {
                throw new ConcurrentModificationException();
            }
            return this.length;
        }

        public Object get(int pos) {
            if (pos < 0 || pos >= this.length) {
                throw new IndexOutOfBoundsException("in SubList from AbstractList method get");
            }
            if (this.modCount != this.backList.modCount) {
                throw new ConcurrentModificationException();
            }
            return this.backList.get(this.start + pos);
        }

        public Object set(int pos, Object o) {
            if (pos < 0 || pos >= this.length) {
                throw new IndexOutOfBoundsException("in SubList from AbstractList method set");
            }
            if (this.modCount != this.backList.modCount) {
                throw new ConcurrentModificationException();
            }
            return this.backList.set(this.start + pos, o);
        }

        public void add(int pos, Object o) {
            if (pos < 0 || pos > this.length) {
                throw new IndexOutOfBoundsException("in SubList from AbstractList method add");
            }
            if (this.modCount++ != this.backList.modCount) {
                throw new ConcurrentModificationException();
            }
            ++this.length;
            this.backList.add(this.start + pos, o);
        }

        public boolean addAll(int pos, Collection c) {
            if (c.isEmpty()) {
                return false;
            }
            Iterator it = c.iterator();
            while (it.hasNext()) {
                this.add(pos++, it.next());
            }
            return true;
        }

        public ListIterator listIterator(int idx) {
            if (this.modCount != this.backList.modCount) {
                throw new ConcurrentModificationException();
            }
            return new SubListListIterator(idx, this.start, this.length);
        }

        public Iterator iterator() {
            if (this.modCount != this.backList.modCount) {
                throw new ConcurrentModificationException();
            }
            return new SubListListIterator(0, this.start, this.length);
        }

        public Object remove(int pos) {
            if (pos < 0 || pos >= this.length) {
                throw new IndexOutOfBoundsException("in SubList from AbstractList method remove");
            }
            if (this.modCount++ != this.backList.modCount) {
                throw new ConcurrentModificationException();
            }
            --this.length;
            return this.backList.remove(this.start + pos);
        }

        protected void removeRange(int f, int t) {
            if (f < 0) {
                throw new IndexOutOfBoundsException("starting index < 0");
            }
            try {
                while (f < t) {
                    this.remove(f);
                    --t;
                }
            }
            catch (IndexOutOfBoundsException ioobe) {
                throw new NoSuchElementException("reached the end of the list --> stopped removing");
            }
        }
    }

    private class _ListIterator
    implements ListIterator {
        private int current;
        private int status = 1;
        private int m;

        _ListIterator() {
            this(0);
        }

        _ListIterator(int first) {
            this.m = AbstractList.this.modCount;
            this.current = first;
        }

        public boolean hasNext() {
            return AbstractList.this.size() > this.current;
        }

        public Object next() {
            if (AbstractList.this.modCount != this.m) {
                throw new ConcurrentModificationException();
            }
            if (AbstractList.this.size() <= this.current) {
                throw new NoSuchElementException("No next element");
            }
            Object answer = AbstractList.this.get(this.current);
            ++this.current;
            this.status = -1;
            return answer;
        }

        public boolean hasPrevious() {
            return this.current > 0;
        }

        public Object previous() {
            if (AbstractList.this.modCount != this.m) {
                throw new ConcurrentModificationException();
            }
            if (this.current <= 0) {
                throw new NoSuchElementException("No previous element");
            }
            --this.current;
            this.status = 0;
            return AbstractList.this.get(this.current);
        }

        public int nextIndex() {
            return this.current;
        }

        public int previousIndex() {
            return this.current - 1;
        }

        public void remove() {
            if (AbstractList.this.modCount != this.m) {
                throw new ConcurrentModificationException();
            }
            if (this.status == 1) {
                throw new IllegalStateException("remove must be called after next or previous");
            }
            AbstractList.this.deletefrominner(this.current + this.status);
            if (this.status == -1) {
                --this.current;
            }
            this.status = 1;
            ++this.m;
        }

        public void set(Object o) {
            if (AbstractList.this.modCount != this.m) {
                throw new ConcurrentModificationException();
            }
            if (this.status == 1) {
                throw new IllegalStateException("set must be called after next or previous");
            }
            AbstractList.this.setfrominner(this.current + this.status, o);
            ++this.m;
        }

        public void add(Object o) {
            if (AbstractList.this.modCount != this.m) {
                throw new ConcurrentModificationException();
            }
            AbstractList.this.addfrominner(this.current++, o);
            this.status = 1;
            ++this.m;
        }
    }

    private class _Iterator
    implements Iterator {
        private int i = 0;
        private int m;
        private int n;
        private int status;

        public _Iterator() {
            this.m = AbstractList.this.modCount;
            this.n = AbstractList.this.size();
            this.status = 0;
        }

        public boolean hasNext() {
            return this.i < AbstractList.this.size();
        }

        public Object next() throws UnsupportedOperationException {
            if (AbstractList.this.modCount != this.m) {
                throw new ConcurrentModificationException();
            }
            if (this.i >= AbstractList.this.size()) {
                throw new NoSuchElementException("Sorry no more Elements left");
            }
            this.status = 1;
            Object o = AbstractList.this.get(this.i++);
            if (AbstractList.this.modCount != this.m) {
                throw new ConcurrentModificationException("list was co-modified");
            }
            return o;
        }

        public void remove() throws ConcurrentModificationException, IllegalStateException {
            if (AbstractList.this.modCount != this.m) {
                throw new ConcurrentModificationException("in iterator " + this);
            }
            if (this.status != 1) {
                throw new IllegalStateException("remove() must be called after next()");
            }
            AbstractList.this.deletefrominner(this.i - 1);
            this.status = 0;
            ++this.m;
            --this.i;
            if (AbstractList.this.modCount != this.m) {
                throw new ConcurrentModificationException("the list is co-modified ! while removing");
            }
        }
    }
}

