/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.CharacterIterator;
import java.text.RuleBasedCollator;
import java.text.StringCharacterIterator;

public final class CollationElementIterator {
    public static final int NULLORDER = -1;
    private CharacterIterator source;
    private RuleBasedCollator collator;
    private int[] orders;
    private int index;

    public static final int primaryOrder(int order) {
        return order >>> 16;
    }

    public static final short secondaryOrder(int order) {
        return (short)((order & 0xFF00) >> 8);
    }

    public static final short tertiaryOrder(int order) {
        return (short)(order & 0xFF);
    }

    public final int getMaxExpansion(int element) {
        if (this.orders == null) {
            this.orders = this.collator.getOrders(this.source);
            this.index = 0;
            if (this.orders == null) {
                return -1;
            }
        }
        return this.orders.length;
    }

    public final int getOffset() {
        return this.source.getIndex();
    }

    public final int next() {
        if (this.orders != null && this.index < this.orders.length) {
            return this.orders[this.index++];
        }
        this.orders = this.collator.getOrders(this.source);
        this.index = 0;
        if (this.orders != null && this.index < this.orders.length) {
            return this.orders[this.index++];
        }
        return -1;
    }

    public final int previous() {
        return -1;
    }

    public final void reset() {
        this.source.first();
    }

    public final void setOffset(int newOffset) {
        this.source.setIndex(newOffset);
    }

    public final void setText(String text) {
        this.source = new StringCharacterIterator(text);
    }

    public final void setText(CharacterIterator newChariter) {
        this.source = newChariter;
    }

    CollationElementIterator(CharacterIterator source, RuleBasedCollator collator) {
        this.source = source;
        this.collator = collator;
    }
}

