/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;

public final class SignedObject
implements Serializable {
    private byte[] content;
    private byte[] signature;
    private String thealgorithm;
    private transient Object signedobject;

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
    }

    public SignedObject(Serializable object, PrivateKey pkey, Signature sign) throws IOException, InvalidKeyException, SignatureException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        new ObjectOutputStream(baos).writeObject(object);
        this.content = baos.toByteArray();
        sign.engineInitSign(pkey);
        sign.engineUpdate(this.content, 0, this.content.length);
        this.signature = sign.engineSign();
        this.signedobject = object;
    }

    public String getAlgorithm() {
        return this.thealgorithm;
    }

    public Object getObject() {
        return this.signedobject;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public boolean verify(PublicKey pkey, Signature sign) throws InvalidKeyException, SignatureException {
        sign.engineInitVerify(pkey);
        return sign.engineVerify(this.signature);
    }
}

