/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SecurityAction;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.SignatureSpiWrapper;
import java.security.cert.Certificate;
import java.security.spec.AlgorithmParameterSpec;

public abstract class Signature
extends SignatureSpi {
    protected static final int SIGN = 2;
    protected static final int UNINITIALIZED = 0;
    protected static final int VERIFY = 3;
    private static final String SIGNATURE_DOT = "Signature.";
    private String algorithm;
    private Provider provider;
    protected int state = 0;

    public static Signature getInstance(String algorithm) throws NoSuchAlgorithmException {
        SecurityAction action = new SecurityAction(algorithm, SIGNATURE_DOT);
        Signature sign = action.spi instanceof Signature ? (Signature)action.spi : new SignatureSpiWrapper((SignatureSpi)action.spi, algorithm);
        sign.provider = action.provider;
        return sign;
    }

    public static Signature getInstance(String algorithm, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        SecurityAction action = new SecurityAction(algorithm, provider, SIGNATURE_DOT);
        Signature sign = action.spi instanceof Signature ? (Signature)action.spi : new SignatureSpiWrapper((SignatureSpi)action.spi, algorithm);
        sign.provider = action.provider;
        return sign;
    }

    protected Signature(String algorithm) {
        if (algorithm == null) {
            throw new NullPointerException();
        }
        this.algorithm = algorithm;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public final Object getParameter(String param) {
        return this.engineGetParameter(param);
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final void initSign(PrivateKey prtKey) throws InvalidKeyException {
        this.engineInitSign(prtKey);
        this.state = 2;
    }

    public final void initSign(PrivateKey prtKey, SecureRandom rnd) throws InvalidKeyException {
        this.engineInitSign(prtKey, rnd);
        this.state = 2;
    }

    public final void initVerify(PublicKey publicKey) throws InvalidKeyException {
        this.engineInitVerify(publicKey);
        this.state = 3;
    }

    public final void initVerify(Certificate certificate) throws InvalidKeyException {
        this.engineInitVerify(certificate.getPublicKey());
        this.state = 3;
    }

    public final void setParameter(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
        this.engineSetParameter(params);
    }

    public final void setParameter(String param, Object value) {
        this.engineSetParameter(param, value);
    }

    public final byte[] sign() throws SignatureException {
        if (this.state != 2) {
            throw new SignatureException("the Signature has an invalid state");
        }
        return this.engineSign();
    }

    public final int sign(byte[] buf, int offset, int len) throws SignatureException {
        if (this.state != 2) {
            throw new SignatureException("the Signature has an invalid state");
        }
        return this.engineSign(buf, offset, len);
    }

    public String toString() {
        String s = null;
        switch (this.state) {
            case 2: {
                s = "SIGN";
                break;
            }
            case 3: {
                s = "VERIFY";
                break;
            }
            default: {
                s = "UNINITIALIZED";
            }
        }
        return "Signature state = " + s + " using " + this.algorithm;
    }

    public final void update(byte b) throws SignatureException {
        if (this.state == 0) {
            throw new SignatureException("the Signature has not initialized");
        }
        this.engineUpdate(b);
    }

    public final void update(byte[] data) throws SignatureException {
        if (this.state == 0) {
            throw new SignatureException("the Signature has not initialized");
        }
        this.engineUpdate(data, 0, data.length);
    }

    public final void update(byte[] data, int off, int len) throws SignatureException {
        if (this.state == 0) {
            throw new SignatureException("the Signature has not initialized");
        }
        this.engineUpdate(data, off, len);
    }

    public final boolean verify(byte[] signature) throws SignatureException {
        if (this.state != 3) {
            throw new SignatureException("the Signature has an invalid state");
        }
        return this.engineVerify(signature);
    }
}

