/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.KeyPairGeneratorSpiWrapper;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.SecurityAction;
import java.security.spec.AlgorithmParameterSpec;

public abstract class KeyPairGenerator
extends KeyPairGeneratorSpi {
    private Provider provider;
    private String algorithm;

    public static KeyPairGenerator getInstance(String algorithm) throws NoSuchAlgorithmException {
        SecurityAction action = new SecurityAction(algorithm, "KeyPairGenerator.");
        KeyPairGenerator kpg = action.spi instanceof KeyPairGenerator ? (KeyPairGenerator)action.spi : new KeyPairGeneratorSpiWrapper((KeyPairGeneratorSpi)action.spi, algorithm);
        kpg.provider = action.provider;
        return kpg;
    }

    public static KeyPairGenerator getInstance(String algorithm, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        SecurityAction action = new SecurityAction(algorithm, provider, "KeyPairGenerator.");
        KeyPairGenerator kpg = action.spi instanceof KeyPairGenerator ? (KeyPairGenerator)action.spi : new KeyPairGeneratorSpiWrapper((KeyPairGeneratorSpi)action.spi, algorithm);
        kpg.provider = action.provider;
        return kpg;
    }

    public final KeyPair genKeyPair() {
        return this.generateKeyPair();
    }

    public KeyPair generateKeyPair() {
        throw new UnsupportedOperationException("KeyPairGenerator generateKeyPair " + this.getClass());
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public void initialize(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
        throw new UnsupportedOperationException("KeyPairGenerator initialize(AlgorithmParameterSpec) " + this.getClass());
    }

    public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        throw new UnsupportedOperationException("KeyPairGenerator initialize(AlgorithmParameterSpec,SecureRandom) " + this.getClass());
    }

    public void initialize(int keysize) {
        throw new UnsupportedOperationException("KeyPairGenerator initialize(int) " + this.getClass());
    }

    public void initialize(int keysize, SecureRandom random) {
        throw new UnsupportedOperationException("KeyPairGenerator initialize(int,SecureRandom) " + this.getClass());
    }

    protected KeyPairGenerator(String algorithm) {
        this.algorithm = algorithm;
    }
}

