/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecurityAction;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;

public class KeyFactory {
    private KeyFactorySpi keyFacSpi;
    private Provider provider;
    private String algorithm;

    public static KeyFactory getInstance(String algorithm) throws NoSuchAlgorithmException {
        SecurityAction action = new SecurityAction(algorithm, "KeyFactory.");
        return new KeyFactory((KeyFactorySpi)action.spi, action.provider, algorithm);
    }

    public static KeyFactory getInstance(String algorithm, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        SecurityAction action = new SecurityAction(algorithm, provider, "KeyFactory.");
        return new KeyFactory((KeyFactorySpi)action.spi, action.provider, algorithm);
    }

    public final PrivateKey generatePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        return this.keyFacSpi.engineGeneratePrivate(keySpec);
    }

    public final PublicKey generatePublic(KeySpec keySpec) throws InvalidKeySpecException {
        return this.keyFacSpi.engineGeneratePublic(keySpec);
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public final KeySpec getKeySpec(Key key, Class keySpec) throws InvalidKeySpecException {
        return this.keyFacSpi.engineGetKeySpec(key, keySpec);
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final Key translateKey(Key key) throws InvalidKeySpecException {
        return this.keyFacSpi.engineTranslateKey(key);
    }

    protected KeyFactory(KeyFactorySpi keyFacSpi, Provider provider, String algorithm) {
        this.keyFacSpi = keyFacSpi;
        this.provider = provider;
        this.algorithm = algorithm;
    }
}

