/*
 * Decompiled with CFR 0.152.
 */
package java.rmi.server;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.rmi.server.UID;

public final class ObjID
implements Serializable {
    public static int ACTIVATOR_ID = 1;
    public static int DGC_ID = 2;
    public static int REGISTRY_ID = 0;
    private static final long serialVersionUID = -6386392263968365220L;
    private static final UID thisVMSpace = new UID();
    private static long theCounter = 0L;
    private long objNum;
    private UID space;

    public static ObjID read(ObjectInput in) throws IOException {
        long num = in.readLong();
        return new ObjID(num, UID.read(in));
    }

    ObjID(long num, UID uid) {
        this.objNum = num;
        this.space = uid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjID() {
        UID uID = thisVMSpace;
        synchronized (uID) {
            this.space = thisVMSpace;
            this.objNum = theCounter++;
        }
    }

    public ObjID(int num) {
        this(num, new UID(0, 0L, 0));
    }

    public boolean equals(Object obj) {
        if (obj instanceof ObjID) {
            ObjID id = (ObjID)obj;
            return id.objNum == this.objNum && this.space.equals(id.space);
        }
        return false;
    }

    public int hashCode() {
        return (int)this.objNum ^ (int)(this.objNum >>> 32) + this.space.hashCode();
    }

    public String toString() {
        String result = "ObjID: objNum=" + this.objNum;
        if (!this.space.equals(thisVMSpace)) {
            result = result + ", space=" + this.space;
        }
        return result;
    }

    public void write(ObjectOutput out) throws IOException {
        out.writeLong(this.objNum);
        this.space.write(out);
    }
}

