/*
 * Decompiled with CFR 0.152.
 */
package java.rmi.activation;

import java.io.Serializable;
import java.rmi.MarshalledObject;
import java.rmi.activation.ActivationException;
import java.rmi.activation.ActivationGroup;
import java.rmi.activation.ActivationGroupID;

public final class ActivationDesc
implements Serializable {
    private static final long serialVersionUID = 7455834104417690957L;
    private ActivationGroupID groupID;
    private String className;
    private String location;
    private MarshalledObject data;
    private boolean restart;

    public ActivationDesc(String className, String location, MarshalledObject data) throws ActivationException {
        this.groupID = ActivationGroup.currentGroupID();
        if (this.groupID == null) {
            throw new IllegalArgumentException("groupID is null");
        }
        this.className = className;
        this.location = location;
        this.data = data;
    }

    public ActivationDesc(String className, String location, MarshalledObject data, boolean restart) throws ActivationException {
        this(className, location, data);
        this.restart = restart;
    }

    public ActivationDesc(ActivationGroupID groupID, String className, String location, MarshalledObject data) {
        if (groupID == null) {
            throw new IllegalArgumentException("groupID is null");
        }
        this.groupID = groupID;
        this.className = className;
        this.location = location;
        this.data = data;
    }

    public ActivationDesc(ActivationGroupID groupID, String className, String location, MarshalledObject data, boolean restart) {
        this(groupID, className, location, data);
        this.restart = restart;
    }

    public ActivationGroupID getGroupID() {
        return this.groupID;
    }

    public String getClassName() {
        return this.className;
    }

    public String getLocation() {
        return this.location;
    }

    public MarshalledObject getData() {
        return this.data;
    }

    public boolean getRestartMode() {
        return this.restart;
    }

    public boolean equals(Object obj) {
        if (this.getClass().isInstance(obj)) {
            ActivationDesc ad = (ActivationDesc)obj;
            return this.restart == ad.restart && this.groupID.equals(ad.groupID) && this.data.equals(ad.data) && this.className.equals(ad.className) && this.location.equals(ad.location);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.restart ? -2112936627 : 0;
        return hash ^ this.groupID.hashCode() ^ this.className.hashCode() ^ this.location.hashCode() ^ this.data.hashCode();
    }
}

