/*
 * Decompiled with CFR 0.152.
 */
package java.rmi;

import java.net.MalformedURLException;
import java.rmi.AlreadyBoundException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;

public final class Naming {
    public static final void bind(String name, Remote obj) throws AlreadyBoundException, MalformedURLException, RemoteException {
        StringBuffer buf = new StringBuffer(name.length());
        Registry reg = Naming.getRegistry(name, buf);
        reg.bind(buf.toString(), obj);
    }

    public static final String[] list(String name) throws MalformedURLException, RemoteException {
        StringBuffer buf = new StringBuffer(name.length());
        Registry reg = Naming.getRegistry(name, buf);
        return reg.list();
    }

    public static final Remote lookup(String name) throws NotBoundException, MalformedURLException, RemoteException {
        StringBuffer buf = new StringBuffer(name.length());
        Registry reg = Naming.getRegistry(name, buf);
        return reg.lookup(buf.toString());
    }

    public static final void rebind(String name, Remote obj) throws MalformedURLException, RemoteException {
        StringBuffer buf = new StringBuffer(name.length());
        Registry reg = Naming.getRegistry(name, buf);
        reg.rebind(buf.toString(), obj);
    }

    public static final void unbind(String name) throws NotBoundException, MalformedURLException, RemoteException {
        StringBuffer buf = new StringBuffer(name.length());
        Registry reg = Naming.getRegistry(name, buf);
        reg.unbind(buf.toString());
    }

    private static final Registry getRegistry(String url, StringBuffer name) throws MalformedURLException, RemoteException {
        int port = 1099;
        String host = "localhost";
        if (url.startsWith("rmi:")) {
            url = url.substring(4);
        }
        if (url.startsWith("//")) {
            int index = url.indexOf("/", 2);
            if (index == -1) {
                throw new MalformedURLException("no name specified in: " + url);
            }
            host = url.substring(2, index);
            url = url.substring(index + 1);
            index = host.indexOf(":");
            if (index != -1) {
                try {
                    port = Integer.parseInt(host.substring(index + 1));
                }
                catch (NumberFormatException nfe) {
                    throw new MalformedURLException("invalid port");
                }
                host = host.substring(0, index);
            }
        }
        name.append(url);
        if (host.length() == 0) {
            host = "localhost";
        }
        return LocateRegistry.getRegistry(host, port);
    }

    private Naming() {
    }
}

