/*
 * Decompiled with CFR 0.152.
 */
package java.rmi;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.rmi.server.RMIClassLoader;
import java.util.Arrays;

public final class MarshalledObject
implements Serializable {
    private static final long serialVersionUID = 8988374069173025854L;
    private byte[] objBytes;
    private byte[] locBytes;
    private int hash;

    public MarshalledObject(Object obj) throws IOException {
        if (obj != null) {
            this.hash = obj.hashCode();
            ByteArrayOutputStream bas = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(bas);
            out.writeObject(obj);
            out.close();
            this.objBytes = bas.toByteArray();
            String annotation = RMIClassLoader.getClassAnnotation(obj.getClass());
            if (annotation != null) {
                bas.reset();
                out = new ObjectOutputStream(bas);
                out.writeObject(annotation);
                out.close();
                this.locBytes = bas.toByteArray();
            }
        }
    }

    public Object get() throws IOException, ClassNotFoundException {
        if (this.objBytes == null) {
            return null;
        }
        ByteArrayInputStream bas = new ByteArrayInputStream(this.objBytes);
        ObjectInputStream in = this.locBytes == null ? new ObjectInputStream(bas) : new MarshalledObjectInputStream(bas, this.locBytes);
        return in.readObject();
    }

    public boolean equals(Object obj) {
        if (obj instanceof MarshalledObject) {
            return Arrays.equals(this.objBytes, ((MarshalledObject)obj).objBytes);
        }
        return false;
    }

    public int hashCode() {
        return this.hash;
    }

    static class MarshalledObjectInputStream
    extends ObjectInputStream {
        ClassLoader loader;

        MarshalledObjectInputStream(InputStream in, byte[] bytes) throws IOException, ClassNotFoundException {
            super(in);
            ObjectInputStream oin = new ObjectInputStream(new ByteArrayInputStream(bytes));
            this.loader = RMIClassLoader.getClassLoader((String)oin.readObject());
            oin.close();
        }

        protected Class resolveClass(ObjectStreamClass osclass) throws IOException, ClassNotFoundException {
            return Class.forName(osclass.getName(), true, this.loader);
        }
    }
}

