/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;

public abstract class URLStreamHandler {
    protected boolean equals(URL url1, URL url2) {
        return url1.getProtocol().equals(url2.getProtocol()) && url1.getPort() == url2.getPort() && url1.getHost().equals(url2.getHost()) && url1.getFile().equals(url2.getFile()) && (url1.getRef() == null ? url2.getRef() == null : url1.getRef().equals(url2.getRef()));
    }

    protected int getDefaultPort() {
        return 0;
    }

    protected int hashCode(URL url) {
        int hashCode = url.getFile().hashCode() ^ url.getHost().hashCode() ^ url.getProtocol().hashCode();
        hashCode ^= url.getPort();
        String ref = url.getRef();
        if (ref != null) {
            hashCode ^= ref.hashCode();
        }
        return hashCode;
    }

    protected InetAddress getHostAddress(URL url) {
        try {
            return InetAddress.getByName(url.getHost());
        }
        catch (UnknownHostException uhe) {
            return null;
        }
    }

    protected boolean hostsEqual(URL url1, URL url2) throws UnknownHostException {
        return InetAddress.getByName(url1.getHost()).equals(InetAddress.getByName(url2.getHost()));
    }

    protected abstract URLConnection openConnection(URL var1) throws IOException;

    protected void parseURL(URL url, String spec, int start, int end) {
        int here = start;
        int there = end;
        try {
            int query;
            if (end > start + 2 && spec.regionMatches(start, "//", 0, 2)) {
                String host_and_port;
                int colon;
                int third_slash = spec.indexOf("/", start + 2);
                if (third_slash < 0) {
                    third_slash = end;
                }
                if ((colon = (host_and_port = spec.substring(start + 2, third_slash)).indexOf(58)) < 0) {
                    url.setHost(host_and_port);
                } else {
                    url.setHost(host_and_port.substring(0, colon));
                    url.setPort(Integer.parseInt(host_and_port.substring(colon + 1)));
                }
                here = third_slash;
            }
            if ((query = spec.lastIndexOf("?")) >= here) {
                url.setQuery(spec.substring(query + 1));
                there = query;
            }
            url.setFile(spec.substring(here, there));
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    protected boolean sameFile(URL url1, URL url2) {
        return url1.getProtocol().equals(url2.getProtocol()) && url1.getPort() == url2.getPort() && url1.getHost().equals(url2.getHost()) && url1.getFile().equals(url2.getFile());
    }

    protected void setURL(URL url, String protocol, String host, int port, String file, String ref) {
        url.set(protocol, host, port, file, ref);
    }

    protected void setURL(URL url, String protocol, String host, int port, String authority, String userInfo, String path, String query, String ref) {
        url.set(protocol, host, port, authority, userInfo, path, query, ref);
    }

    protected String toExternalForm(URL url) {
        StringBuffer buf = new StringBuffer(url.getProtocol());
        buf.append("://");
        buf.append(url.getHost());
        if (url.getPort() != -1 && url.getPort() != this.getDefaultPort()) {
            buf.append(':');
            buf.append(url.getPort());
        }
        buf.append(url.getFile());
        String ref = url.getRef();
        if (ref != null) {
            buf.append('#');
            buf.append(ref);
        }
        return buf.toString();
    }
}

