/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.FileDescriptor;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocketImpl;
import java.net.InetAddress;
import java.net.SocketException;

class PlainDatagramSocketImpl
extends DatagramSocketImpl {
    private int timeout = 0;
    private boolean open;

    protected synchronized void create() throws SocketException {
        this.fd = new FileDescriptor();
        this.nativeCreate();
    }

    private native void nativeCreate();

    protected synchronized native void bind(int var1, InetAddress var2) throws SocketException;

    protected native void send(DatagramPacket var1) throws IOException;

    protected native int peek(InetAddress var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void receive(DatagramPacket p) throws IOException {
        DatagramPacket datagramPacket = p;
        synchronized (datagramPacket) {
            int ip = this._receive(p);
            p.setAddress(InetAddress.createInetAddress(ip));
        }
    }

    private native int _receive(DatagramPacket var1) throws IOException;

    protected synchronized void setTTL(byte ttl) throws IOException {
        this.setTimeToLive(0xFF & ttl);
    }

    protected synchronized byte getTTL() throws IOException {
        return (byte)this.getTimeToLive();
    }

    protected synchronized native void join(InetAddress var1) throws IOException;

    protected synchronized native void leave(InetAddress var1) throws IOException;

    protected synchronized native void close();

    protected synchronized native void setTimeToLive(int var1) throws IOException;

    protected synchronized native int getTimeToLive() throws IOException;

    public synchronized Object getOption(int opt) throws SocketException {
        int sock = this.getSocket();
        if (opt == 4102) {
            return new Integer(this.timeout);
        }
        return PlainDatagramSocketImpl.Options(opt, null, sock);
    }

    public synchronized void setOption(int opt, Object value) throws SocketException {
        if (value == null) {
            throw new SocketException("a non 'null' option value is required");
        }
        int sock = this.getSocket();
        if (opt == 4102) {
            if (value instanceof Integer) {
                this.timeout = (Integer)value;
            }
        } else {
            PlainDatagramSocketImpl.Options(opt, value, sock);
        }
    }

    private native int getSocket() throws SocketException;

    static Object Options(int opt, Object value, int sock) throws SocketException {
        try {
            int i = 0;
            switch (opt) {
                case 15: {
                    if (value == null) {
                        return InetAddress.createInetAddress(PlainDatagramSocketImpl.getBindAddress(sock));
                    }
                    break;
                }
                case 128: {
                    if (value == null) {
                        int res = PlainDatagramSocketImpl.optLinger(sock, -1);
                        if (res == 0) {
                            return new Boolean(false);
                        }
                        return new Integer(res);
                    }
                    if (value instanceof Boolean && !((Boolean)value).booleanValue()) {
                        PlainDatagramSocketImpl.optLinger(sock, 0);
                        break;
                    }
                    PlainDatagramSocketImpl.optLinger(sock, (Integer)value);
                    break;
                }
                case 1: {
                    if (value == null) {
                        return new Boolean(PlainDatagramSocketImpl.optNoDelay(sock, true, true));
                    }
                    PlainDatagramSocketImpl.optNoDelay(sock, (Boolean)value, false);
                    break;
                }
                case 4097: {
                    ++i;
                }
                case 4098: {
                    ++i;
                }
                case 4: {
                    if (value == null) {
                        return new Integer(PlainDatagramSocketImpl.optIntOptions(sock, -1, i));
                    }
                    PlainDatagramSocketImpl.optIntOptions(sock, (Integer)value, i);
                    break;
                }
                case 16: {
                    if (value == null) {
                        return InetAddress.createInetAddress(PlainDatagramSocketImpl.optMulticastIF(sock, null, true));
                    }
                    PlainDatagramSocketImpl.optMulticastIF(sock, (InetAddress)value, false);
                    break;
                }
                default: {
                    throw new SocketException("no valid option specified");
                }
            }
        }
        catch (ClassCastException cce) {
            throw new SocketException("no valid value specified");
        }
        return null;
    }

    protected native void finalize();

    private static native int getBindAddress(int var0) throws SocketException;

    private static native int optLinger(int var0, int var1) throws SocketException;

    private static native boolean optNoDelay(int var0, boolean var1, boolean var2) throws SocketException;

    private static native int optMulticastIF(int var0, InetAddress var1, boolean var2) throws SocketException;

    private static native int optIntOptions(int var0, int var1, int var2) throws SocketException;
}

