/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import com.acunia.wonka.net.jar.ImmutableJarEntry;
import com.acunia.wonka.net.jar.ImmutableManifest;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.cert.Certificate;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public abstract class JarURLConnection
extends URLConnection {
    protected URLConnection jarFileURLConnection;
    private URL jar_url;
    private String file_name;
    private URL file_url;
    private String entry_name;

    public Attributes getAttributes() throws IOException {
        JarEntry je = this.getJarEntry();
        if (je == null) {
            return null;
        }
        return je.getAttributes();
    }

    public Certificate[] getCertificates() throws IOException {
        JarEntry je = this.getJarEntry();
        if (je == null) {
            return null;
        }
        return je.getCertificates();
    }

    public String getEntryName() {
        return this.entry_name;
    }

    public JarEntry getJarEntry() throws IOException {
        JarEntry je = this.getJarFile().getJarEntry(this.entry_name);
        return je == null ? null : new ImmutableJarEntry(je);
    }

    public abstract JarFile getJarFile() throws IOException;

    public URL getJarFileURL() {
        return this.file_url;
    }

    public Attributes getMainAttributes() throws IOException {
        Manifest man = this.getManifest();
        if (man == null) {
            return null;
        }
        return man.getMainAttributes();
    }

    public Manifest getManifest() throws IOException {
        Manifest m = this.getJarFile().getManifest();
        return m == null ? null : new ImmutableManifest(m);
    }

    protected JarURLConnection(URL url) throws MalformedURLException {
        super(url);
        String temp = url.getFile();
        int slashbang = temp.lastIndexOf("!/");
        if (slashbang < 0) {
            this.entry_name = null;
            slashbang = temp.length() - 2;
        } else {
            this.entry_name = slashbang == temp.length() - 2 ? null : temp.substring(slashbang + 2);
        }
        this.file_name = temp.substring(0, slashbang);
        this.file_url = new URL(this.file_name);
        this.jar_url = url;
    }
}

