/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.net.InetAddress;

public final class DatagramPacket {
    private byte[] bytes;
    private int length;
    private int offset;
    private int port;
    private InetAddress address;

    public DatagramPacket(byte[] buf, int offset, int length) throws IllegalArgumentException {
        if (offset < 0 || length < 0 || offset + length > buf.length) {
            throw new IllegalArgumentException();
        }
        this.bytes = buf;
        this.length = length;
        this.offset = offset;
        this.address = null;
        this.port = -1;
    }

    public DatagramPacket(byte[] buf, int length) throws IllegalArgumentException {
        this(buf, 0, length);
    }

    public DatagramPacket(byte[] buf, int offset, int length, InetAddress address, int port) throws IllegalArgumentException {
        if (offset < 0 || length < 0 || offset + length > buf.length || port < 0 || port > 65535) {
            throw new IllegalArgumentException();
        }
        if (address == null) {
            throw new NullPointerException();
        }
        this.bytes = buf;
        this.length = length;
        this.offset = offset;
        this.address = address;
        this.port = port;
    }

    public DatagramPacket(byte[] buf, int length, InetAddress address, int port) throws IllegalArgumentException {
        this(buf, 0, length, address, port);
    }

    public synchronized InetAddress getAddress() {
        return this.address;
    }

    public synchronized int getPort() {
        return this.port;
    }

    public synchronized byte[] getData() {
        return this.bytes;
    }

    public synchronized int getOffset() {
        return this.offset;
    }

    public synchronized int getLength() {
        return this.length;
    }

    public synchronized void setAddress(InetAddress iaddr) {
        if (iaddr == null) {
            throw new NullPointerException("no null address allowed");
        }
        this.address = iaddr;
    }

    public synchronized void setPort(int port) {
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("invalid port number " + port);
        }
        this.port = port;
    }

    public synchronized void setData(byte[] buf) {
        if (this.length > buf.length) {
            this.length = buf.length;
        }
        this.bytes = buf;
        this.offset = 0;
    }

    public synchronized void setData(byte[] buf, int off, int len) {
        if (off < 0 || len < 0 || buf.length < off + len) {
            throw new IllegalArgumentException();
        }
        this.bytes = buf;
        this.offset = off;
        this.length = len;
    }

    public synchronized void setLength(int length) throws IllegalArgumentException {
        if (length < 0 || this.offset + length > this.bytes.length) {
            throw new IllegalArgumentException();
        }
        this.length = length;
    }
}

