/*
 * Decompiled with CFR 0.152.
 */
package java.math;

import java.util.Arrays;
import java.util.Random;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BigInteger
extends Number
implements Comparable {
    private static Random theRandom = new Random();
    private static final long serialVersionUID = -8287574255936472291L;
    public static final BigInteger ZERO = new BigInteger(new byte[0], 0);
    public static final BigInteger ONE = new BigInteger(1L);
    static final BigInteger bigNegOne = new BigInteger(-1);
    static final BigInteger TWO = new BigInteger(2);
    static final BigInteger THREE = new BigInteger(3);
    static final BigInteger FIVE = new BigInteger(5);
    static final BigInteger SEVEN = new BigInteger(7L);
    private static final char[] DIGIT_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    private static final int[] DIGITS_PER_LONG = new int[]{-1, -1, 62, 39, 31, 27, 24, 22, 20, 19, 18, 18, 17, 17, 16, 16, 15, 15, 15, 14, 14, 14, 14, 13, 13, 13, 13, 13, 13, 12, 12, 12, 12, 12, 12, 12, 12};
    private static final long[] MULTIPLIERS = new long[]{-1, -1, 0x4000000000000000L, 4052555153018976267L, 0x4000000000000000L, 7450580596923828125L, 4738381338321616896L, 3909821048582988049L, 0x1000000000000000L, 1350851717672992089L, 1000000000000000000L, 5559917313492231481L, 2218611106740436992L, 8650415919381337933L, 2177953337809371136L, 6568408355712890625L, 0x1000000000000000L, 2862423051509815793L, 6746640616477458432L, 799006685782884121L, 1638400000000000000L, 3243919932521508681L, 6221821273427820544L, 504036361936467383L, 876488338465357824L, 1490116119384765625L, 2481152873203736576L, 4052555153018976267L, 6502111422497947648L, 353814783205469041L, 531441000000000000L, 787662783788549761L, 0x1000000000000000L, 1667889514952984961L, 2386420683693101056L, 3379220508056640625L, 4738381338321616896L};
    private transient BigInteger negateCache;
    private transient byte[] valueCache;
    private byte[] magnitude;
    private int signum;
    private int lowestSetBit;
    private int firstNonzeroByteNum;
    private int bitCount;
    private int bitLength;

    public BigInteger abs() {
        if (this.signum < 0) {
            return this.negate();
        }
        return this;
    }

    public BigInteger and(BigInteger bi) {
        if (this.signum == 0 || bi.signum == 0) {
            return ZERO;
        }
        byte[] bmax = this.magnitude.length < bi.magnitude.length ? bi.magnitude : this.magnitude;
        byte[] bmin = this.magnitude == bmax ? bi.magnitude : this.magnitude;
        byte[] bytes = new byte[bmax.length + 1];
        int n = 0;
        if (this.signum == -1) {
            n = 1;
        }
        int n2 = 0 - n;
        int n3 = 0;
        if (bi.signum == -1) {
            n3 = 1;
        }
        bytes[0] = (byte)(n2 & 0 - n3);
        int sign = bi.magnitude.length > this.magnitude.length ? this.signum : bi.signum;
        int n4 = 0;
        if (sign == -1) {
            n4 = 1;
        }
        sign = 0 - n4;
        int dif = bmax.length - bmin.length;
        int j = 0;
        while (j < dif) {
            bytes[j + 1] = (byte)(sign & (char)bmax[j]);
            ++j;
        }
        int i = 0;
        int j2 = dif;
        while (i < bmin.length) {
            bytes[j2 + 1] = (byte)(bmax[j2] & bmin[i]);
            ++i;
            ++j2;
        }
        return new BigInteger(bytes, false);
    }

    public BigInteger andNot(BigInteger bi) {
        return this.and(bi.not());
    }

    public int bitLength() {
        if (this.bitLength == -1) {
            int l = this.magnitude.length * 8;
            if (this.magnitude.length > 0) {
                int hlp = 8;
                int n = 0;
                if (this.signum == 1) {
                    n = 1;
                }
                int res = n + -1;
                int bits = this.magnitude[0];
                while ((bits >>>= 1) != res && --hlp > 0) {
                }
                l -= hlp;
            }
            this.bitLength = l;
        }
        return this.bitLength;
    }

    public BigInteger clearBit(int n) throws ArithmeticException {
        if (n < 0) {
            throw new ArithmeticException("cannot clear bit " + n + " (negative value)");
        }
        if (this.signum == 0) {
            return ZERO;
        }
        byte[] bytes = n >= 8 * this.magnitude.length - 1 ? this.createByteArray(n) : (byte[])this.magnitude.clone();
        int bt = bytes.length - 1 - n / 8;
        n %= 8;
        int mask = 65407;
        while (n < 7) {
            mask >>= 1;
            ++n;
        }
        bytes[bt] = (byte)((char)bytes[bt] & mask);
        return new BigInteger(bytes, false);
    }

    public int compareTo(Object o) {
        return this.compareTo((BigInteger)o);
    }

    public int compareTo(BigInteger bi) {
        if (this.signum != bi.signum || this.signum == 0) {
            return this.signum == 0 ? -bi.signum : this.signum;
        }
        if (this.magnitude.length != bi.magnitude.length) {
            return (this.magnitude.length > bi.magnitude.length ? 1 : -1) * this.signum;
        }
        int i = 0;
        while (i < this.magnitude.length) {
            if (this.magnitude[i] != bi.magnitude[i]) {
                return ((0xFF & (char)this.magnitude[i]) > (0xFF & (char)bi.magnitude[i]) ? 1 : -1) * this.signum;
            }
            ++i;
        }
        return 0;
    }

    public boolean equals(Object val) {
        if (!(val instanceof BigInteger)) {
            return false;
        }
        BigInteger bi = (BigInteger)val;
        boolean bl = false;
        if (this.signum == bi.signum && Arrays.equals(this.magnitude, bi.magnitude)) {
            bl = true;
        }
        return bl;
    }

    public BigInteger flipBit(int n) throws ArithmeticException {
        if (n < 0) {
            throw new ArithmeticException("cannot flip bit " + n + " (negative value)");
        }
        byte[] bytes = n >= 8 * this.magnitude.length - 1 ? this.createByteArray(n) : (byte[])this.magnitude.clone();
        int bt = bytes.length - 1 - n / 8;
        n %= 8;
        int mask = 256;
        while (n < 7) {
            mask >>= 1;
            ++n;
        }
        bytes[bt] = (byte)((char)bytes[bt] ^ mask);
        return new BigInteger(bytes, false);
    }

    public int getLowestSetBit() {
        if (this.lowestSetBit == -2) {
            if (this.signum == 0) {
                this.lowestSetBit = -1;
            } else {
                int i = this.magnitude.length - 1;
                while (i >= 0) {
                    if (this.magnitude[i] != 0) {
                        int bt = this.magnitude[i] >> 1;
                        int res = 7;
                        int j = 0;
                        while (j < 7) {
                            if (bt == 0) {
                                res = j;
                                break;
                            }
                            ++j;
                        }
                        this.lowestSetBit = res + (this.magnitude.length - 1 - i) * 8;
                        break;
                    }
                    --i;
                }
            }
        }
        return this.lowestSetBit;
    }

    public int hashCode() {
        int hash = 0;
        int i = 0;
        while (i < this.magnitude.length) {
            hash ^= 59793 * this.magnitude[i];
            ++i;
        }
        return hash * this.signum;
    }

    public BigInteger max(BigInteger val) {
        return this.compareTo(val) == 1 ? this : val;
    }

    public BigInteger min(BigInteger val) {
        return this.compareTo(val) == -1 ? this : val;
    }

    public BigInteger negate() {
        if (this.negateCache == null) {
            if (this.signum == 0) {
                this.negateCache = this;
            } else {
                this.negateCache = new BigInteger(this.nativeNegateBytes(), -this.signum);
                this.negateCache.negateCache = this;
            }
        }
        return this.negateCache;
    }

    public BigInteger not() {
        byte[] bytes = new byte[this.magnitude.length + 1];
        int n = 0;
        if (this.signum == -1) {
            n = 1;
        }
        bytes[0] = (byte)(n + -1);
        System.arraycopy(this.magnitude, 0, bytes, 1, this.magnitude.length);
        int i = 1;
        while (i < bytes.length) {
            bytes[i] = (byte)(0xFF ^ (char)bytes[i]);
            ++i;
        }
        return new BigInteger(bytes, false);
    }

    public BigInteger or(BigInteger bi) {
        if (bi.signum == 0) {
            return this;
        }
        if (this.signum == 0) {
            return bi;
        }
        byte[] bmax = this.magnitude.length < bi.magnitude.length ? bi.magnitude : this.magnitude;
        byte[] bmin = this.magnitude == bmax ? bi.magnitude : this.magnitude;
        byte[] bytes = new byte[bmax.length + 1];
        int n = 0;
        if (this.signum == -1) {
            n = 1;
        }
        int n2 = 0 - n;
        int n3 = 0;
        if (bi.signum == -1) {
            n3 = 1;
        }
        bytes[0] = (byte)(n2 | 0 - n3);
        int sign = bi.magnitude.length > this.magnitude.length ? this.signum : bi.signum;
        int n4 = 0;
        if (sign == -1) {
            n4 = 1;
        }
        sign = 0 - n4;
        int dif = bmax.length - bmin.length;
        int j = 0;
        while (j < dif) {
            bytes[j + 1] = (byte)(sign | (char)bmax[j]);
            ++j;
        }
        int i = 0;
        int j2 = dif;
        while (i < bmin.length) {
            bytes[j2 + 1] = (byte)(bmax[j2] | bmin[i]);
            ++i;
            ++j2;
        }
        return new BigInteger(bytes, false);
    }

    public BigInteger setBit(int n) {
        if (n < 0) {
            throw new ArithmeticException("cannot set bit " + n + " (negative value)");
        }
        byte[] bytes = n >= 8 * this.magnitude.length - 1 ? this.createByteArray(n) : (byte[])this.magnitude.clone();
        int bt = bytes.length - 1 - n / 8;
        n %= 8;
        int mask = 128;
        while (n < 7) {
            mask >>= 1;
            ++n;
        }
        bytes[bt] = (byte)((char)bytes[bt] | mask);
        return new BigInteger(bytes, false);
    }

    public BigInteger shiftLeft(int n) {
        byte[] bytes;
        if (n <= 0) {
            return this.shiftRight(-n);
        }
        int bt = n / 8;
        if ((n %= 8) != 0) {
            bytes = new byte[this.magnitude.length + 1 + bt];
            System.arraycopy(this.magnitude, 0, bytes, 1, this.magnitude.length);
            if (this.signum == -1) {
                bytes[0] = -1;
            }
            bt = 0;
            int i = bytes.length - 1;
            while (i > -1) {
                bt |= (0xFF & (char)bytes[i]) << 8;
                bytes[i] = (byte)(bt >>= 8 - n);
                bt >>= n;
                --i;
            }
        } else {
            bytes = new byte[this.magnitude.length + bt];
            System.arraycopy(this.magnitude, 0, bytes, 0, this.magnitude.length);
        }
        return new BigInteger(bytes, false);
    }

    public BigInteger shiftRight(int n) {
        if (n == 0) {
            return this;
        }
        if (n < 0) {
            return this.shiftLeft(-n);
        }
        int bt = n / 8;
        if (bt >= this.magnitude.length) {
            return this.signum == -1 ? bigNegOne : ZERO;
        }
        byte[] bytes = new byte[this.magnitude.length - bt];
        System.arraycopy(this.magnitude, 0, bytes, 0, this.magnitude.length - bt);
        if ((n %= 8) != 0) {
            bt = this.signum == -1 ? 65280 : 0;
            int i = 0;
            while (i < bytes.length) {
                bytes[i] = (byte)((bt |= 0xFF & (char)bytes[i]) >> n);
                bt <<= 8;
                ++i;
            }
        }
        return new BigInteger(bytes, false);
    }

    public boolean testBit(int n) {
        if (n < 0) {
            throw new ArithmeticException("cannot test bit " + n + " (negative value)");
        }
        if (n >= 8 * this.magnitude.length) {
            boolean bl = false;
            if (this.signum == -1) {
                bl = true;
            }
            return bl;
        }
        int remove = n;
        int bt = this.magnitude.length - 1 - n / 8;
        n %= 8;
        int mask = 128;
        while (n < 7) {
            mask >>= 1;
            ++n;
        }
        boolean bl = false;
        if (((char)this.magnitude[bt] & mask) != 0) {
            bl = true;
        }
        return bl;
    }

    public byte[] toByteArray() {
        if (this.signum == 0) {
            return new byte[1];
        }
        if (this.magnitude[0] >= 0 && this.signum == 1 || this.magnitude[0] < 0 && this.signum == -1) {
            byte[] b = new byte[this.magnitude.length + 1];
            System.arraycopy(this.magnitude, 0, b, 1, this.magnitude.length);
            if (this.signum == -1) {
                b[0] = -1;
            }
            return b;
        }
        return (byte[])this.magnitude.clone();
    }

    public static BigInteger valueOf(long val) {
        if (val == 0L) {
            return ZERO;
        }
        if (val == 1L) {
            return ONE;
        }
        if (val == (long)2) {
            return TWO;
        }
        if (val == (long)-1) {
            return bigNegOne;
        }
        return new BigInteger(val);
    }

    public BigInteger xor(BigInteger bi) {
        if (bi.signum == 0) {
            return this;
        }
        if (this.signum == 0) {
            return bi;
        }
        byte[] bmax = this.magnitude.length < bi.magnitude.length ? bi.magnitude : this.magnitude;
        byte[] bmin = this.magnitude == bmax ? bi.magnitude : this.magnitude;
        byte[] bytes = new byte[bmax.length + 1];
        int n = 0;
        if (this.signum == -1) {
            n = 1;
        }
        int n2 = 0 - n;
        int n3 = 0;
        if (bi.signum == -1) {
            n3 = 1;
        }
        bytes[0] = (byte)(n2 ^ 0 - n3);
        int sign = bi.magnitude.length > this.magnitude.length ? this.signum : bi.signum;
        int n4 = 0;
        if (sign == -1) {
            n4 = 1;
        }
        sign = 0 - n4;
        int dif = bmax.length - bmin.length;
        int j = 0;
        while (j < dif) {
            bytes[j + 1] = (byte)(sign ^ (char)bmax[j]);
            ++j;
        }
        int i = 0;
        int j2 = dif;
        while (i < bmin.length) {
            bytes[j2 + 1] = (byte)(bmax[j2] ^ bmin[i]);
            ++i;
            ++j2;
        }
        return new BigInteger(bytes, false);
    }

    public int signum() {
        return this.signum;
    }

    public double doubleValue() {
        int length;
        int offset;
        StringBuffer buf = new StringBuffer(this.toString(10));
        int n = 0;
        if (this.signum == -1) {
            n = offset = 1;
        }
        if ((length = buf.length() - offset) > 17) {
            buf.setLength(17 + offset);
        }
        buf.insert(offset + 1, '.');
        buf.append('E');
        buf.append(length - 1);
        try {
            return Double.parseDouble(buf.toString());
        }
        catch (NumberFormatException nfe) {
            return this.signum == -1 ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
        }
    }

    public float floatValue() {
        return (float)this.doubleValue();
    }

    public int intValue() {
        int n = 0;
        if (this.magnitude.length - 4 > 0) {
            n = this.magnitude.length - 4;
        }
        int start = n;
        int n2 = 0;
        if (this.signum == -1) {
            n2 = 1;
        }
        int result = 0 - n2;
        while (start < this.magnitude.length) {
            result = 0xFFFFFF00 & result << 8 | 0xFF & (char)this.magnitude[start];
            ++start;
        }
        return result;
    }

    public long longValue() {
        int n = 0;
        if (this.magnitude.length - 8 > 0) {
            n = this.magnitude.length - 8;
        }
        int start = n;
        int n2 = 0;
        if (this.signum == -1) {
            n2 = 1;
        }
        long result = 0 - n2;
        while (start < this.magnitude.length) {
            result = 0xFFFFFFFFFFFFFF00L & result << 8 | (long)(0xFF & (char)this.magnitude[start]);
            ++start;
        }
        return result;
    }

    public boolean isProbablePrime(int cert) {
        BigInteger thisAbs = this.abs();
        if (!this.testBit(0)) {
            return thisAbs.equals(TWO);
        }
        if (thisAbs.equals(ONE)) {
            return false;
        }
        if (THREE.equals(thisAbs) || FIVE.equals(thisAbs) || SEVEN.equals(thisAbs)) {
            return true;
        }
        int length = thisAbs.bitLength() - 1;
        BigInteger thisM1 = thisAbs.subtract(ONE);
        int i = 0;
        while (i < cert) {
            BigInteger random = new BigInteger(length, theRandom);
            while (random.signum == 0 || random.equals(ONE)) {
                random = new BigInteger(length, theRandom);
            }
            if (!ONE.equals(random.modPow(thisM1, thisAbs))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int bitCount() {
        block8: {
            if (this.bitCount != -1) break block8;
            if (this.signum == 0) {
                this.bitCount = 0;
            } else if (this.signum == 1) {
                int count = 0;
                int i = 0;
                while (i < this.magnitude.length) {
                    int b = this.magnitude[i];
                    int j = 0;
                    while (j < 8) {
                        count += b & '\u0001';
                        b >>= 1;
                        ++j;
                    }
                    ++i;
                }
            } else {
                int count = 0;
                int i = 0;
                while (i < this.magnitude.length) {
                    int b = this.magnitude[i];
                    int j = 0;
                    while (j < 8) {
                        count += 1 - (b & '\u0001');
                        b >>= 1;
                        ++j;
                    }
                    ++i;
                }
            }
        }
        return this.bitCount;
    }

    public native BigInteger add(BigInteger var1);

    public native BigInteger subtract(BigInteger var1);

    public native BigInteger multiply(BigInteger var1);

    public native BigInteger divide(BigInteger var1);

    public native BigInteger mod(BigInteger var1);

    public native BigInteger remainder(BigInteger var1);

    public BigInteger[] divideAndRemainder(BigInteger bi) {
        if (bi.signum == 0) {
            throw new ArithmeticException("cannot divide by '0'");
        }
        BigInteger[] big = new BigInteger[2];
        if (this.signum == 0) {
            big[0] = this;
            big[1] = this;
            return big;
        }
        if (bi.magnitude.length == 1) {
            byte num = bi.magnitude[0];
            if (num == 1) {
                big[0] = this;
                big[1] = ZERO;
                return big;
            }
            if (num == -1) {
                big[0] = this.negate();
                big[1] = ZERO;
                return big;
            }
        }
        if (this.magnitude.length < bi.magnitude.length) {
            big[0] = ZERO;
            big[1] = this;
        } else {
            big[0] = this.divide(bi);
            big[1] = this.remainder(bi);
        }
        return big;
    }

    public BigInteger gcd(BigInteger bi) {
        BigInteger mod;
        BigInteger valL;
        if (bi.signum == 0 || this.signum == 0) {
            return bi.signum == this.signum ? ZERO : ONE;
        }
        BigInteger valG = this.abs();
        if (valG.compareTo(valL = bi.abs()) == -1) {
            mod = valL;
            valL = valG;
            valG = mod;
        }
        while (true) {
            mod = valG.mod(valL);
            if (mod.signum == 0) {
                return valL;
            }
            valG = valL;
            valL = mod;
        }
    }

    public BigInteger modInverse(BigInteger bi) {
        if (bi.signum != 1) {
            throw new ArithmeticException();
        }
        BigInteger[][] vectors = new BigInteger[2][3];
        vectors[0][0] = ONE;
        vectors[0][1] = ZERO;
        vectors[0][2] = this.abs();
        vectors[1][0] = ZERO;
        vectors[1][1] = ONE;
        vectors[1][2] = bi;
        while (vectors[1][2].signum == 1) {
            BigInteger q = vectors[0][2].divide(vectors[1][2]);
            BigInteger t0 = vectors[0][0].subtract(vectors[1][0].multiply(q));
            BigInteger t1 = vectors[0][1].subtract(vectors[1][1].multiply(q));
            BigInteger t2 = vectors[0][2].subtract(vectors[1][2].multiply(q));
            vectors[0][0] = vectors[1][0];
            vectors[0][1] = vectors[1][1];
            vectors[0][2] = vectors[1][2];
            vectors[1][0] = t0;
            vectors[1][1] = t1;
            vectors[1][2] = t2;
        }
        if (!ONE.equals(vectors[0][2])) {
            throw new ArithmeticException("modInverse cannot be found");
        }
        if (this.signum == -1) {
            vectors[0][0] = vectors[0][0].negate();
        }
        return vectors[0][0].mod(bi);
    }

    public BigInteger modPow(BigInteger exp, BigInteger mod) {
        if (exp.signum == -1) {
            return this.modInverse(mod);
        }
        return this.pow(exp, mod).mod(mod);
    }

    public BigInteger pow(int exp) {
        if (exp < 0) {
            throw new ArithmeticException("exponent cannot be negative " + exp);
        }
        if (exp == 0) {
            return ONE;
        }
        if (exp == 1) {
            return this;
        }
        if (this.magnitude.length == 1) {
            byte num = this.magnitude[0];
            if (num == 1) {
                return this;
            }
            if (num == -1) {
                return exp % 2 == 1 ? this : ONE;
            }
        }
        BigInteger result = this;
        int bit = 1;
        while (bit <= exp) {
            bit <<= 1;
        }
        bit >>= 2;
        while (bit > 0) {
            result = result.multiply(result);
            if ((exp & bit) != 0) {
                result = this.multiply(result);
            }
            bit >>= 1;
        }
        return result;
    }

    private final BigInteger pow(BigInteger exp, BigInteger m) {
        if (exp.signum == -1) {
            throw new ArithmeticException("exponent cannot be negative " + exp);
        }
        if (exp.signum == 0) {
            return ONE;
        }
        if (this.magnitude.length == 1) {
            byte num = this.magnitude[0];
            if (num == 1) {
                return this;
            }
            if (num == -1) {
                return (exp.magnitude[exp.magnitude.length - 1] & 1) == 1 ? this : ONE;
            }
        }
        if (exp.magnitude.length == 1 && exp.magnitude[0] == 1) {
            return this;
        }
        BigInteger result = this;
        int bit = exp.bitLength() - 2;
        while (bit >= 0) {
            result = result.multiply(result).mod(m);
            if (exp.testBit(bit)) {
                result = this.multiply(result).mod(m);
            }
            --bit;
        }
        return result;
    }

    public String toString() {
        return this.toString(10);
    }

    public String toString(int rdx) {
        int n;
        if (this.signum == 0) {
            return "0";
        }
        if (this.signum == -1) {
            return "-" + this.negate().toString(rdx);
        }
        if (rdx < 2 || rdx > 36) {
            rdx = 10;
        }
        StringBuffer b = new StringBuffer();
        byte[] bytes = (byte[])this.magnitude.clone();
        int start = 0;
        do {
            b.insert(0, DIGIT_CHARS[this.oneByteDivision(rdx, bytes, start)]);
            n = 0;
            if (bytes[start] != 0) continue;
            n = 1;
        } while ((start += n) < bytes.length);
        return b.toString();
    }

    private final void javaMultiply(byte[] val, byte[] bytes) {
        int pos = bytes.length;
        int i = val.length - 1;
        while (i >= 0) {
            int carry = 0;
            int valByte = 0xFF & (char)val[i];
            int j = this.magnitude.length - 1;
            while (j >= 0) {
                int index = pos + j - this.magnitude.length;
                carry >>= 8;
                carry += valByte * (0xFF & (char)this.magnitude[j]);
                bytes[index] = (byte)(carry += 0xFF & (char)bytes[index]);
                --j;
            }
            bytes[--pos - this.magnitude.length] = (byte)(carry >> 8);
            --i;
        }
    }

    private final byte[] longToBytes(long l) {
        byte[] bytes = new byte[8];
        int i = 7;
        while (i > -1) {
            bytes[i] = (byte)l;
            l >>>= 8;
            --i;
        }
        return bytes;
    }

    private final void normelizeMagnitude(boolean clone) {
        int l = this.magnitude.length;
        int i = 0;
        while (i < l) {
            if (this.magnitude[i] != 0) break;
            ++i;
        }
        if (i != 0 || clone) {
            if (i == l) {
                this.signum = 0;
                this.magnitude = BigInteger.ZERO.magnitude;
            } else {
                byte[] bytes = new byte[l - i];
                System.arraycopy(this.magnitude, i, bytes, 0, l - i);
                this.magnitude = bytes;
            }
        }
    }

    private final void addLong(long l) {
        int carry = 0;
        int i = this.magnitude.length - 1;
        int j = 0;
        while (j < 8) {
            int overflow = (0xFF & (int)l) + (0xFF & (char)this.magnitude[i]) + carry;
            carry = (0x100 & overflow) >> 8;
            this.magnitude[i] = (byte)overflow;
            l >>= 8;
            --i;
            ++j;
        }
        while (i >= 0 && carry > 0) {
            int overflow = (0xFF & (char)this.magnitude[i]) + carry;
            carry = (0x100 & overflow) >> 8;
            this.magnitude[i] = (byte)overflow;
            --i;
        }
    }

    private final int oneByteDivision(int b, byte[] bytes, int start) {
        int remain = 0xFF & (char)bytes[start];
        if (remain >= b) {
            remain = 0;
        } else {
            bytes[start++] = 0;
        }
        int i = start;
        while (i < bytes.length) {
            remain = 0xFF & (char)bytes[i] | remain << 8;
            bytes[i] = (byte)(remain / b);
            remain %= b;
            ++i;
        }
        return remain;
    }

    private final byte[] createByteArray(int nrOfBits) {
        int bts = (nrOfBits + 1) / 8 + 1;
        byte[] bytes = new byte[bts];
        System.arraycopy(this.magnitude, 0, bytes, bts - this.magnitude.length, this.magnitude.length);
        if (this.signum == -1) {
            bts -= this.magnitude.length;
            int i = 0;
            while (i < bts) {
                bytes[i] = -1;
                ++i;
            }
        }
        return bytes;
    }

    /*
     * Unable to fully structure code
     */
    private final void initWithByteArray(byte[] bval, boolean clone) {
        block7: {
            l = bval.length;
            if (l == 0) {
                throw new NumberFormatException("byte array has length null");
            }
            i = 0;
            if (bval[0] >= 0) ** GOTO lbl15
            this.signum = -1;
            while (i < l - 1) {
                if (bval[i] == -1) {
                    ++i;
                    continue;
                }
                break block7;
            }
            break block7;
            while (bval[i] == 0) {
                ++i;
lbl15:
                // 2 sources

                if (i < l) continue;
            }
            v0 = 0;
            if (i == l) {
                v0 = 1;
            }
            this.signum = 1 - v0;
        }
        if (clone || i != 0) {
            this.magnitude = new byte[l - i];
            System.arraycopy(bval, i, this.magnitude, 0, l - i);
        } else {
            this.magnitude = bval;
        }
    }

    private final native byte[] nativeNegateBytes();

    private final /* synthetic */ void this() {
        this.lowestSetBit = -2;
        this.firstNonzeroByteNum = -2;
        this.bitCount = -1;
        this.bitLength = -1;
    }

    private BigInteger(byte[] magn, int sign) {
        this.this();
        this.magnitude = magn;
        this.signum = sign;
    }

    private BigInteger(byte[] magn, boolean clone) {
        this.this();
        this.initWithByteArray(magn, clone);
    }

    BigInteger(long l) {
        this.this();
        byte[] bytes = this.longToBytes(l);
        this.initWithByteArray(bytes, false);
    }

    public BigInteger(String val) throws NumberFormatException {
        this(val, 10);
    }

    public BigInteger(String val, int rdx) throws NumberFormatException {
        this.this();
        int len = val.length();
        if (len == 0) {
            throw new NumberFormatException("invalid string (empty string)");
        }
        boolean negative = false;
        char ch = (val = val.toLowerCase()).charAt(0);
        if (ch == '-') {
            val = val.substring(1);
            --len;
            negative = true;
        } else if (ch == '+') {
            val = val.substring(1);
            --len;
        }
        this.signum = 1;
        if (rdx < 2 || rdx > 36) {
            rdx = 10;
        }
        int digits = DIGITS_PER_LONG[rdx];
        int rem = len % digits;
        int groups = len / digits;
        int index = 0;
        if (rem != 0) {
            this.magnitude = this.longToBytes(Long.parseLong(val.substring(0, rem), rdx));
            index = rem;
        } else if (groups != 0) {
            this.magnitude = this.longToBytes(Long.parseLong(val.substring(0, digits), rdx));
            index = digits;
            --groups;
        } else {
            throw new NumberFormatException("invalid string (only sign character)");
        }
        if (groups > 0) {
            byte[] multiplier = this.longToBytes(MULTIPLIERS[rdx]);
            int i = 0;
            while (i < groups) {
                int end = index + digits;
                byte[] bytes = new byte[this.magnitude.length + 8];
                this.javaMultiply(multiplier, bytes);
                this.magnitude = bytes;
                this.addLong(Long.parseLong(val.substring(index, end), rdx));
                index = end;
                ++i;
            }
        }
        this.normelizeMagnitude(false);
        if (negative && this.signum == 1) {
            this.negateCache = new BigInteger(this.magnitude, 1);
            this.negateCache.negateCache = this;
            this.magnitude = this.nativeNegateBytes();
            this.signum = -1;
        }
    }

    public BigInteger(byte[] bval) throws NumberFormatException {
        this.this();
        this.initWithByteArray(bval, true);
    }

    public BigInteger(int sign, byte[] bval) throws NumberFormatException {
        this.this();
        if (sign > 1 || sign < -1) {
            throw new NumberFormatException("wrong sign specified :" + sign);
        }
        this.signum = sign;
        if (sign == 0) {
            this.magnitude = new byte[0];
        } else {
            this.magnitude = bval;
            this.normelizeMagnitude(true);
            if (sign == -1) {
                this.negateCache = new BigInteger(this.magnitude, 1);
                this.magnitude = this.nativeNegateBytes();
                this.negateCache.negateCache = this;
            }
        }
    }

    public BigInteger(int numbits, Random rdm) throws IllegalArgumentException {
        this.this();
        if (numbits < 0) {
            throw new IllegalArgumentException("got negative number of bits :" + numbits);
        }
        this.magnitude = new byte[(numbits - 1) / 8 + 1];
        rdm.nextBytes(this.magnitude);
        this.magnitude[0] = (byte)(255 >> 8 - numbits % 8 & (char)this.magnitude[0]);
        if (this.magnitude.length == 1 && this.magnitude[0] == 0) {
            this.magnitude = new byte[0];
        } else {
            this.signum = 1;
        }
    }

    public BigInteger(int bitLength, int cert, Random rnd) throws IllegalArgumentException {
        int msb;
        this.this();
        if (bitLength < 2) {
            throw new IllegalArgumentException("bitLength should be 2 or greater: " + bitLength);
        }
        BigInteger bi = new BigInteger(bitLength, rnd);
        int l = bi.magnitude.length;
        if (l > 0) {
            msb = 0xFF & (char)bi.magnitude[0];
            bi.magnitude[0] = (byte)(msb | 192 >> 7 - (bitLength - 1) % 8);
            bi.magnitude[l - 1] = (byte)('\u0001' | (char)bi.magnitude[l - 1]);
        }
        while (!bi.isProbablePrime(cert)) {
            bi = new BigInteger(bitLength, rnd);
            l = bi.magnitude.length;
            if (l <= 0) continue;
            msb = 0xFF & (char)bi.magnitude[0];
            bi.magnitude[0] = (byte)(msb | 192 >> 7 - (bitLength - 1) % 8);
            bi.magnitude[l - 1] = (byte)('\u0001' | (char)bi.magnitude[l - 1]);
        }
        this.signum = 1;
        this.magnitude = bi.magnitude;
    }
}

