/*
 * Decompiled with CFR 0.152.
 */
package java.math;

import java.math.BigInteger;

public class BigDecimal
extends Number
implements Comparable {
    public static final int ROUND_UP = 0;
    public static final int ROUND_DOWN = 1;
    public static final int ROUND_CEILING = 2;
    public static final int ROUND_FLOOR = 3;
    public static final int ROUND_HALF_UP = 4;
    public static final int ROUND_HALF_DOWN = 5;
    public static final int ROUND_HALF_EVEN = 6;
    public static final int ROUND_UNNECESSARY = 7;
    private static final BigInteger TEN = new BigInteger("10");
    private static final long serialVersionUID = 6108874887143696463L;
    private int scale;
    private BigInteger intVal;

    public BigDecimal abs() {
        if (this.intVal.signum() == -1) {
            return new BigDecimal(this.intVal.negate(), this.scale);
        }
        return this;
    }

    public BigDecimal add(BigDecimal val) {
        BigInteger a = val.intVal;
        BigInteger b = this.intVal;
        if (this.scale != val.scale) {
            if (this.scale > val.scale) {
                a = a.multiply(this.intToBig(this.scale - val.scale));
            } else {
                b = b.multiply(this.intToBig(val.scale - this.scale));
            }
        }
        return new BigDecimal(b.add(a), this.scale > val.scale ? this.scale : val.scale);
    }

    public int compareTo(Object o) {
        return this.compareTo((BigDecimal)o);
    }

    public int compareTo(BigDecimal o) {
        int otherSign = o.intVal.signum();
        int thisSign = this.intVal.signum();
        if (thisSign != otherSign) {
            return thisSign == 0 ? -otherSign : thisSign;
        }
        if (thisSign == 0) {
            return 0;
        }
        BigInteger a = o.intVal;
        BigInteger b = this.intVal;
        if (this.scale != o.scale) {
            if (this.scale > o.scale) {
                a = a.multiply(this.intToBig(this.scale - o.scale));
            } else {
                b = b.multiply(this.intToBig(o.scale - this.scale));
            }
        }
        return b.compareTo(a);
    }

    public BigDecimal divide(BigDecimal val, int roundMode) {
        return this.divide(val, this.scale, roundMode);
    }

    public BigDecimal divide(BigDecimal val, int newScale, int roundMode) {
        if (roundMode < 0 || roundMode > 7) {
            throw new IllegalArgumentException("invalid roundingMode");
        }
        if (newScale < 0) {
            throw new ArithmeticException("negative scale is not allowed");
        }
        int rescale = val.scale + newScale - this.scale;
        BigInteger[] big = rescale >= 0 ? this.intVal.multiply(this.intToBig(rescale)).divideAndRemainder(val.intVal) : this.intVal.divideAndRemainder(val.intVal.multiply(this.intToBig(-rescale)));
        block0 : switch (roundMode) {
            case 0: {
                if (big[1].equals(BigInteger.ZERO)) break;
                big[0] = big[0].add(this.intVal.signum() == val.intVal.signum() ? BigInteger.ONE : BigInteger.bigNegOne);
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                if (this.intVal.signum() != val.intVal.signum() || big[1].equals(BigInteger.ZERO)) break;
                big[0] = big[0].add(BigInteger.ONE);
                break;
            }
            case 3: {
                if (this.intVal.signum() == val.intVal.signum() || big[1].equals(BigInteger.ZERO)) break;
                big[0] = big[0].add(BigInteger.bigNegOne);
                break;
            }
            case 7: {
                if (big[1].equals(BigInteger.ZERO)) break;
                throw new ArithmeticException("Rounding was Needed");
            }
            default: {
                BigInteger[] remains = big[1].multiply(TEN).divideAndRemainder(val.intVal);
                String remain = remains[0].abs().toString(10);
                char ch = remain.charAt(0);
                if (ch < '5') break;
                if (ch == '5' && remains[1].equals(BigInteger.ZERO)) {
                    switch (roundMode) {
                        case 4: {
                            big[0] = big[0].add(this.intVal.signum() == val.intVal.signum() ? BigInteger.ONE : BigInteger.bigNegOne);
                            break;
                        }
                        case 5: {
                            break;
                        }
                        case 6: {
                            if (!big[0].testBit(0)) break block0;
                            big[0] = big[0].add(this.intVal.signum() == val.intVal.signum() ? BigInteger.ONE : BigInteger.bigNegOne);
                            break;
                        }
                    }
                    break;
                }
                big[0] = big[0].add(this.intVal.signum() == val.intVal.signum() ? BigInteger.ONE : BigInteger.bigNegOne);
            }
        }
        return new BigDecimal(big[0], newScale);
    }

    public double doubleValue() {
        String string;
        StringBuffer buf;
        int length;
        int offset;
        if (this.scale == 0) {
            return this.intVal.doubleValue();
        }
        int n = 0;
        if (this.intVal.signum() == -1) {
            n = offset = 1;
        }
        if ((length = (buf = new StringBuffer(string = this.intVal.toString(10))).length() - offset) <= this.scale) {
            buf.insert(offset + 1, '.');
            if (length > 17) {
                buf.setLength(offset + 18);
            }
            if (this.scale > length) {
                buf.append("E-");
                buf.append(this.scale + 1 - length);
            }
        } else if (length > 17) {
            buf.insert(offset + 1, '.');
            buf.setLength(offset + 18);
            buf.append('E');
            buf.append(length - this.scale);
        } else {
            buf.insert(length + offset - this.scale, '.');
        }
        try {
            return Double.parseDouble(buf.toString());
        }
        catch (NumberFormatException nfe) {
            return this.intVal.signum() == -1 ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof BigDecimal)) {
            return false;
        }
        BigDecimal bd = (BigDecimal)o;
        boolean bl = false;
        if (this.scale == bd.scale && this.intVal.equals(bd.intVal)) {
            bl = true;
        }
        return bl;
    }

    public float floatValue() {
        return (float)this.doubleValue();
    }

    public int hashCode() {
        return this.scale ^ this.intVal.hashCode();
    }

    public int intValue() {
        return (int)this.longValue();
    }

    public long longValue() {
        if (this.scale == 0) {
            return this.intVal.longValue();
        }
        return this.setScale((int)0, (int)1).intVal.longValue();
    }

    public BigDecimal max(BigDecimal val) {
        return this.compareTo(val) > 0 ? this : val;
    }

    public BigDecimal min(BigDecimal val) {
        return this.compareTo(val) < 0 ? this : val;
    }

    public BigDecimal movePointLeft(int n) {
        if (n <= 0) {
            return this.movePointRight(-n);
        }
        return new BigDecimal(this.intVal, this.scale + n);
    }

    public BigDecimal movePointRight(int n) {
        if (n == 0) {
            return this;
        }
        if (n < 0) {
            return this.movePointLeft(-n);
        }
        int newScale = this.scale - n;
        if (newScale < 0) {
            return new BigDecimal(this.intVal.multiply(this.intToBig(-newScale)), 0);
        }
        return new BigDecimal(this.intVal, newScale);
    }

    public BigDecimal multiply(BigDecimal val) {
        return new BigDecimal(this.intVal.multiply(val.intVal), this.scale + val.scale);
    }

    public BigDecimal negate() {
        return new BigDecimal(this.intVal.negate(), this.scale);
    }

    public int scale() {
        return this.scale;
    }

    public BigDecimal setScale(int newScale) {
        return this.setScale(newScale, 7);
    }

    public BigDecimal setScale(int newScale, int roundMode) {
        if (newScale < 0) {
            throw new ArithmeticException();
        }
        if (newScale == this.scale) {
            return this;
        }
        if (newScale > this.scale) {
            return new BigDecimal(this.intVal.multiply(this.intToBig(newScale - this.scale)), newScale);
        }
        if (roundMode < 0 || roundMode > 7) {
            throw new IllegalArgumentException("bad Rounding mode");
        }
        BigInteger[] big = this.intVal.divideAndRemainder(this.intToBig(this.scale - newScale));
        block0 : switch (roundMode) {
            case 0: {
                if (big[1].equals(BigInteger.ZERO)) break;
                big[0] = big[0].add(this.intVal.signum() == 1 ? BigInteger.ONE : BigInteger.bigNegOne);
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                if (this.intVal.signum() != 1 || big[1].equals(BigInteger.ZERO)) break;
                big[0] = big[0].add(BigInteger.ONE);
                break;
            }
            case 3: {
                if (this.intVal.signum() != -1 || big[1].equals(BigInteger.ZERO)) break;
                big[0] = big[0].add(BigInteger.bigNegOne);
                break;
            }
            case 7: {
                if (big[1].equals(BigInteger.ZERO)) break;
                throw new ArithmeticException();
            }
            default: {
                String remain = big[1].abs().toString(10);
                char ch = remain.charAt(0);
                if (ch < '5') break;
                if (ch == '5' && remain.replace('0', ' ').trim().length() == 1) {
                    switch (roundMode) {
                        case 4: {
                            big[0] = big[0].add(this.intVal.signum() == 1 ? BigInteger.ONE : BigInteger.bigNegOne);
                            break;
                        }
                        case 5: {
                            break;
                        }
                        case 6: {
                            if (!big[0].testBit(0)) break block0;
                            big[0] = big[0].add(this.intVal.signum() == 1 ? BigInteger.ONE : BigInteger.bigNegOne);
                            break;
                        }
                    }
                    break;
                }
                big[0] = big[0].add(this.intVal.signum() == 1 ? BigInteger.ONE : BigInteger.bigNegOne);
            }
        }
        return new BigDecimal(big[0], newScale);
    }

    public int signum() {
        return this.intVal.signum();
    }

    public BigDecimal subtract(BigDecimal val) {
        return this.add(val.negate());
    }

    public static BigDecimal valueOf(long val) {
        return BigDecimal.valueOf(val, 0);
    }

    public static BigDecimal valueOf(long val, int scale) {
        return new BigDecimal(BigInteger.valueOf(val), scale);
    }

    public BigInteger toBigInteger() {
        if (this.scale == 0) {
            return this.intVal;
        }
        return this.setScale((int)0, (int)1).intVal;
    }

    public String toString() {
        int dot;
        if (this.scale == 0) {
            return this.intVal.toString();
        }
        String val = this.intVal.abs().toString();
        StringBuffer buf = new StringBuffer(val.length() + 1);
        if (this.intVal.signum() == -1) {
            buf.append('-');
        }
        if ((dot = val.length() - this.scale) > 0) {
            buf.append(val.substring(0, dot));
            buf.append('.');
            buf.append(val.substring(dot));
        } else {
            buf.append("0.");
            while (dot < 0) {
                buf.append('0');
                ++dot;
            }
            buf.append(val.substring(0));
        }
        return buf.toString();
    }

    private final BigInteger intToBig(int i) {
        return TEN.pow(i);
    }

    public BigDecimal(BigInteger bi) {
        this(bi, 0);
    }

    public BigDecimal(BigInteger bi, int scl) throws NumberFormatException {
        if (bi == null) {
            throw new NullPointerException();
        }
        if (scl < 0) {
            throw new NumberFormatException("scale cannot be negative");
        }
        this.intVal = bi;
        this.scale = scl;
    }

    public BigDecimal(String val) throws NumberFormatException {
        int dot = val.indexOf(46);
        if (dot != -1) {
            this.scale = val.length() - 1 - dot;
            val = val.substring(0, dot) + val.substring(dot + 1);
        }
        this.intVal = new BigInteger(val, 10);
        if (this.scale < 0) {
            throw new NumberFormatException("problem constructing " + val);
        }
    }

    public BigDecimal(double d) throws NumberFormatException {
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            throw new NumberFormatException("double value cannot be infinite or NaN " + d);
        }
        String val = Double.toString(d);
        int exp = val.indexOf(69);
        if (exp != -1) {
            this.scale = Integer.parseInt(val.substring(exp + 1));
        }
        int dot = val.indexOf(46);
        StringBuffer buf = new StringBuffer(val.substring(0, dot));
        String decPart = val.substring(dot + 1, exp == -1 ? val.length() : exp);
        if (decPart.length() > 1 || !decPart.startsWith("0")) {
            buf.append(decPart);
        } else {
            ++dot;
        }
        this.intVal = new BigInteger(buf.toString());
        this.scale = (exp == -1 ? val.length() : exp) - dot - 1 - this.scale;
        if (this.scale < 0) {
            this.intVal = this.intVal.multiply(this.intToBig(-this.scale));
            this.scale = 0;
        }
    }
}

