/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Hashtable;
import java.util.Vector;

public class Proxy
implements Serializable {
    private static final long serialVersionUID = -2222568056686623797L;
    private static final int CLASS_ACCESS_FLAGS = 49;
    private static final int INIT_ACCESS_FLAGS = 1;
    private static Hashtable proxies = new Hashtable();
    private static Method method_defineProxyClass;
    private static Method method_hashCode;
    private static Method method_equals;
    private static Method method_toString;
    protected InvocationHandler h;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$ClassLoader;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$reflect$Proxy;
    static /* synthetic */ Class class$java$lang$reflect$InvocationHandler;

    protected Proxy(InvocationHandler h) {
        this.h = h;
    }

    public static InvocationHandler getInvocationHandler(Object object) throws IllegalArgumentException {
        if (object instanceof Proxy) {
            return ((Proxy)object).h;
        }
        throw new IllegalArgumentException("'" + object + "' is not a Proxy");
    }

    private static String proxypackage(Vector proxyspec) {
        String string = null;
        int l = proxyspec.size();
        for (int i = 1; i < l; ++i) {
            Class c = (Class)proxyspec.elementAt(i);
            if (Modifier.isPublic(c.getModifiers())) continue;
            if (string == null) {
                string = c.getPackage().getName();
                continue;
            }
            throw new IllegalArgumentException("chimerical interfaces");
        }
        return string;
    }

    private static String proxyname(Vector proxyspec) {
        StringBuffer s = new StringBuffer();
        String pkgname = Proxy.proxypackage(proxyspec);
        if (pkgname != null) {
            s.append(pkgname);
            s.append('.');
        }
        s.append("$Proxy$$");
        s.append(Integer.toHexString(proxyspec.hashCode()));
        s.append("$$");
        s.append(proxyspec.elementAt(0).getClass().getName());
        int l = proxyspec.size();
        for (int i = 1; i < l; ++i) {
            s.append("$$");
            s.append(((Class)proxyspec.elementAt(i)).getName());
        }
        return s.toString().replace('.', '_');
    }

    private static byte[] utf8Constant(String string) {
        ByteArrayOutputStream temp = new ByteArrayOutputStream();
        try {
            byte[] b = string.getBytes("UTF8");
            temp.write(1);
            temp.write((b.length & 0xFF00) >> 8);
            temp.write(b.length & 0xFF);
            temp.write(b);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return temp.toByteArray();
    }

    private static String descriptor(Class c) {
        if (c == Void.TYPE) {
            return "V";
        }
        if (c == Boolean.TYPE) {
            return "Z";
        }
        if (c == Byte.TYPE) {
            return "B";
        }
        if (c == Short.TYPE) {
            return "S";
        }
        if (c == Character.TYPE) {
            return "C";
        }
        if (c == Integer.TYPE) {
            return "I";
        }
        if (c == Float.TYPE) {
            return "F";
        }
        if (c == Long.TYPE) {
            return "J";
        }
        if (c == Double.TYPE) {
            return "D";
        }
        if (c.isArray()) {
            return "[" + Proxy.descriptor(c.getComponentType());
        }
        return "L" + c.getName().replace('.', '/') + ";";
    }

    private static Class makeproxy(Vector proxyspec) {
        int i;
        int numInterfaces = proxyspec.size() - 1;
        String name = Proxy.proxyname(proxyspec);
        ClassFile classfile = new ClassFile();
        classfile.addConstant(new byte[]{7, 0, 2});
        classfile.addConstant(Proxy.utf8Constant(name.replace('.', '/')));
        int super_index = classfile.addClassConstant(class$java$lang$reflect$Proxy == null ? (class$java$lang$reflect$Proxy = Proxy.class$("java.lang.reflect.Proxy")) : class$java$lang$reflect$Proxy);
        int init_index = classfile.getUtf8Constant("<init>");
        int init_desc_index = classfile.getUtf8Constant("(Ljava/lang/reflect/InvocationHandler;)V");
        int init_nat_index = classfile.addConstant(new byte[]{12, 0, (byte)init_index, 0, (byte)init_desc_index});
        int init_method_index = classfile.addConstant(new byte[]{10, 0, (byte)super_index, 0, (byte)init_nat_index});
        int code_tag_index = classfile.addConstant(Proxy.utf8Constant("Code"));
        int[] itf_index = new int[numInterfaces];
        for (i = 0; i < numInterfaces; ++i) {
            itf_index[i] = classfile.addClassConstant((Class)proxyspec.elementAt(i + 1));
            System.out.println("itf_index[" + i + "] = " + itf_index[i]);
        }
        classfile.write16(51966);
        classfile.write16(47806);
        classfile.write16(3);
        classfile.write16(70);
        classfile.writeConstants();
        classfile.write16(49);
        classfile.write16(1);
        classfile.write16(super_index);
        classfile.write16(numInterfaces);
        for (i = 0; i < numInterfaces; ++i) {
            classfile.write16(itf_index[i]);
        }
        classfile.write16(0);
        classfile.write16(1);
        classfile.write16(1);
        classfile.write16(init_index);
        classfile.write16(init_desc_index);
        classfile.write16(1);
        classfile.write16(code_tag_index);
        classfile.write16(0);
        classfile.write16(16);
        classfile.write16(2);
        classfile.write16(2);
        classfile.write16(0);
        classfile.write16(6);
        classfile.write(new byte[]{42, 43, -73, 0, (byte)init_method_index, -79});
        classfile.write16(0);
        classfile.write16(0);
        classfile.write16(0);
        ClassLoader cl = (ClassLoader)proxyspec.elementAt(0);
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        byte[] b = classfile.toByteArray();
        Class c = null;
        try {
            method_defineProxyClass.setAccessible(true);
            c = (Class)method_defineProxyClass.invoke(cl, new Object[]{name, b, new Integer(0), new Integer(b.length)});
            method_defineProxyClass.setAccessible(false);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Class getProxyClass(ClassLoader loader, Class[] interfaces) throws IllegalArgumentException {
        Vector proxyspec = new Vector(interfaces.length + 1);
        proxyspec.addElement(loader);
        int l = interfaces.length;
        for (int i = 0; i < l; ++i) {
            proxyspec.addElement(interfaces[i]);
        }
        Hashtable hashtable = proxies;
        synchronized (hashtable) {
            Class proxy = (Class)proxies.get(proxyspec);
            if (proxy != null) {
                System.out.println("Returning existing proxy " + proxy);
                return proxy;
            }
            proxy = Proxy.makeproxy(proxyspec);
            proxies.put(proxyspec, proxy);
            System.out.println("Returning new proxy " + proxy);
            return proxy;
        }
    }

    public static boolean isProxyClass(Class clazz) {
        return false;
    }

    public static Object newProxyInstance(ClassLoader loader, Class[] interfaces, InvocationHandler h) throws IllegalArgumentException {
        Class proxy = Proxy.getProxyClass(loader, interfaces);
        try {
            Constructor constructor = proxy.getConstructor(new Class[]{class$java$lang$reflect$InvocationHandler == null ? (class$java$lang$reflect$InvocationHandler = Proxy.class$("java.lang.reflect.InvocationHandler")) : class$java$lang$reflect$InvocationHandler});
            return constructor.newInstance(new Object[]{h});
        }
        catch (NoSuchMethodException nsme) {
            throw new UnknownError(proxy + " has no constructor taking an InvocationHandler as argument : " + nsme);
        }
        catch (InstantiationException ie) {
            throw new UnknownError(proxy + " is abstract (???) : " + ie);
        }
        catch (IllegalAccessException iae) {
            throw new UnknownError(proxy + " constructor is not public : " + iae);
        }
        catch (InvocationTargetException ite) {
            throw new UnknownError(proxy + "constructor failed : " + ite);
        }
    }

    public static void main(String[] args) {
        Class[] interfaces = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            try {
                interfaces[i] = Class.forName(args[i]);
                continue;
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        Class p = Proxy.getProxyClass(ClassLoader.getSystemClassLoader(), interfaces);
        Class[] if2 = p.getInterfaces();
        for (int i = 0; i < if2.length; ++i) {
            System.out.println("  interface[" + i + "] = " + if2[i]);
        }
        Method[] m = p.getMethods();
        for (int i = 0; i < m.length; ++i) {
            System.out.println("  public method[" + i + "] = " + m[i]);
        }
        Class p2 = Proxy.getProxyClass(ClassLoader.getSystemClassLoader(), interfaces);
        System.out.println("p==p2 is " + (p == p2));
        try {
            myIH ih = new myIH();
            System.out.println("ih = " + ih);
            Runnable r = (Runnable)p.getConstructor(new Class[]{class$java$lang$reflect$InvocationHandler == null ? (class$java$lang$reflect$InvocationHandler = Proxy.class$("java.lang.reflect.InvocationHandler")) : class$java$lang$reflect$InvocationHandler}).newInstance(new Object[]{ih});
            r.run();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public int hashCode() {
        try {
            return (Integer)this.h.invoke(this, method_hashCode, null);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable t) {
            throw new UndeclaredThrowableException(t);
        }
    }

    public boolean equals(Object o) {
        try {
            return (Boolean)this.h.invoke(this, method_equals, new Object[]{o});
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable t) {
            throw new UndeclaredThrowableException(t);
        }
    }

    public String toString() {
        try {
            return (String)this.h.invoke(this, method_toString, null);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable t) {
            throw new UndeclaredThrowableException(t);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            Class class_bytearray = Class.forName("[B");
            method_defineProxyClass = (class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = Proxy.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader).getDeclaredMethod("defineProxyClass", new Class[]{class$java$lang$String == null ? (class$java$lang$String = Proxy.class$("java.lang.String")) : class$java$lang$String, class_bytearray, Integer.TYPE, Integer.TYPE});
            method_hashCode = (class$java$lang$Object == null ? (class$java$lang$Object = Proxy.class$("java.lang.Object")) : class$java$lang$Object).getDeclaredMethod("hashCode", null);
            method_equals = (class$java$lang$Object == null ? (class$java$lang$Object = Proxy.class$("java.lang.Object")) : class$java$lang$Object).getDeclaredMethod("equals", new Class[]{class$java$lang$Object == null ? (class$java$lang$Object = Proxy.class$("java.lang.Object")) : class$java$lang$Object});
            method_toString = (class$java$lang$Object == null ? (class$java$lang$Object = Proxy.class$("java.lang.Object")) : class$java$lang$Object).getDeclaredMethod("toString", null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static class myIH
    implements InvocationHandler {
        private myIH() {
        }

        public Object invoke(Object proxy, Method method, Object[] args) {
            System.out.println(proxy + " : " + method + " called with " + args.length + " args");
            for (int i = 0; i < args.length; ++i) {
                System.out.println("    " + args[i]);
            }
            return null;
        }
    }

    private static class ClassFile {
        private ByteArrayOutputStream s = new ByteArrayOutputStream();
        private Vector constants = new Vector();

        ClassFile() {
        }

        void write16(int w) {
            try {
                this.s.write((w & 0xFF00) >> 8);
                this.s.write(w & 0xFF);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        void write(byte[] b) {
            try {
                this.s.write(b);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        int addConstant(byte[] b) {
            this.constants.add(b);
            return this.constants.size();
        }

        int getUtf8Constant(String string) {
            int n = this.constants.size();
            this.constants.add(Proxy.utf8Constant(string));
            return n + 1;
        }

        int addClassConstant(Class c) {
            int n = this.constants.size();
            this.constants.add(new byte[]{7, 0, (byte)(n + 2)});
            this.constants.add(Proxy.utf8Constant(c.getName().replace('.', '/')));
            return n + 1;
        }

        void writeConstants() {
            int n = this.constants.size();
            this.write16(n + 1);
            try {
                for (int i = 0; i < n; ++i) {
                    this.write((byte[])this.constants.elementAt(i));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.constants = null;
        }

        byte[] toByteArray() {
            return this.s.toByteArray();
        }
    }
}

