/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public final class Constructor
extends AccessibleObject
implements Member {
    public native Class getDeclaringClass();

    public native String getName();

    public native int getModifiers();

    public native Class[] getParameterTypes();

    public native Class[] getExceptionTypes();

    public boolean equals(Object obj) {
        return obj instanceof Constructor && this.toString().equals(obj.toString());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String toString() {
        StringBuffer result = new StringBuffer(100);
        result.append(Modifier.toString(this.getModifiers()));
        if (result.length() > 0) {
            result.append(' ');
        }
        result.append(this.getName());
        Class[] args = this.getParameterTypes();
        result.append('(');
        for (int i = 0; i < args.length; ++i) {
            if (i > 0) {
                result.append(',');
            }
            result.append(Method.getClassName(args[i]));
        }
        result.append(')');
        args = this.getExceptionTypes();
        int l = args.length;
        if (l != 0) {
            result.append(" throws ");
            for (int i = 0; i < l; ++i) {
                result.append(Method.getClassName(args[i]));
                result.append(",");
            }
            result.setLength(result.length() - 1);
        }
        return result.toString();
    }

    public Object newInstance(Object[] initargs) throws InstantiationException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (initargs == null) {
            initargs = new Object[]{};
        }
        if (Modifier.isAbstract(this.getModifiers())) {
            throw new InstantiationException();
        }
        return this.newInstance0(initargs);
    }

    public native Object newInstance0(Object[] var1) throws InstantiationException, IllegalArgumentException, IllegalAccessException, InvocationTargetException;
}

