/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.util.Enumeration;
import java.util.Vector;

public class ThreadGroup {
    private final String name;
    private int stackSize;
    private boolean destroyed;
    private boolean daemon;
    protected ThreadGroup parent;
    protected Vector children;
    protected Vector flock;

    public ThreadGroup(String name) throws SecurityException {
        this(Thread.currentThread().getThreadGroup(), name);
    }

    public ThreadGroup(ThreadGroup parent, String name) throws NullPointerException, SecurityException, IllegalThreadStateException {
        Thread.currentThread().getThreadGroup().checkAccess();
        if (parent == null) {
            throw new NullPointerException();
        }
        if (parent.destroyed) {
            throw new IllegalThreadStateException();
        }
        this.name = name;
        this.parent = parent;
        this.create(parent, name);
        parent.registerThreadGroup(this);
    }

    private native void create(ThreadGroup var1, String var2);

    public String toString() {
        return "[name=" + this.name + ",maxpri=" + this.getMaxPriority() + "]";
    }

    public final void checkAccess() throws SecurityException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerThread(Thread t) {
        ThreadGroup threadGroup = this;
        synchronized (threadGroup) {
            if (this.flock == null) {
                this.flock = new Vector();
            }
        }
        this.flock.add(t);
    }

    private synchronized void deregisterThread(Thread t) {
        this.flock.remove(t);
        this.checkForTermination();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerThreadGroup(ThreadGroup tg) {
        ThreadGroup threadGroup = this;
        synchronized (threadGroup) {
            if (this.children == null) {
                this.children = new Vector();
            }
        }
        this.children.add(tg);
    }

    private synchronized void deregisterThreadGroup(ThreadGroup tg) {
        this.children.remove(tg);
        this.checkForTermination();
    }

    private void checkForTermination() {
        if (!(!this.daemon || this.children != null && this.children.size() != 0 || this.flock != null && this.flock.size() != 0 || this.parent == null)) {
            this.parent.deregisterThreadGroup(this);
            this.parent = null;
        }
    }

    public int activeCount() {
        Enumeration e;
        int count = 0;
        if (this.flock != null) {
            e = this.flock.elements();
            while (e.hasMoreElements()) {
                if (!((Thread)e.nextElement()).isAlive()) continue;
                ++count;
            }
        }
        if (this.children != null) {
            e = this.children.elements();
            while (e.hasMoreElements()) {
                count += ((ThreadGroup)e.nextElement()).activeCount();
            }
        }
        return count;
    }

    public int activeGroupCount() {
        if (this.children == null) {
            return 0;
        }
        int count = this.children.size();
        Enumeration e = this.children.elements();
        while (e.hasMoreElements()) {
            count += ((ThreadGroup)e.nextElement()).activeGroupCount();
        }
        return count;
    }

    public int enumerate(ThreadGroup[] list) {
        int max = list.length;
        int i = this.children.size();
        if (max > i) {
            max = i;
        }
        for (i = 0; i < max; ++i) {
            list[i] = (ThreadGroup)this.children.get(i);
        }
        return max;
    }

    public int enumerate(ThreadGroup[] list, boolean recursive) {
        if (recursive) {
            return this.enumerate(list);
        }
        return this.enumerate(list);
    }

    public int enumerate(Thread[] threads) {
        return this.enumerate(threads, false);
    }

    public int enumerate(Thread[] threads, boolean recurse) {
        int i = 0;
        if (this.flock != null) {
            Enumeration et = this.flock.elements();
            while (i < threads.length && et.hasMoreElements()) {
                threads[i++] = (Thread)et.nextElement();
            }
        }
        if (!recurse) {
            return i;
        }
        if (this.children != null) {
            Enumeration echild = this.children.elements();
            while (i < threads.length && echild.hasMoreElements()) {
                ThreadGroup nextTG = (ThreadGroup)echild.nextElement();
                Thread[] temp = new Thread[nextTG.activeCount()];
                int l = this.enumerate(temp, true);
                if (i + l > threads.length) {
                    System.arraycopy(temp, 0, threads, i, threads.length - i);
                    return threads.length;
                }
                System.arraycopy(temp, 0, threads, i, l);
                i += l;
            }
        }
        return i;
    }

    public final native String getName();

    public final ThreadGroup getParent() {
        return this.parent;
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    public final boolean parentOf(ThreadGroup group) {
        if (this.children == null) {
            return false;
        }
        if (this.children.contains(group)) {
            return true;
        }
        Enumeration e = this.children.elements();
        while (e.hasMoreElements()) {
            if (!((ThreadGroup)e.nextElement()).parentOf(group)) continue;
            return true;
        }
        return false;
    }

    public final synchronized void stop() throws SecurityException {
        Enumeration e;
        this.checkAccess();
        if (this.children != null) {
            e = this.children.elements();
            while (e.hasMoreElements()) {
                ((ThreadGroup)e.nextElement()).stop();
            }
            this.children = null;
        }
        if (this.flock != null) {
            Thread ownthread = Thread.currentThread();
            boolean suicide = false;
            Vector snapshot = (Vector)this.flock.clone();
            e = snapshot.elements();
            while (e.hasMoreElements()) {
                Thread t = (Thread)e.nextElement();
                if (t == ownthread) {
                    suicide = true;
                    continue;
                }
                t.stop();
            }
            if (suicide) {
                ownthread.stop();
            }
        }
        if (this.daemon && this.parent != null) {
            this.parent.deregisterThreadGroup(this);
            this.parent = null;
        }
    }

    public final synchronized void interrupt() throws SecurityException {
        Enumeration e;
        this.checkAccess();
        if (this.children != null) {
            e = this.children.elements();
            while (e.hasMoreElements()) {
                ((ThreadGroup)e.nextElement()).interrupt();
            }
            this.children = null;
        }
        if (this.flock != null) {
            Thread ownthread = Thread.currentThread();
            boolean suicide = false;
            Vector snapshot = (Vector)this.flock.clone();
            e = snapshot.elements();
            while (e.hasMoreElements()) {
                Thread t = (Thread)e.nextElement();
                if (t == ownthread) continue;
                t.interrupt();
            }
        }
    }

    public final synchronized void suspend() throws SecurityException {
        Enumeration e;
        this.checkAccess();
        if (this.destroyed) {
            throw new IllegalThreadStateException();
        }
        if (this.children != null) {
            e = this.children.elements();
            while (e.hasMoreElements()) {
                ((ThreadGroup)e.nextElement()).suspend();
            }
        }
        if (this.flock != null) {
            e = this.flock.elements();
            while (e.hasMoreElements()) {
                ((Thread)e.nextElement()).suspend();
            }
        }
    }

    public final synchronized void resume() throws SecurityException {
        Enumeration e;
        this.checkAccess();
        if (this.destroyed) {
            throw new IllegalThreadStateException();
        }
        if (this.children != null) {
            e = this.children.elements();
            while (e.hasMoreElements()) {
                ((ThreadGroup)e.nextElement()).suspend();
            }
        }
        if (this.flock != null) {
            e = this.flock.elements();
            while (e.hasMoreElements()) {
                ((Thread)e.nextElement()).suspend();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void destroy() throws SecurityException, IllegalThreadStateException {
        this.checkAccess();
        if (this.destroyed) {
            throw new IllegalThreadStateException();
        }
        this.destroyed = true;
        if (this.flock != null && this.flock.size() != 0) {
            this.destroyed = false;
            throw new IllegalThreadStateException();
        }
        if (this.children != null) {
            while (this.children.size() > 0) {
                Vector vector = this.children;
                synchronized (vector) {
                    ((ThreadGroup)this.children.elementAt(this.children.size() - 1)).destroy();
                }
            }
        }
        if (this.parent != null) {
            this.parent.deregisterThreadGroup(this);
            this.parent = null;
        }
    }

    private native void setMaxPriority0(int var1);

    public final native int getMaxPriority();

    public final void setMaxPriority(int newMaxPriority) throws SecurityException, IllegalArgumentException {
        this.checkAccess();
        if (newMaxPriority < 1 || newMaxPriority > 10) {
            throw new IllegalArgumentException();
        }
        this.setMaxPriority0(newMaxPriority);
    }

    public final boolean isDaemon() {
        return this.daemon;
    }

    public final void setDaemon(boolean daemon) throws SecurityException {
        this.checkAccess();
        this.daemon = daemon;
    }

    public void list() {
        this.list0(0);
    }

    private void list0(int indent) {
        Enumeration e;
        int i;
        StringBuffer b = new StringBuffer();
        for (i = 0; i < indent; ++i) {
            b.append("    ");
        }
        b.append(this.toString());
        System.out.println(b.toString());
        if (this.flock != null) {
            b.setLength(indent * 4);
            b.append("    ");
            e = this.flock.elements();
            while (e.hasMoreElements()) {
                for (i = 0; i < indent * 4; ++i) {
                    b.append(' ');
                }
                b.append(((Thread)e.nextElement()).toString());
                System.out.println(b.toString());
                b.setLength(indent * 4 + 4);
            }
        }
        if (this.children != null) {
            e = this.children.elements();
            while (e.hasMoreElements()) {
                ((ThreadGroup)e.nextElement()).list0(indent + 1);
            }
        }
    }

    public void uncaughtException(Thread t, Throwable e) {
        if (this.parent != null) {
            this.parent.uncaughtException(t, e);
        } else if (!(e instanceof ThreadDeath)) {
            e.printStackTrace(System.err);
        }
        this.flock.remove(t);
        this.checkForTermination();
    }
}

