/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.util.Random;

public final class Math {
    public static final double E = 2.718281828459045;
    public static final double PI = 3.141592653589793;
    private static final long d_signbit = Long.MIN_VALUE;
    private static final long d_expbits = 0x7FF0000000000000L;
    private static final long d_offsetbits = 0x3FF0000000000000L;
    private static final long d_mantbits = 0xFFFFFFFFFFFFFL;
    private static final int f_signbit = Integer.MIN_VALUE;
    private static final int f_expbits = 2139095040;
    private static final double twopi = 6.283185307179586;
    private static final double halfpi = 1.5707963267948966;
    private static final double quarterpi = 0.7853981633974483;
    private static final double tiny = Double.longBitsToDouble(0x1FF0000000000000L);
    private static final double logbignum = Math.log(Double.MAX_VALUE);
    private static Random RNG = null;

    private Math() {
    }

    public static double sqrt(double arg) {
        if (arg < 0.0 || arg != arg) {
            return Double.NaN;
        }
        if (arg == Double.POSITIVE_INFINITY) {
            return arg;
        }
        if (arg < tiny) {
            return arg * 0.5;
        }
        long bits = Double.doubleToLongBits(arg);
        long magbits = bits & 0x7FF0000000000000L;
        double multiplier = Double.longBitsToDouble(magbits);
        double fraction = Double.longBitsToDouble(bits & 0xFFFFFFFFFFFFFL | 0x3FF0000000000000L);
        if ((magbits & 0x10000000000000L) == 0L) {
            multiplier *= 0.5;
            fraction *= 2.0;
        }
        multiplier = Double.longBitsToDouble((magbits - 0x3FF0000000000000L >> 1) + 0x3FF0000000000000L & 0x7FF0000000000000L);
        double root = fraction * 0.5;
        root = (root + fraction / root) * 0.5;
        root = (root + fraction / root) * 0.5;
        root = (root + fraction / root) * 0.5;
        root = (root + fraction / root) * 0.5;
        root = (root + fraction / root) * 0.5;
        root = (root + fraction / root) * 0.5;
        return root * multiplier;
    }

    private static final double sine(double theta) {
        double temp = theta * theta;
        temp = theta * theta * (1.0 - temp / 156.0);
        temp = theta * theta * (1.0 - temp / 110.0);
        temp = theta * theta * (1.0 - temp / 72.0);
        temp = theta * theta * (1.0 - temp / 42.0);
        temp = theta * theta * (1.0 - temp / 20.0);
        temp = theta * (1.0 - temp / 6.0);
        return temp;
    }

    public static double sin(double arg) {
        if (arg > -tiny && arg < tiny || arg != arg) {
            return arg;
        }
        double theta = arg % (Math.PI * 2);
        if (theta <= -Math.PI) {
            theta += Math.PI * 2;
        } else if (theta > Math.PI) {
            theta -= Math.PI * 2;
        }
        int phase = (int)(theta / 0.7853981633974483);
        switch (phase) {
            case -1: 
            case 0: {
                return Math.sine(theta);
            }
            case 1: {
                double temp = Math.sine(1.5707963267948966 - theta);
                return Math.sqrt(1.0 - temp * temp);
            }
            case -3: 
            case -2: {
                double temp = Math.sine(-1.5707963267948966 - theta);
                return -Math.sqrt(1.0 - temp * temp);
            }
            case 2: {
                double temp = Math.sine(theta - 1.5707963267948966);
                return Math.sqrt(1.0 - temp * temp);
            }
        }
        return Math.sine(Math.PI - theta);
    }

    public static double cos(double arg) {
        if (arg > -tiny && arg < tiny) {
            return 1.0;
        }
        if (arg != arg) {
            return arg;
        }
        double theta = arg % (Math.PI * 2);
        if (theta <= -Math.PI) {
            theta += Math.PI * 2;
        } else if (theta > Math.PI) {
            theta -= Math.PI * 2;
        }
        int phase = (int)(theta / 0.7853981633974483);
        switch (phase) {
            case -1: 
            case 0: {
                double temp = Math.sine(theta);
                return Math.sqrt(1.0 - temp * temp);
            }
            case 1: 
            case 2: {
                return -Math.sine(theta - 1.5707963267948966);
            }
            case -3: 
            case -2: {
                return Math.sine(1.5707963267948966 + theta);
            }
        }
        double temp = Math.sine(Math.PI - theta);
        return -Math.sqrt(1.0 - temp * temp);
    }

    public static double tan(double arg) {
        if (arg > -tiny && arg < tiny) {
            return arg;
        }
        return Math.sin(arg) / Math.cos(arg);
    }

    private static double arcrat(double x) {
        double numer = -0.6967457344735065 * x;
        numer = (numer + 10.152522233806463) * x;
        numer = (numer - 39.68886299750488) * x;
        numer = (numer + 57.20822787789173) * x;
        numer = (numer - 27.368494524164255) * x;
        double denom = x;
        denom = (denom - 23.823859153670238) * x;
        denom = (denom + 150.95270841030606) * x;
        denom = (denom - 381.8630336175015) * x;
        denom = (denom + 417.14430248260413) * x;
        return numer / (denom -= 164.2109671449856);
    }

    public static double asin(double arg) {
        double sign;
        double absval;
        if (arg > -tiny && arg < tiny || arg != arg) {
            return arg;
        }
        if (arg > 0.0) {
            if (arg > 1.0) {
                return Double.NaN;
            }
            if (arg > 0.5) {
                return 1.5707963267948966 - 2.0 * Math.asin(Math.sqrt((1.0 - arg) * 0.5));
            }
            absval = arg;
            sign = 1.0;
        } else {
            if (arg < -1.0) {
                return Double.NaN;
            }
            if (arg < -0.5) {
                return 2.0 * Math.asin(Math.sqrt((1.0 + arg) * 0.5)) - 1.5707963267948966;
            }
            absval = -arg;
            sign = -1.0;
        }
        return sign * (absval + absval * Math.arcrat(arg * arg));
    }

    public static double acos(double arg) {
        return 1.5707963267948966 - Math.asin(arg);
    }

    private static double tancrat(double x) {
        double numer = -0.8375829936815006 * x;
        numer = (numer - 8.494624035132068) * x;
        numer = (numer - 20.505855195861653) * x;
        numer = (numer - 13.688768894191927) * x;
        double denom = x;
        denom = (denom + 15.024001160028575) * x;
        denom = (denom + 59.57843614259735) * x;
        denom = (denom + 86.15734959713025) * x;
        return numer / (denom += 41.06630668257578);
    }

    public static double atan(double arg) {
        double x = arg;
        boolean flipped = false;
        double sign = 1.0;
        if (arg == 0.0) {
            return arg;
        }
        if (arg != arg) {
            return arg;
        }
        if (arg < 0.0) {
            x = -arg;
            sign = -1.0;
        }
        if (x > 1.0) {
            x = 1.0 / x;
            flipped = true;
        }
        double temp = x < tiny ? x : x + x * Math.tancrat(x * x);
        if (flipped) {
            temp = 1.5707963267948966 - temp;
        }
        return sign * temp;
    }

    public static double atan2(double y, double x) {
        if (x != x || y != y) {
            return Double.NaN;
        }
        if (x == 0.0) {
            return y == 0.0 ? Double.NaN : (y > 0.0 ? 1.5707963267948966 : -1.5707963267948966);
        }
        if (y == 0.0) {
            if (x > 0.0) {
                return y;
            }
            long l = Double.doubleToLongBits(Math.PI) | Double.doubleToLongBits(y);
            return Double.longBitsToDouble(l);
        }
        if (Double.isInfinite(y) && Double.isInfinite(x)) {
            return (y > 0.0 ? 1.0 : -1.0) * (x > 0.0 ? 0.7853981633974483 : 2.356194490192345);
        }
        double temp = Math.atan(y / x);
        if (x < 0.0) {
            temp = y < 0.0 ? (temp -= Math.PI) : (temp += Math.PI);
        }
        return temp;
    }

    public static double log(double arg) {
        if (arg < 0.0 || arg != arg) {
            return Double.NaN;
        }
        if (arg < Double.longBitsToDouble(1L)) {
            return Double.NEGATIVE_INFINITY;
        }
        if (arg == Double.POSITIVE_INFINITY) {
            return arg;
        }
        long bits = Double.doubleToLongBits(arg);
        long magbits = bits & 0x7FF0000000000000L;
        int exponent = (int)(bits - 0x3FF0000000000000L >> 52);
        double fraction = Double.longBitsToDouble(bits & 0xFFFFFFFFFFFFFL | 0x3FF0000000000000L);
        double temp = 0.0;
        if (fraction > 1.0) {
            double x = (1.0 + fraction) / (fraction - 1.0);
            double square = 1.0 / (x * x);
            temp = 0.047619047619047616;
            temp = temp * square + 0.05263157894736842;
            temp = temp * square + 0.058823529411764705;
            temp = temp * square + 0.06666666666666667;
            temp = temp * square + 0.07692307692307693;
            temp = temp * square + 0.09090909090909091;
            temp = temp * square + 0.1111111111111111;
            temp = temp * square + 0.14285714285714285;
            temp = temp * square + 0.2;
            temp = temp * square + 0.3333333333333333;
            temp = temp * square + 1.0;
            temp = 2.0 * temp / x;
        }
        return temp + 0.6931471805599453 * (double)exponent;
    }

    public static double exp(double arg) {
        if (arg != arg) {
            return arg;
        }
        if (arg > logbignum) {
            return Double.POSITIVE_INFINITY;
        }
        if (arg == Double.NEGATIVE_INFINITY) {
            return 0.0;
        }
        if (arg > -tiny && arg < tiny) {
            return 1.0;
        }
        int exponent = (int)(arg / 0.6931471805599453 + (arg > 0.0 ? 0.5 : -0.5));
        double difference = arg - (double)exponent * 0.6931471805599453;
        double temp = 1.0 + difference / 12.0;
        temp = 1.0 + difference / 11.0 * temp;
        temp = 1.0 + difference / 10.0 * temp;
        temp = 1.0 + difference / 9.0 * temp;
        temp = 1.0 + difference / 8.0 * temp;
        temp = 1.0 + difference / 7.0 * temp;
        temp = 1.0 + difference / 6.0 * temp;
        temp = 1.0 + difference / 5.0 * temp;
        temp = 1.0 + difference / 4.0 * temp;
        temp = 1.0 + difference / 3.0 * temp;
        temp = 1.0 + difference / 2.0 * temp;
        temp = 1.0 + difference * temp;
        return Double.longBitsToDouble((long)exponent + 1023L << 52) * temp;
    }

    public static double pow(double a, double b) {
        if (b > -tiny && b < tiny) {
            return 1.0;
        }
        if (b == 1.0) {
            return a;
        }
        if (b != b || a != a) {
            return Double.NaN;
        }
        if (Double.isInfinite(b)) {
            if (Math.abs(a) == 1.0) {
                return Double.NaN;
            }
            return Math.abs(a) > 1.0 && b > 0.0 || Math.abs(a) < 1.0 && b < 0.0 ? Double.POSITIVE_INFINITY : 0.0;
        }
        if (Double.isInfinite(a)) {
            if (b > 0.0) {
                return a;
            }
            return 0.0;
        }
        long ia = (long)Math.floor(a);
        long ib = (long)Math.floor(b);
        if ((double)ib == b) {
            long k;
            double temp = 1.0;
            long j = ib < 0L ? -ib : ib;
            for (k = 1L; k <= j; k <<= 1) {
            }
            while (true) {
                if ((k & j) != 0L) {
                    temp *= a;
                }
                if ((k >>= 1) <= 0L) break;
                temp *= temp;
            }
            if (ib < 0L) {
                temp = 1.0 / temp;
            }
            return temp;
        }
        return Math.exp(Math.log(a) * b);
    }

    public static synchronized double random() {
        if (RNG == null) {
            RNG = new Random();
        }
        return RNG.nextDouble();
    }

    public static double toDegrees(double d) {
        if (d == -0.0 || d == 0.0 || d != d || Double.isInfinite(d)) {
            return d;
        }
        d = d * 180.0 / Math.PI;
        return d;
    }

    public static double toRadians(double d) {
        if (d == -0.0 || d == 0.0 || d != d || Double.isInfinite(d)) {
            return d;
        }
        d = d * Math.PI / 180.0;
        return d;
    }

    public static int abs(int arg) {
        return arg < 0 ? -arg : arg;
    }

    public static long abs(long arg) {
        return arg < 0L ? -arg : arg;
    }

    public static float abs(float arg) {
        return Float.intBitsToFloat(Float.floatToIntBits(arg) & Integer.MAX_VALUE);
    }

    public static double abs(double arg) {
        return Double.longBitsToDouble(Double.doubleToLongBits(arg) & Long.MAX_VALUE);
    }

    public static int max(int a, int b) {
        return a > b ? a : b;
    }

    public static long max(long a, long b) {
        return a > b ? a : b;
    }

    public static float max(float a, float b) {
        int abits = Float.floatToIntBits(a);
        int bbits = Float.floatToIntBits(a);
        if (abits == 0 && b <= 0.0f) {
            return a;
        }
        if (bbits == 0 && a <= 0.0f) {
            return b;
        }
        return a > b || a != a ? a : b;
    }

    public static double max(double a, double b) {
        long abits = Double.doubleToLongBits(a);
        long bbits = Double.doubleToLongBits(a);
        if (abits == 0L && b <= 0.0) {
            return a;
        }
        if (bbits == 0L && a <= 0.0) {
            return b;
        }
        return a > b || a != a ? a : b;
    }

    public static int min(int a, int b) {
        return a < b || a != a ? a : b;
    }

    public static long min(long a, long b) {
        return a < b || a != a ? a : b;
    }

    public static float min(float a, float b) {
        int abits = Float.floatToIntBits(a);
        int bbits = Float.floatToIntBits(a);
        if (abits == Integer.MIN_VALUE && b >= 0.0f) {
            return a;
        }
        if (bbits == Integer.MIN_VALUE && a >= 0.0f) {
            return b;
        }
        return a < b || a != a ? a : b;
    }

    public static double min(double a, double b) {
        long abits = Double.doubleToLongBits(a);
        long bbits = Double.doubleToLongBits(a);
        if (abits == Long.MIN_VALUE && b >= 0.0) {
            return a;
        }
        if (bbits == Long.MIN_VALUE && a >= 0.0) {
            return b;
        }
        return a < b || a != a ? a : b;
    }

    public static double floor(double arg) {
        if (Math.abs(arg) > 4.503599627370496E15 || arg != arg || arg == (double)((long)arg)) {
            return arg;
        }
        if (arg < 0.0) {
            return (double)((long)arg) - 1.0;
        }
        return (long)arg;
    }

    public static double ceil(double arg) {
        if (Math.abs(arg) > 4.503599627370496E15 || arg != arg || arg == (double)((long)arg)) {
            return arg;
        }
        if (arg < 0.0) {
            return (arg = (double)((long)arg)) == 0.0 ? -0.0 : arg;
        }
        return (double)((long)arg) + 1.0;
    }

    public static double IEEEremainder(double x, double y) {
        if (Double.isInfinite(y) && !Double.isInfinite(x)) {
            return x;
        }
        return x - y * Math.rint(x / y);
    }

    public static double rint(double arg) {
        double f = Math.floor(arg);
        double c = Math.ceil(arg);
        double n = arg == f ? arg : (arg - f > c - arg ? c : (arg - f < c - arg ? f : (f % 2.0 == 0.0 ? f : c)));
        return n;
    }

    public static int round(float arg) {
        return (int)Math.floor(arg + 0.5f);
    }

    public static long round(double arg) {
        return (long)Math.floor(arg + 0.5);
    }

    static int intValue(String s) throws NumberFormatException {
        int result = 0;
        boolean negative = false;
        int index = 0;
        int length = s.length();
        while (Character.isWhitespace(s.charAt(index))) {
            ++index;
        }
        if (s.charAt(index) == '-') {
            negative = true;
            ++index;
        } else if (s.charAt(index) == '+') {
            ++index;
        }
        return result;
    }

    static float floatValue(String s) throws NumberFormatException {
        String exppart;
        String fractpart;
        String wholepart;
        int length = (s = s.trim()).length();
        if (length == 0) {
            throw new NumberFormatException();
        }
        double result = 0.0;
        boolean negative = false;
        boolean expnegative = false;
        int index = 0;
        try {
            if ("dDfF".indexOf(s.charAt(length - 1)) != -1) {
                --length;
            }
            if (s.charAt(index) == '-') {
                negative = true;
                ++index;
            } else if (s.charAt(index) == '+') {
                ++index;
            }
            int point = s.indexOf(46, index);
            if (point >= 0) {
                int e = s.indexOf(101, point + 1);
                if (e < 0) {
                    e = s.indexOf(69, point + 1);
                }
                wholepart = s.substring(index, point);
                if (e < 0) {
                    fractpart = s.substring(point + 1, length);
                    exppart = "0";
                    expnegative = false;
                } else {
                    fractpart = s.substring(point + 1, e);
                    exppart = s.substring(e + 1, length);
                    if (exppart.charAt(0) == '-') {
                        expnegative = true;
                        exppart = exppart.substring(1);
                    } else if (exppart.charAt(0) == '+') {
                        exppart = exppart.substring(1);
                    }
                }
            } else {
                int e = s.indexOf(101, index);
                if (e < 0) {
                    e = s.indexOf(69, index);
                }
                if (e < 0) {
                    wholepart = s.substring(index, length);
                    fractpart = "";
                    exppart = "0";
                    expnegative = false;
                } else {
                    wholepart = s.substring(index, e);
                    fractpart = "";
                    exppart = s.substring(e + 1, length);
                    if (exppart.charAt(0) == '-') {
                        expnegative = true;
                        exppart = exppart.substring(1);
                    } else if (exppart.charAt(0) == '+') {
                        exppart = exppart.substring(1);
                    }
                }
            }
            if (fractpart.length() > 18) {
                fractpart = fractpart.substring(0, 18);
            }
        }
        catch (IndexOutOfBoundsException ioobe) {
            throw new NumberFormatException();
        }
        if (wholepart.length() == 0 && fractpart.length() == 0) {
            throw new NumberFormatException();
        }
        if (wholepart.length() == 0) {
            wholepart = "0";
        }
        if (fractpart.length() == 0) {
            fractpart = "0";
        }
        if (negative && wholepart.equals("0") && fractpart.equals("0")) {
            return -0.0f;
        }
        result = (double)Long.parseLong(fractpart) / Math.pow(10.0, fractpart.length());
        result += (double)Long.parseLong(wholepart);
        int exponent = Integer.parseInt(exppart);
        if (exponent != 0) {
            result *= Math.pow(10.0, expnegative ? (double)(-exponent) : (double)exponent);
        }
        return (float)(negative ? -result : result);
    }

    static double doubleValue(String s) throws NumberFormatException {
        String exppart;
        String fractpart;
        String wholepart;
        int length = (s = s.trim()).length();
        if (length == 0) {
            throw new NumberFormatException();
        }
        double result = 0.0;
        boolean negative = false;
        boolean expnegative = false;
        int index = 0;
        try {
            if ("dDfF".indexOf(s.charAt(length - 1)) != -1) {
                --length;
            }
            if (s.charAt(index) == '-') {
                negative = true;
                ++index;
            } else if (s.charAt(index) == '+') {
                ++index;
            }
            int point = s.indexOf(46, index);
            if (point >= 0) {
                int e = s.indexOf(101, point + 1);
                if (e < 0) {
                    e = s.indexOf(69, point + 1);
                }
                wholepart = s.substring(index, point);
                if (e < 0) {
                    fractpart = s.substring(point + 1, length);
                    exppart = "0";
                    expnegative = false;
                } else {
                    fractpart = s.substring(point + 1, e);
                    exppart = s.substring(e + 1, length);
                    if (exppart.charAt(0) == '-') {
                        expnegative = true;
                        exppart = exppart.substring(1);
                    } else if (exppart.charAt(0) == '+') {
                        exppart = exppart.substring(1);
                    }
                }
            } else {
                int e = s.indexOf(101, index);
                if (e < 0) {
                    e = s.indexOf(69, index);
                }
                if (e < 0) {
                    wholepart = s.substring(index, length);
                    fractpart = "";
                    exppart = "0";
                    expnegative = false;
                } else {
                    wholepart = s.substring(index, e);
                    fractpart = "";
                    exppart = s.substring(e + 1, length);
                    if (exppart.charAt(0) == '-') {
                        expnegative = true;
                        exppart = exppart.substring(1);
                    } else if (exppart.charAt(0) == '+') {
                        exppart = exppart.substring(1);
                    }
                }
            }
            if (fractpart.length() > 18) {
                fractpart = fractpart.substring(0, 18);
            }
        }
        catch (IndexOutOfBoundsException ioobe) {
            throw new NumberFormatException();
        }
        if (wholepart.length() == 0 && fractpart.length() == 0) {
            throw new NumberFormatException();
        }
        if (wholepart.length() == 0) {
            wholepart = "0";
        }
        if (fractpart.length() == 0) {
            fractpart = "0";
        }
        if (negative && wholepart.equals("0") && fractpart.equals("0")) {
            return -0.0;
        }
        result = Long.parseLong(wholepart);
        result += (double)Long.parseLong(fractpart) / Math.pow(10.0, fractpart.length());
        int exponent = Integer.parseInt(exppart);
        if (exponent != 0) {
            result *= Math.pow(10.0, expnegative ? (double)(-exponent) : (double)exponent);
        }
        return negative ? -result : result;
    }

    static String toString(long arg, int radix) {
        if (arg == 0L) {
            return "0";
        }
        if (radix < 2 || radix > 36) {
            radix = 10;
        }
        char[] buffer = new char[65];
        boolean negative = true;
        int length = 0;
        if (arg > 0L) {
            negative = false;
            arg = -arg;
        }
        while (arg < 0L) {
            buffer[64 - length] = Character.forDigit((int)(-(arg % (long)radix)), radix);
            arg /= (long)radix;
            ++length;
        }
        if (negative) {
            buffer[64 - length] = 45;
            ++length;
        }
        return new String(buffer, 65 - length, length);
    }

    static String toStringUnsigned(int arg, int radix) {
        int mask;
        int shift;
        if (arg >= 0) {
            return Math.toString(arg, radix);
        }
        char[] buffer = new char[32];
        int length = 0;
        switch (radix) {
            case 2: {
                shift = 1;
                mask = 1;
                break;
            }
            case 8: {
                shift = 3;
                mask = 7;
                break;
            }
            default: {
                shift = 4;
                mask = 15;
            }
        }
        while (arg != 0) {
            buffer[31 - length] = Character.forDigit(arg & mask, radix);
            arg >>>= shift;
            ++length;
        }
        return new String(buffer, 32 - length, length);
    }

    static String toStringUnsigned(long arg, int radix) {
        int mask;
        int shift;
        if (arg >= 0L) {
            return Math.toString(arg, radix);
        }
        char[] buffer = new char[64];
        int length = 0;
        switch (radix) {
            case 2: {
                shift = 1;
                mask = 1;
                break;
            }
            case 8: {
                shift = 3;
                mask = 7;
                break;
            }
            default: {
                shift = 4;
                mask = 15;
            }
        }
        while (arg != 0L) {
            buffer[63 - length] = Character.forDigit((int)(arg & (long)mask), radix);
            arg >>>= shift;
            ++length;
        }
        return new String(buffer, 64 - length, length);
    }

    private static String toString_internal(float absvalue) {
        float delta = absvalue - Float.intBitsToFloat(Float.floatToIntBits(absvalue) - 1);
        float residue = absvalue - (float)((int)absvalue);
        StringBuffer buffer = new StringBuffer(32);
        buffer.append((int)absvalue);
        buffer.append('.');
        int dotlength = buffer.length();
        double pow10 = 10.0;
        int nextdigit = (int)((double)residue * pow10);
        buffer.append(Character.forDigit(nextdigit, 10));
        residue = (float)((double)residue - (double)nextdigit / pow10);
        while (residue > delta) {
            nextdigit = (int)((double)residue * (pow10 *= 10.0));
            if (nextdigit < 9 && (double)(nextdigit + 1) / pow10 - (double)residue < (double)delta) {
                ++nextdigit;
            }
            buffer.append(Character.forDigit(nextdigit, 10));
            residue = (float)((double)residue - (double)nextdigit / pow10);
        }
        return buffer.toString();
    }

    static String toString(float arg) {
        float scaled;
        int signbit;
        if (arg != arg) {
            return "NaN";
        }
        int bits = Float.floatToIntBits(arg);
        if (bits == (signbit = bits & Integer.MIN_VALUE)) {
            return signbit == 0 ? "0.0" : "-0.0";
        }
        if (Double.isInfinite(arg)) {
            return signbit == 0 ? "Infinity" : "-Infinity";
        }
        float absvalue = Math.abs(arg);
        if ((double)absvalue >= 0.001 && (double)absvalue < 1.0E7) {
            return (signbit == 0 ? "" : "-") + Math.toString_internal(absvalue);
        }
        long exponent = (long)(((bits & 0x7F800000) >> 23) - 127) * 30103L / 100000L;
        for (scaled = absvalue / (float)Math.pow(10.0, exponent); scaled < 1.0f; scaled *= 10.0f) {
            --exponent;
        }
        while (scaled >= 10.0f) {
            ++exponent;
            scaled *= 0.1f;
        }
        return ((long)signbit == 0L ? "" : "-") + Math.toString_internal(scaled) + "E" + exponent;
    }

    private static String toString_internal(double absvalue) {
        double delta = (absvalue - Double.longBitsToDouble(Double.doubleToLongBits(absvalue) - 1L)) / 2.0;
        double residue = absvalue - (double)((int)absvalue);
        StringBuffer buffer = new StringBuffer(32);
        buffer.append((int)absvalue);
        buffer.append('.');
        int dotlength = buffer.length();
        double pow10 = 10.0;
        int nextdigit = (int)(residue * pow10);
        buffer.append((char)(48 + nextdigit));
        residue -= (double)nextdigit / pow10;
        while (residue > delta) {
            nextdigit = (int)(residue * (pow10 *= 10.0));
            buffer.append((char)(48 + nextdigit));
            residue -= (double)nextdigit / pow10;
        }
        int len = buffer.length();
        if (len > 18) {
            buffer.setLength(18);
            len = 18;
        }
        if (len > 15) {
            char ch = buffer.charAt(--len);
            while (ch == '9') {
                if ((ch = buffer.charAt(--len)) == '9' || ch == '.') continue;
                ch = (char)(ch + '\u0001');
                buffer.setCharAt(len, ch);
                buffer.setLength(len + 1);
            }
        }
        return buffer.toString();
    }

    static String toString(double arg) {
        double scaled;
        long signbit;
        if (arg != arg) {
            return "NaN";
        }
        long bits = Double.doubleToLongBits(arg);
        if (bits == (signbit = bits & Long.MIN_VALUE)) {
            return signbit == 0L ? "0.0" : "-0.0";
        }
        if (Double.isInfinite(arg)) {
            return signbit == 0L ? "Infinity" : "-Infinity";
        }
        double absvalue = Math.abs(arg);
        if (absvalue >= 0.001 && absvalue < 1.0E7) {
            return (signbit == 0L ? "" : "-") + Math.toString_internal(absvalue);
        }
        long exponent = (((bits & 0x7FF0000000000000L) >> 52) - 1023L) * 30103L / 100000L;
        for (scaled = absvalue / Math.pow(10.0, exponent); scaled < 1.0; scaled *= 10.0) {
            --exponent;
        }
        while (scaled >= 10.0) {
            ++exponent;
            scaled *= 0.1;
        }
        return (signbit == 0L ? "" : "-") + Math.toString_internal(scaled) + "E" + exponent;
    }
}

