/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

public final class Double
extends Number
implements Comparable {
    private static final long serialVersionUID = -9172774392245257468L;
    private final double value;
    public static final double MIN_VALUE = 4.9E-324;
    public static final double MAX_VALUE = 1.7976931348623157E308;
    public static final double NEGATIVE_INFINITY = -1.0 / 0.0;
    public static final double POSITIVE_INFINITY = 1.0 / 0.0;
    public static final double NaN = 0.0 / 0.0;
    public static final Class TYPE = Double.getWrappedClass();

    public Double(double value) {
        this.value = value;
    }

    public Double(String s) {
        this(Math.doubleValue(s));
    }

    public byte byteValue() {
        return (byte)this.value;
    }

    public short shortValue() {
        return (short)this.value;
    }

    public int intValue() {
        return (int)this.value;
    }

    public float floatValue() {
        return (float)this.value;
    }

    public long longValue() {
        return (long)this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    public int hashCode() {
        long v = Double.doubleToLongBits(this.value);
        return (int)(v ^ v >>> 32);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        try {
            return Double.doubleToLongBits(((Double)obj).value) == Double.doubleToLongBits(this.value);
        }
        catch (ClassCastException cce) {
            return false;
        }
    }

    public static boolean isNaN(double v) {
        return v != v;
    }

    public boolean isNaN() {
        return this.value != this.value;
    }

    public static native boolean isInfinite(double var0);

    public boolean isInfinite() {
        return Double.isInfinite(this.value);
    }

    public String toString() {
        return Math.toString(this.value);
    }

    public static String toString(double d) {
        return Math.toString(d);
    }

    public static double parseDouble(String s) {
        return Math.doubleValue(s);
    }

    public static Double valueOf(String s) {
        return new Double(Math.doubleValue(s));
    }

    public static long doubleToLongBits(double value) {
        return Double.doubleToRawLongBits(value == value ? value : Double.NaN);
    }

    public static native long doubleToRawLongBits(double var0);

    public static native double longBitsToDouble(long var0);

    public int compareTo(Double anotherDouble) {
        double other_double = anotherDouble.value;
        if (this.value < other_double) {
            return -1;
        }
        if (this.value > other_double) {
            return 1;
        }
        return 0;
    }

    public int compareTo(Object obj) throws ClassCastException {
        return this.compareTo((Double)obj);
    }

    private static native Class getWrappedClass();
}

