/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import wonka.vm.ApplicationClassLoader;
import wonka.vm.Etc;
import wonka.vm.ExtensionClassLoader;
import wonka.vm.SystemClassLoader;

public abstract class ClassLoader {
    private static ClassLoader applicationClassLoader;
    private static ClassLoader extensionClassLoader;
    private static ClassLoader systemClassLoader;
    private static ProtectionDomain defaultProtectionDomain;
    protected Hashtable packages = new Hashtable();
    private HashMap package_sources;
    private Object lock = new Object();
    private ClassLoader parent;
    private String ownname;

    static synchronized ProtectionDomain get_defaultProtectionDomain() {
        return defaultProtectionDomain;
    }

    private static ClassLoader getPertinentClassLoader() {
        ClassLoader loader = applicationClassLoader;
        if (loader == null) {
            loader = systemClassLoader = SystemClassLoader.getInstance();
        }
        return loader;
    }

    private static void permissionCheck(String permission) {
    }

    protected ClassLoader() throws SecurityException {
        this(ClassLoader.getSystemClassLoader());
    }

    protected ClassLoader(ClassLoader parent) throws SecurityException {
        if (ClassLoader.getCallingClassLoader() != null || applicationClassLoader != null) {
            // empty if block
        }
        this.parent = parent == null ? ClassLoader.getSystemClassLoader() : parent;
        this.create();
    }

    private native void create();

    private native boolean checkClassName(String var1);

    protected synchronized Class loadClass(String classname, boolean resolve) throws ClassNotFoundException {
        if (this.ownname == null) {
            this.ownname = this.toString();
        }
        if (!this.checkClassName(classname)) {
            throw new ClassNotFoundException(this + ": Illegal class name: " + classname);
        }
        Class loaded = this._findLoadedClass(classname);
        if (loaded == null) {
            try {
                loaded = this.parent == null ? this.findClass(classname) : this.parent.loadClass(classname, false);
            }
            catch (ClassNotFoundException e) {
                loaded = this.findClass(classname);
            }
        }
        if (resolve) {
            try {
                this.resolveClass(loaded);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
        }
        return loaded;
    }

    public synchronized Class loadClass(String classname) throws ClassNotFoundException {
        return this.loadClass(classname, false);
    }

    protected Class findClass(String classname) throws ClassNotFoundException {
        String message = this.getClass() + " failed to override method findClass(String=" + classname + ") of ClassLoader";
        System.err.println("----------------- Lame ClassLoader Warning --------------");
        System.err.println(message);
        System.err.println("------------------ This sucks!  Fix it !  ---------------");
        throw new ClassNotFoundException(message);
    }

    protected final Class defineClass(String classname, byte[] data, int offset, int length, ProtectionDomain pd) throws NullPointerException, ArrayIndexOutOfBoundsException, ClassFormatError {
        if (offset < 0 || length < 0 || offset + length > data.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (this.ownname == null) {
            this.ownname = this.toString();
        }
        return this._defineClass(classname, data, offset, length, null);
    }

    protected final Class defineClass(String classname, byte[] data, int offset, int length) throws ClassFormatError {
        return this.defineClass(classname, data, offset, length, ClassLoader.get_defaultProtectionDomain());
    }

    private native Class _defineClass(String var1, byte[] var2, int var3, int var4, ProtectionDomain var5) throws ClassFormatError;

    private final Class defineProxyClass(String classname, byte[] data, int offset, int length) throws NullPointerException, ArrayIndexOutOfBoundsException, ClassFormatError {
        ProtectionDomain pd = ClassLoader.get_defaultProtectionDomain();
        Class c = this._defineClass(classname, data, offset, length, pd);
        ClassLoader.setProxyFlag(c);
        return c;
    }

    private static native void setProxyFlag(Class var0);

    protected final native void resolveClass(Class var1) throws NullPointerException;

    protected final Class findSystemClass(String classname) throws ClassNotFoundException {
        ClassLoader loader = ClassLoader.getPertinentClassLoader();
        if (loader == null) {
            throw new ClassNotFoundException("SystemClassLoader not yet defined");
        }
        return loader.findClass(classname);
    }

    protected final Class findLoadedClass(String classname) {
        if (this.ownname == null) {
            this.ownname = this.toString();
        }
        return this._findLoadedClass(classname);
    }

    private native Class _findLoadedClass(String var1);

    protected URL findResource(String resname) {
        return null;
    }

    protected Enumeration findResources(String resname) throws IOException {
        return new Enumeration(){

            public boolean hasMoreElements() {
                return false;
            }

            public Object nextElement() {
                return null;
            }
        };
    }

    public URL getResource(String resname) {
        if (this.ownname == null) {
            this.ownname = this.toString();
        }
        URL loaded = null;
        if (this.parent != null) {
            loaded = this.parent.getResource(resname);
        }
        if (loaded == null) {
            loaded = this.findResource(resname);
        }
        return loaded;
    }

    public final Enumeration getResources(String resname) {
        if (this.ownname == null) {
            this.ownname = this.toString();
        }
        Vector merged = new Vector();
        if (this.parent != null) {
            Enumeration enumeration = this.parent.getResources(resname);
            while (enumeration.hasMoreElements()) {
                merged.addElement(enumeration.nextElement());
            }
            URL ours = this.findResource(resname);
            if (ours != null) {
                merged.addElement(ours);
            }
        }
        return merged.elements();
    }

    public static Enumeration getSystemResources(String resname) {
        ClassLoader loader = ClassLoader.getPertinentClassLoader();
        if (loader == null) {
            return null;
        }
        return loader.getResources(resname);
    }

    protected final void setSigners(Class cl, Object[] signers) {
        cl.signers = signers;
    }

    public static synchronized ClassLoader getSystemClassLoader() {
        ClassLoader caller;
        if (applicationClassLoader != null && (caller = ClassLoader.getCallingClassLoader()) != null && caller != SystemClassLoader.getInstance() && caller != applicationClassLoader) {
            ClassLoader.permissionCheck("getClassLoader");
        }
        return applicationClassLoader;
    }

    public final ClassLoader getParent() {
        ClassLoader caller = ClassLoader.getCallingClassLoader();
        if (!this.isDelegationAncestor(caller)) {
            ClassLoader.permissionCheck("getClassLoader");
        }
        return this.parent;
    }

    static native ClassLoader getCallingClassLoader();

    protected boolean isDelegationAncestor(ClassLoader putative_ancestor) {
        return putative_ancestor == null || putative_ancestor == this || this.parent != null && this.parent.isDelegationAncestor(putative_ancestor);
    }

    public static InputStream getSystemResourceAsStream(String resname) {
        ClassLoader systemClassLoader = ClassLoader.getPertinentClassLoader();
        if (systemClassLoader == null) {
            return null;
        }
        return systemClassLoader.getResourceAsStream(resname);
    }

    public static native byte[] get_system_resource_as_bytes(String var0);

    public InputStream getResourceAsStream(String resname) {
        URL resource = this.getResource(resname);
        if (resource == null) {
            return null;
        }
        try {
            return resource.openStream();
        }
        catch (IOException ioe) {
            return null;
        }
    }

    public static URL getSystemResource(String resname) {
        ClassLoader systemClassLoader = ClassLoader.getPertinentClassLoader();
        if (systemClassLoader == null) {
            return null;
        }
        return systemClassLoader.getResource(resname);
    }

    protected synchronized Package definePackage(String pkgname, String spectitle, String specversion, String specvendor, String impltitle, String implversion, String implvendor, URL sealbase) throws IllegalArgumentException {
        Package p;
        if (this.ownname == null) {
            this.ownname = this.toString();
        }
        if ((p = (Package)this.packages.get(pkgname)) != null) {
            throw new IllegalArgumentException("duplicate package name: " + pkgname);
        }
        p = new Package(pkgname, spectitle, specversion, specvendor, impltitle, implversion, implvendor, sealbase);
        this.packages.put(pkgname, p);
        return p;
    }

    protected Package getPackage(String pkgname) {
        Package p = (Package)this.packages.get(pkgname);
        if (p == null && this.parent != null) {
            p = this.parent.getPackage(pkgname);
        }
        return p;
    }

    protected Package[] getPackages() {
        Package[] ancestorpackages = null;
        Enumeration ownpackages = null;
        int total = 0;
        if (this.parent != null) {
            ancestorpackages = this.parent.getPackages();
            total += ancestorpackages.length;
        }
        if (this.packages != null) {
            ownpackages = this.packages.keys();
            total += this.packages.size();
        }
        Package[] package_array = new Package[total];
        if (ancestorpackages != null) {
            System.arraycopy(ancestorpackages, 0, package_array, 0, ancestorpackages.length);
        }
        if (ownpackages != null) {
            int i = ancestorpackages.length;
            while (ownpackages.hasMoreElements()) {
                package_array[i++] = (Package)ownpackages.nextElement();
            }
        }
        return package_array;
    }

    protected String findLibrary(String libname) {
        return null;
    }

    private static native String getCommandLineClasspath();

    private static void useWonkaJarfiles(String jarfiles) {
        Vector v = new Vector();
        int i = jarfiles.indexOf(58);
        while (i != -1) {
            v.add(jarfiles.substring(0, i));
            jarfiles = jarfiles.substring(i + 1);
            i = jarfiles.indexOf(58);
        }
        v.add(jarfiles);
        int sz = v.size();
        URL[] urls = new URL[sz];
        int j = 0;
        for (i = 0; i < sz; ++i) {
            String urlname = (String)v.get(i);
            urlname = "file:" + urlname;
            try {
                Etc.woempa(7, "useWonkaJarfiles(): url[" + j + "] = " + urlname);
                urls[j++] = new URL(urlname);
                continue;
            }
            catch (MalformedURLException mue) {
                mue.printStackTrace();
            }
        }
        extensionClassLoader = ExtensionClassLoader.getInstance(urls, SystemClassLoader.getInstance());
    }

    private static void useExtDirs(String extdirs) {
        int j;
        File f;
        String dirname;
        Vector v1 = new Vector();
        int i = extdirs.indexOf(58);
        while (i != -1) {
            dirname = extdirs.substring(0, i);
            f = new File(dirname);
            if (f.isDirectory()) {
                v1.add(dirname);
            }
            extdirs = extdirs.substring(i + 1);
            i = extdirs.indexOf(58);
        }
        f = new File(extdirs);
        if (f.isDirectory()) {
            v1.add(extdirs);
        }
        int sz = v1.size();
        Vector v2 = new Vector();
        for (i = 0; i < sz; ++i) {
            dirname = (String)v1.elementAt(i);
            f = new File(dirname);
            String[] jars = f.list();
            int l = jars != null ? jars.length : 0;
            for (j = 0; j < l; ++j) {
                String filename = dirname + File.separator + jars[j];
                if (!filename.endsWith(".jar") && !filename.endsWith(".JAR") && !filename.endsWith(".zip") && !filename.endsWith(".ZIP")) continue;
                v2.add(filename);
            }
            v2.add(dirname);
        }
        sz = v2.size();
        URL[] urls = new URL[sz];
        j = 0;
        for (i = 0; i < sz; ++i) {
            String urlname = (String)v2.get(i);
            urlname = "file:" + urlname;
            try {
                Etc.woempa(7, "useExtDirs(): url[" + j + "] = " + urlname);
                urls[j++] = new URL(urlname);
                continue;
            }
            catch (MalformedURLException mue) {
                mue.printStackTrace();
            }
        }
        extensionClassLoader = ExtensionClassLoader.getInstance(urls, SystemClassLoader.getInstance());
    }

    private static void getApplicationClasspath(String classpath) {
        Vector v = new Vector();
        int i = classpath.indexOf(58);
        while (i != -1) {
            v.add(classpath.substring(0, i));
            classpath = classpath.substring(i + 1);
            i = classpath.indexOf(58);
        }
        v.add(classpath);
        int sz = v.size();
        URL[] urls = new URL[sz];
        int j = 0;
        for (i = 0; i < sz; ++i) {
            String urlname = (String)v.get(i);
            if (urlname.indexOf(58) < 0) {
                if (new File(urlname).isDirectory() && !urlname.endsWith("/")) {
                    urlname = urlname + "/";
                }
                urlname = "file:" + urlname;
            }
            try {
                Etc.woempa(7, "getApplicationClassLoader(): url[" + j + "] = " + urlname);
                urls[j++] = new URL(urlname);
                continue;
            }
            catch (MalformedURLException mue) {
                mue.printStackTrace();
            }
        }
        ClassLoader parent = extensionClassLoader != null ? extensionClassLoader : SystemClassLoader.getInstance();
        applicationClassLoader = ApplicationClassLoader.getInstance(urls, parent);
    }

    static void createApplicationClassLoader() {
        String jarfiles = System.getProperty("com.acunia.wonka.jarfiles");
        String extdirs = System.getProperty("java.ext.dirs.path");
        String classpath = ClassLoader.getCommandLineClasspath();
        if (jarfiles != null && jarfiles.trim().length() != 0) {
            ClassLoader.useWonkaJarfiles(jarfiles);
        } else if (extdirs != null && extdirs.trim().length() != 0) {
            ClassLoader.useExtDirs(extdirs);
        } else {
            extensionClassLoader = null;
        }
        ClassLoader.getApplicationClasspath(classpath);
        Properties props = System.getProperties();
        if (props != null) {
            props.put("java.class.path", classpath);
            if (props.get("java.ext.dirs.path") == null && extdirs != null) {
                System.out.println("My hovercraft is full of eels");
                props.put("java.ext.dirs.path", extdirs);
            }
        }
    }
}

