/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.security.ProtectionDomain;
import java.security.Security;
import wonka.vm.SystemClassLoader;

public final class Class
implements Serializable {
    private static final long serialVersionUID = 3206093459760846163L;
    private final ClassLoader loader = null;
    private final ProtectionDomain domain = null;
    Object[] signers = null;
    private static String restricted_packages;

    private static synchronized String getRestrictedPackages() {
        if (restricted_packages == null && (restricted_packages = Security.getProperty("package.access")) == null) {
            restricted_packages = "com.acunia.wonka";
        }
        return restricted_packages;
    }

    private Class() {
    }

    private synchronized String getPackageName() {
        String classname = this.getName();
        int lastdot = classname.lastIndexOf(46);
        if (lastdot < 0) {
            return "";
        }
        return classname.substring(0, lastdot);
    }

    public static Class forName(String classname) throws ClassNotFoundException {
        Class theClass = null;
        try {
            theClass = Class.forName_S(classname);
        }
        catch (NoClassDefFoundError e) {
            throw new ClassNotFoundException("NoClassDefFoundError " + e.getMessage());
        }
        return theClass;
    }

    public static Class forName(String classname, boolean initialize, ClassLoader loader) throws ClassNotFoundException {
        if (loader != null || ClassLoader.getCallingClassLoader() != null) {
            // empty if block
        }
        Class theClass = null;
        try {
            theClass = Class.forName_SZCL(classname, initialize, loader);
        }
        catch (NoClassDefFoundError e) {
            throw new ClassNotFoundException("NoClassDefFoundError");
        }
        return theClass;
    }

    private static native Class forName_S(String var0) throws ClassNotFoundException;

    private static native Class forName_SZCL(String var0, boolean var1, ClassLoader var2) throws ClassNotFoundException;

    public Object newInstance() throws InstantiationException, IllegalAccessException, NoSuchMethodException {
        if (this.isPrimitive() || this.isArray() || Modifier.isAbstract(this.getModifiers())) {
            throw new InstantiationException();
        }
        this.access_checks(0);
        return this.newInstance0();
    }

    private native Object newInstance0() throws InstantiationException, IllegalAccessException, NoSuchMethodException;

    private native Class getCallingClass();

    public native boolean isInstance(Object var1);

    public native boolean isAssignableFrom(Class var1);

    public native boolean isInterface();

    public native boolean isArray();

    public native boolean isPrimitive();

    public native String getName();

    public ClassLoader getClassLoader() {
        ClassLoader cl = ClassLoader.getCallingClassLoader();
        if (cl == null || !cl.isDelegationAncestor(this.loader)) {
            // empty if block
        }
        return this.loader;
    }

    public native Class getSuperclass();

    public Package getPackage() {
        ClassLoader cl = this.loader == null ? SystemClassLoader.getInstance() : this.loader;
        return cl.getPackage(this.getPackageName());
    }

    public Class getDeclaringClass() {
        throw new UnsupportedOperationException("getDeclaringClass() in Class is not implemented");
    }

    public Class[] getClasses() {
        this.access_checks(0);
        throw new UnsupportedOperationException("getClasses() in Class is not implemented");
    }

    public Class[] getDeclaredClasses() throws SecurityException {
        this.access_checks(1);
        throw new UnsupportedOperationException("getDeclaredClasses() in Class is not implemented");
    }

    public native Class[] getInterfaces();

    public native Class getComponentType();

    public native int getModifiers();

    public Object[] getSigners() {
        return this.signers;
    }

    private native Constructor[] get_constructors(int var1);

    private native Constructor get_one_constructor(Class[] var1, int var2);

    private native Field[] get_fields(int var1);

    private native Field get_one_field(String var1, int var2);

    private native Method[] get_methods(int var1);

    private native Method get_one_method(String var1, Class[] var2, int var3);

    private void access_checks(int check_type) throws SecurityException {
    }

    public Constructor[] getConstructors() throws SecurityException {
        if (this.isPrimitive() || this.isArray()) {
            return new Constructor[0];
        }
        this.access_checks(0);
        return this.get_constructors(0);
    }

    public Constructor[] getDeclaredConstructors() throws SecurityException {
        if (this.isPrimitive() || this.isArray()) {
            return new Constructor[0];
        }
        this.access_checks(1);
        return this.get_constructors(1);
    }

    public Constructor getConstructor(Class[] parameterTypes) throws NoSuchMethodException, SecurityException {
        if (this.isPrimitive() || this.isArray()) {
            throw new NoSuchMethodException();
        }
        this.access_checks(0);
        Class[] pt = parameterTypes == null ? new Class[]{} : parameterTypes;
        return this.get_one_constructor(pt, 0);
    }

    public Constructor getDeclaredConstructor(Class[] parameterTypes) throws NoSuchMethodException, SecurityException {
        if (this.isPrimitive() || this.isArray()) {
            throw new NoSuchMethodException();
        }
        this.access_checks(1);
        Class[] pt = parameterTypes == null ? new Class[]{} : parameterTypes;
        return this.get_one_constructor(pt, 1);
    }

    public Field[] getFields() throws SecurityException {
        if (this.isPrimitive() || this.isArray()) {
            return new Field[0];
        }
        this.access_checks(0);
        return this.get_fields(0);
    }

    public Field[] getDeclaredFields() throws SecurityException {
        if (this.isPrimitive() || this.isArray()) {
            return new Field[0];
        }
        this.access_checks(1);
        return this.get_fields(1);
    }

    public Field getField(String fieldname) throws SecurityException, NoSuchFieldException {
        if (this.isPrimitive() || this.isArray()) {
            throw new NoSuchFieldException();
        }
        this.access_checks(0);
        return this.get_one_field(fieldname, 0);
    }

    public Field getDeclaredField(String fieldname) throws SecurityException, NoSuchFieldException {
        if (this.isPrimitive() || this.isArray()) {
            throw new NoSuchFieldException("class " + this + " is a" + (this.isPrimitive() ? " primitive" : "n array") + " class");
        }
        this.access_checks(1);
        return this.get_one_field(fieldname, 1);
    }

    public Method[] getMethods() throws SecurityException {
        if (this.isPrimitive() || this.isArray()) {
            return new Method[0];
        }
        this.access_checks(0);
        return this.get_methods(0);
    }

    public Method[] getDeclaredMethods() throws SecurityException {
        if (this.isPrimitive() || this.isArray()) {
            return new Method[0];
        }
        this.access_checks(1);
        return this.get_methods(1);
    }

    public Method getMethod(String methodname, Class[] parameterTypes) throws SecurityException, NoSuchMethodException {
        if (this.isPrimitive() || this.isArray() || methodname == null || methodname.equals("<init>") || methodname.equals("<clinit>")) {
            throw new NoSuchMethodException();
        }
        this.access_checks(0);
        Class[] pt = parameterTypes == null ? new Class[]{} : parameterTypes;
        return this.get_one_method(methodname, pt, 0);
    }

    public Method getDeclaredMethod(String methodname, Class[] parameterTypes) throws SecurityException, NoSuchMethodException {
        this.access_checks(1);
        Class[] pt = parameterTypes == null ? new Class[]{} : parameterTypes;
        return this.get_one_method(methodname, pt, 1);
    }

    public URL getResource(String name) {
        ClassLoader cl = this.getClassLoader();
        String slashed = name;
        if (!slashed.startsWith("/")) {
            String packagename = this.getPackageName();
            if (packagename != "") {
                slashed = this.getPackageName().replace('.', '/') + "/" + name;
            }
        } else {
            slashed = slashed.substring(1);
        }
        if (cl == null) {
            return ClassLoader.getSystemResource(slashed);
        }
        return cl.getResource(slashed);
    }

    public InputStream getResourceAsStream(String name) {
        ClassLoader cl = this.getClassLoader();
        String slashed = name;
        if (!slashed.startsWith("/")) {
            String packagename = this.getPackageName();
            if (packagename != "") {
                slashed = this.getPackageName().replace('.', '/') + "/" + name;
            }
        } else {
            slashed = slashed.substring(1);
        }
        if (cl == null) {
            return ClassLoader.getSystemResourceAsStream(slashed);
        }
        return cl.getResourceAsStream(slashed);
    }

    public ProtectionDomain getProtectionDomain() {
        return this.domain;
    }

    public String toString() {
        String name = this.getName();
        if (this.isPrimitive()) {
            return name;
        }
        if (this.isInterface()) {
            return "interface " + name;
        }
        return "class " + name;
    }
}

