/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.Serializable;

public final class Character
implements Serializable,
Comparable {
    private static final long serialVersionUID = 3786198910865385080L;
    public static final char MIN_VALUE = '\u0000';
    public static final char MAX_VALUE = '\uffff';
    public static final int MIN_RADIX = 2;
    public static final int MAX_RADIX = 36;
    public static final Class TYPE = Character.getWrappedClass();
    public static final byte SPACE_SEPARATOR = 12;
    public static final byte LINE_SEPARATOR = 13;
    public static final byte PARAGRAPH_SEPARATOR = 14;
    public static final byte UPPERCASE_LETTER = 1;
    public static final byte LOWERCASE_LETTER = 2;
    public static final byte TITLECASE_LETTER = 3;
    public static final byte MODIFIER_LETTER = 4;
    public static final byte OTHER_LETTER = 5;
    public static final byte DECIMAL_DIGIT_NUMBER = 9;
    public static final byte LETTER_NUMBER = 10;
    public static final byte OTHER_NUMBER = 11;
    public static final byte NON_SPACING_MARK = 6;
    public static final byte ENCLOSING_MARK = 7;
    public static final byte COMBINING_SPACING_MARK = 8;
    public static final byte DASH_PUNCTUATION = 20;
    public static final byte START_PUNCTUATION = 21;
    public static final byte END_PUNCTUATION = 22;
    public static final byte CONNECTOR_PUNCTUATION = 23;
    public static final byte OTHER_PUNCTUATION = 24;
    public static final byte MATH_SYMBOL = 25;
    public static final byte CURRENCY_SYMBOL = 26;
    public static final byte MODIFIER_SYMBOL = 27;
    public static final byte OTHER_SYMBOL = 28;
    public static final byte CONTROL = 15;
    public static final byte FORMAT = 16;
    public static final byte UNASSIGNED = 0;
    public static final byte PRIVATE_USE = 18;
    public static final byte SURROGATE = 19;
    private final char value;

    private static native void createTables();

    public Character(char value) {
        this.value = value;
    }

    public String toString() {
        char[] onechar = new char[]{this.value};
        return new String(onechar);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        try {
            Character c = (Character)obj;
            return this.value == c.value;
        }
        catch (ClassCastException cce) {
            return false;
        }
    }

    public int hashCode() {
        return this.value;
    }

    public char charValue() {
        return this.value;
    }

    public int compareTo(Character anotherCharacter) {
        char other_value = anotherCharacter.value;
        if (this.value > other_value) {
            return 1;
        }
        if (this.value < other_value) {
            return -1;
        }
        return 0;
    }

    public int compareTo(Object something) throws ClassCastException {
        return this.compareTo((Character)something);
    }

    public static native boolean isDefined(char var0);

    public static native boolean isLowerCase(char var0);

    public static native boolean isUpperCase(char var0);

    public static native boolean isTitleCase(char var0);

    public static native boolean isLetter(char var0);

    public static native boolean isDigit(char var0);

    public static native boolean isWhitespace(char var0);

    public static boolean isLetterOrDigit(char ch) {
        return Character.isLetter(ch) || Character.isDigit(ch);
    }

    public static boolean isJavaLetter(char ch) {
        return ch == '$' || ch == '_' || Character.isLetter(ch);
    }

    public static boolean isJavaLetterOrDigit(char ch) {
        return ch == '$' || ch == '_' || Character.isLetterOrDigit(ch);
    }

    public static boolean isSpace(char ch) {
        return ch == '\n' || ch == '\t' || ch == '\f' || ch == '\r' || ch == ' ';
    }

    private static native boolean isFormat(char var0);

    public static native char toLowerCase(char var0);

    public static native char toUpperCase(char var0);

    public static native char toTitleCase(char var0);

    private static native int digitValue(char var0);

    private static native int numericValue(char var0);

    public static int digit(char ch, int radix) {
        if (radix < 2 || radix > 36) {
            return -1;
        }
        if (Character.isDigit(ch)) {
            int dv = Character.digitValue(ch);
            return dv < radix ? dv : -1;
        }
        if (ch >= 'A' && ch <= 'Z' && ch < 65 + radix - 10) {
            return ch - 65 + 10;
        }
        if (ch >= 'a' && ch <= 'z' && ch < 97 + radix - 10) {
            return ch - 97 + 10;
        }
        return -1;
    }

    public static int getNumericValue(char ch) {
        int result = Character.digit(ch, 36);
        if (result == -1) {
            result = Character.numericValue(ch);
        }
        return result;
    }

    public static boolean isIdentifierIgnorable(char ch) {
        return ch < ' ' && !Character.isWhitespace(ch) || ch > '~' && ch < '\u00a0' || Character.isFormat(ch);
    }

    public static boolean isJavaIdentifierPart(char ch) {
        if (Character.isLetterOrDigit(ch)) {
            return true;
        }
        int type = Character.getType(ch);
        return type == 26 || type == 23 || type == 10 || type == 8 || type == 6 || Character.isIdentifierIgnorable(ch);
    }

    public static boolean isJavaIdentifierStart(char ch) {
        if (Character.isLetter(ch)) {
            return true;
        }
        int type = Character.getType(ch);
        return type == 26 || type == 10 || type == 23;
    }

    public static boolean isUnicodeIdentifierPart(char ch) {
        if (Character.isLetterOrDigit(ch)) {
            return true;
        }
        int type = Character.getType(ch);
        return type == 23 || type == 10 || type == 8 || type == 6 || Character.isIdentifierIgnorable(ch);
    }

    public static boolean isUnicodeIdentifierStart(char ch) {
        return Character.isLetter(ch) || Character.getType(ch) == 10;
    }

    public static boolean isSpaceChar(char ch) {
        int type = Character.getType(ch);
        return type == 12 || type == 13 || type == 14;
    }

    public static boolean isISOControl(char ch) {
        return ch <= '\u001f' || ch >= '\u007f' && ch <= '\u009f';
    }

    public static int getType(char ch) {
        String cat = Character.getCategory(ch);
        char cat0 = cat.charAt(0);
        char cat1 = cat.charAt(1);
        switch (cat0) {
            case 'C': {
                switch (cat1) {
                    case 'c': {
                        return 15;
                    }
                    case 'f': {
                        return 16;
                    }
                    case 'n': {
                        return 0;
                    }
                    case 'o': {
                        return 18;
                    }
                    case 's': {
                        return 19;
                    }
                }
            }
            case 'L': {
                switch (cat1) {
                    case 'l': {
                        return 2;
                    }
                    case 'm': {
                        return 4;
                    }
                    case 'o': {
                        return 5;
                    }
                    case 't': {
                        return 3;
                    }
                    case 'u': {
                        return 1;
                    }
                }
            }
            case 'M': {
                switch (cat1) {
                    case 'c': {
                        return 8;
                    }
                    case 'e': {
                        return 7;
                    }
                    case 'n': {
                        return 6;
                    }
                }
            }
            case 'N': {
                switch (cat1) {
                    case 'd': {
                        return 9;
                    }
                    case 'l': {
                        return 10;
                    }
                    case 'o': {
                        return 11;
                    }
                }
            }
            case 'P': {
                switch (cat1) {
                    case 'c': {
                        return 23;
                    }
                    case 'd': {
                        return 20;
                    }
                    case 'e': 
                    case 'f': {
                        return 22;
                    }
                    case 'o': {
                        return 24;
                    }
                    case 'i': 
                    case 's': {
                        return 21;
                    }
                }
            }
            case 'S': {
                switch (cat1) {
                    case 'c': {
                        return 26;
                    }
                    case 'k': {
                        return 27;
                    }
                    case 'm': {
                        return 25;
                    }
                    case 'o': {
                        return 28;
                    }
                }
            }
            case 'Z': {
                switch (cat1) {
                    case 'l': {
                        return 13;
                    }
                    case 'p': {
                        return 14;
                    }
                    case 's': {
                        return 12;
                    }
                }
            }
        }
        return 0;
    }

    public static char forDigit(int digit, int radix) {
        if (radix < 2 || radix > 36) {
            return '\u0000';
        }
        if (digit < 0 || digit >= radix) {
            return '\u0000';
        }
        if (digit < 10) {
            return (char)(digit + 48);
        }
        return (char)(digit + 97 - 10);
    }

    private static native Class getWrappedClass();

    private static native String getCategory(char var0);

    static {
        Character.createTables();
    }

    public static final class UnicodeBlock
    extends Subset {
        public static final UnicodeBlock ALPHABETIC_PRESENTATION_FORMS = new UnicodeBlock("ALPHABETIC_PRESENTATION_FORMS");
        public static final UnicodeBlock ARABIC = new UnicodeBlock("ARABIC");
        public static final UnicodeBlock ARABIC_PRESENTATION_FORMS_A = new UnicodeBlock("ARABIC_PRESENTATION_FORMS_A");
        public static final UnicodeBlock ARABIC_PRESENTATION_FORMS_B = new UnicodeBlock("ARABIC_PRESENTATION_FORMS_B");
        public static final UnicodeBlock ARMENIAN = new UnicodeBlock("ARMENIAN");
        public static final UnicodeBlock ARROWS = new UnicodeBlock("ARROWS");
        public static final UnicodeBlock BASIC_LATIN = new UnicodeBlock("BASIC_LATIN");
        public static final UnicodeBlock BENGALI = new UnicodeBlock("BENGALI");
        public static final UnicodeBlock BLOCK_ELEMENTS = new UnicodeBlock("BLOCK_ELEMENTS");
        public static final UnicodeBlock BOPOMOFO = new UnicodeBlock("BOPOMOFO");
        public static final UnicodeBlock BOX_DRAWING = new UnicodeBlock("BOX_DRAWING");
        public static final UnicodeBlock CJK_COMPATIBILITY = new UnicodeBlock("CJK_COMPATIBILITY");
        public static final UnicodeBlock CJK_COMPATIBILITY_FORMS = new UnicodeBlock("CJK_COMPATIBILITY_FORMS");
        public static final UnicodeBlock CJK_COMPATIBILITY_IDEOGRAPHS = new UnicodeBlock("CJK_COMPATIBILITY_IDEOGRAPHS");
        public static final UnicodeBlock CJK_SYMBOLS_AND_PUNCTUATION = new UnicodeBlock("CJK_SYMBOLS_AND_PUNCTUATION");
        public static final UnicodeBlock CJK_UNIFIED_IDEOGRAPHS = new UnicodeBlock("CJK_UNIFIED_IDEOGRAPHS");
        public static final UnicodeBlock COMBINING_DIACRITICAL_MARKS = new UnicodeBlock("COMBINING_DIACRITICAL_MARKS");
        public static final UnicodeBlock COMBINING_HALF_MARKS = new UnicodeBlock("COMBINING_HALF_MARKS");
        public static final UnicodeBlock COMBINING_MARKS_FOR_SYMBOLS = new UnicodeBlock("COMBINING_MARKS_FOR_SYMBOLS");
        public static final UnicodeBlock CONTROL_PICTURES = new UnicodeBlock("CONTROL_PICTURES");
        public static final UnicodeBlock CURRENCY_SYMBOLS = new UnicodeBlock("CURRENCY_SYMBOLS");
        public static final UnicodeBlock CYRILLIC = new UnicodeBlock("CYRILLIC");
        public static final UnicodeBlock DEVANAGARI = new UnicodeBlock("DEVANAGARI");
        public static final UnicodeBlock DINGBATS = new UnicodeBlock("DINGBATS");
        public static final UnicodeBlock ENCLOSED_ALPHANUMERICS = new UnicodeBlock("ENCLOSED_ALPHANUMERICS");
        public static final UnicodeBlock ENCLOSED_CJK_LETTERS_AND_MONTHS = new UnicodeBlock("ENCLOSED_CJK_LETTERS_AND_MONTHS");
        public static final UnicodeBlock GENERAL_PUNCTUATION = new UnicodeBlock("GENERAL_PUNCTUATION");
        public static final UnicodeBlock GEOMETRIC_SHAPES = new UnicodeBlock("GEOMETRIC_SHAPES");
        public static final UnicodeBlock GEORGIAN = new UnicodeBlock("GEORGIAN");
        public static final UnicodeBlock GREEK = new UnicodeBlock("GREEK");
        public static final UnicodeBlock GREEK_EXTENDED = new UnicodeBlock("GREEK_EXTENDED");
        public static final UnicodeBlock GUJARATI = new UnicodeBlock("GUJARATI");
        public static final UnicodeBlock GURMUKHI = new UnicodeBlock("GURMUKHI");
        public static final UnicodeBlock HALFWIDTH_AND_FULLWIDTH_FORMS = new UnicodeBlock("HALFWIDTH_AND_FULLWIDTH_FORMS");
        public static final UnicodeBlock HANGUL_COMPATIBILITY_JAMO = new UnicodeBlock("HANGUL_COMPATIBILITY_JAMO");
        public static final UnicodeBlock HANGUL_JAMO = new UnicodeBlock("HANGUL_JAMO");
        public static final UnicodeBlock HANGUL_SYLLABLES = new UnicodeBlock("HANGUL_SYLLABLES");
        public static final UnicodeBlock HEBREW = new UnicodeBlock("HEBREW");
        public static final UnicodeBlock HIRAGANA = new UnicodeBlock("HIRAGANA");
        public static final UnicodeBlock IPA_EXTENSIONS = new UnicodeBlock("IPA_EXTENSIONS");
        public static final UnicodeBlock KANBUN = new UnicodeBlock("KANBUN");
        public static final UnicodeBlock KANNADA = new UnicodeBlock("KANNADA");
        public static final UnicodeBlock KATAKANA = new UnicodeBlock("KATAKANA");
        public static final UnicodeBlock LAO = new UnicodeBlock("LAO");
        public static final UnicodeBlock LATIN_1_SUPPLEMENT = new UnicodeBlock("LATIN_1_SUPPLEMENT");
        public static final UnicodeBlock LATIN_EXTENDED_A = new UnicodeBlock("LATIN_EXTENDED_A");
        public static final UnicodeBlock LATIN_EXTENDED_ADDITIONAL = new UnicodeBlock("LATIN_EXTENDED_ADDITIONAL");
        public static final UnicodeBlock LATIN_EXTENDED_B = new UnicodeBlock("LATIN_EXTENDED_B");
        public static final UnicodeBlock LETTERLIKE_SYMBOLS = new UnicodeBlock("LETTERLIKE_SYMBOLS");
        public static final UnicodeBlock MALAYALAM = new UnicodeBlock("MALAYALAM");
        public static final UnicodeBlock MATHEMATICAL_OPERATORS = new UnicodeBlock("MATHEMATICAL_OPERATORS");
        public static final UnicodeBlock MISCELLANEOUS_SYMBOLS = new UnicodeBlock("MISCELLANEOUS_SYMBOLS");
        public static final UnicodeBlock MISCELLANEOUS_TECHNICAL = new UnicodeBlock("MISCELLANEOUS_TECHNICAL");
        public static final UnicodeBlock NUMBER_FORMS = new UnicodeBlock("NUMBER_FORMS");
        public static final UnicodeBlock OPTICAL_CHARACTER_RECOGNITION = new UnicodeBlock("OPTICAL_CHARACTER_RECOGNITION");
        public static final UnicodeBlock ORIYA = new UnicodeBlock("ORIYA");
        public static final UnicodeBlock PRIVATE_USE_AREA = new UnicodeBlock("PRIVATE_USE_AREA");
        public static final UnicodeBlock SMALL_FORM_VARIANTS = new UnicodeBlock("SMALL_FORM_VARIANTS");
        public static final UnicodeBlock SPACING_MODIFIER_LETTERS = new UnicodeBlock("SPACING_MODIFIER_LETTERS");
        public static final UnicodeBlock SPECIALS = new UnicodeBlock("SPECIALS");
        public static final UnicodeBlock SUPERSCRIPTS_AND_SUBSCRIPTS = new UnicodeBlock("SUPERSCRIPTS_AND_SUBSCRIPTS");
        public static final UnicodeBlock SURROGATES_AREA = new UnicodeBlock("SURROGATES_AREA");
        public static final UnicodeBlock TAMIL = new UnicodeBlock("TAMIL");
        public static final UnicodeBlock TELUGU = new UnicodeBlock("TELUGU");
        public static final UnicodeBlock THAI = new UnicodeBlock("THAI");
        public static final UnicodeBlock TIBETAN = new UnicodeBlock("TIBETAN");

        public static UnicodeBlock of(char c) {
            return null;
        }

        private UnicodeBlock(String name) {
            super(name);
        }
    }

    public static class Subset {
        private String name;

        protected Subset(String str) {
            this.name = str;
        }

        public final boolean equals(Object o) {
            return this == o;
        }

        public final int hashCode() {
            return super.hashCode();
        }

        public final String toString() {
            return super.toString();
        }
    }
}

