/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;

public abstract class Writer {
    protected Object lock;

    protected Writer() {
        this.lock = this;
    }

    protected Writer(Object lock) {
        if (lock == null) {
            throw new NullPointerException("lock should be non null");
        }
        this.lock = lock;
    }

    public abstract void close() throws IOException;

    public abstract void flush() throws IOException;

    public abstract void write(char[] var1, int var2, int var3) throws IOException;

    public void write(char[] buf) throws IOException {
        this.write(buf, 0, buf.length);
    }

    public void write(int c) throws IOException {
        char[] buf = new char[]{(char)c};
        this.write(buf, 0, 1);
    }

    public void write(String string) throws IOException {
        this.write(string, 0, string.length());
    }

    public void write(String string, int off, int len) throws IOException {
        if (len < 0) {
            throw new IndexOutOfBoundsException();
        }
        char[] buf = new char[len];
        string.getChars(off, off + len, buf, 0);
        this.write(buf, 0, len);
    }
}

