/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;

public abstract class Reader {
    protected Object lock;

    protected Reader() {
        this.lock = this;
    }

    protected Reader(Object lock) {
        if (lock == null) {
            throw new NullPointerException();
        }
        this.lock = lock;
    }

    public abstract void close() throws IOException;

    public abstract int read(char[] var1, int var2, int var3) throws IOException;

    public void mark(int readLimit) throws IOException {
        throw new IOException("mark is not supported by " + this.getClass().getName());
    }

    public boolean markSupported() {
        return false;
    }

    public int read() throws IOException {
        char[] chars = new char[1];
        int rd = this.read(chars, 0, 1);
        if (rd < 1) {
            return -1;
        }
        return chars[0];
    }

    public int read(char[] chars) throws IOException {
        return this.read(chars, 0, chars.length);
    }

    public boolean ready() throws IOException {
        return false;
    }

    public void reset() throws IOException {
        throw new IOException("reset is not supported by " + this.getClass().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long skip(long skip) throws IOException {
        if (skip < 0L) {
            throw new IllegalArgumentException("cannot skip " + skip + " (value must be 0 or greater)");
        }
        Object object = this.lock;
        synchronized (object) {
            int rd;
            char[] chars = new char[128];
            long remain = skip;
            while ((rd = this.read(chars, 0, 128L > remain ? (int)remain : 128)) != -1 && (remain -= (long)rd) > 0L) {
            }
            return skip - remain;
        }
    }
}

