/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PipedInputStream;

public class PipedOutputStream
extends OutputStream {
    PipedInputStream dst;

    public void connect(PipedInputStream dst) throws IOException {
        if (this.dst != null || dst.src != null) {
            throw new IOException("allready connected");
        }
        this.dst = dst;
        dst.src = this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void flush() throws IOException {
        PipedInputStream dst = this.dst;
        if (dst == null) return;
        PipedInputStream pipedInputStream = dst;
        synchronized (pipedInputStream) {
            dst.readable = dst.buffer.length - dst.storable;
            dst.notifyAll();
            return;
        }
    }

    public void close() throws IOException {
        if (this.dst != null && !this.dst.producerclosed) {
            this.flush();
            this.dst.producerclosed = true;
        }
    }

    public void write(byte[] buffer, int offset, int count) throws IOException {
        if (this.dst == null) {
            throw new IOException("unconnected");
        }
        if (count < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.dst.receive(buffer, offset, count);
    }

    public void write(int oneByte) throws IOException {
        if (this.dst == null) {
            throw new IOException("unconnected");
        }
        this.dst.receive(oneByte);
    }

    public PipedOutputStream(PipedInputStream dst) throws IOException {
        this.connect(dst);
    }

    public PipedOutputStream() {
    }
}

