/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.GetSystemProperty;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import wonka.decoders.Decoder;

public class OutputStreamWriter
extends Writer {
    private static final String default_encoding = GetSystemProperty.FILE_ENCODING;
    private OutputStream out;
    private Decoder decoder;
    private StringBuffer buffer;

    public OutputStreamWriter(OutputStream out) {
        super(out);
        this.decoder = Decoder.getDefault(default_encoding);
        this.buffer = new StringBuffer(1024);
        this.out = out;
    }

    public OutputStreamWriter(OutputStream out, String enc) throws UnsupportedEncodingException {
        super(out);
        this.decoder = Decoder.get(enc);
        this.buffer = new StringBuffer(1024);
        this.out = out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.out != null) {
                this.out.write(this.decoder.cToB(this.buffer));
                this.out.close();
                this.buffer = null;
                this.out = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.out == null) {
                throw new IOException("Reader is closed");
            }
            this.out.write(this.decoder.cToB(this.buffer));
            this.buffer.setLength(0);
            this.out.flush();
        }
    }

    public String getEncoding() {
        return this.decoder.getEncoding();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int ch) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.out == null) {
                throw new IOException("Reader is closed");
            }
            this.buffer.append((char)ch);
            if (this.buffer.length() > 1024) {
                this.out.write(this.decoder.cToB(this.buffer));
                this.buffer.setLength(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(char[] chars, int off, int len) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.out == null) {
                throw new IOException("Reader is closed");
            }
            this.buffer.append(chars, off, len);
            if (this.buffer.length() > 1024) {
                this.out.write(this.decoder.cToB(this.buffer));
                this.buffer.setLength(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String str, int off, int len) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.out == null) {
                throw new IOException("Reader is closed");
            }
            this.buffer.append(str.substring(off, len));
            if (this.buffer.length() > 1024) {
                this.out.write(this.decoder.cToB(this.buffer));
                this.buffer.setLength(0);
            }
        }
    }
}

