/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import com.acunia.wonka.security.FilePermissionCollection;
import java.io.File;
import java.security.Permission;
import java.security.PermissionCollection;

public final class FilePermission
extends Permission {
    private static final long serialVersionUID = 7930732926638008763L;
    private static final String CURRENTDIR = new File("").getAbsolutePath();
    private String actions;
    private boolean read;
    private boolean write;
    private boolean execute;
    private boolean delete;
    static final String SEP = File.separator;
    static final String SEP_STAR = SEP + "*";
    static final String SEP_DASH = SEP + "-";
    private static final int SEPLENGTH = SEP.length();
    private static final char SEP_CHAR = SEP.charAt(0);

    private void parseActions(String s) {
        String sx = s.toLowerCase();
        while (sx != "") {
            String s0;
            int i = sx.indexOf(44);
            if (i < 0) {
                s0 = sx.trim();
                sx = "";
            } else {
                s0 = sx.substring(0, i).trim();
                sx = sx.substring(i + 1);
            }
            if (s0.equals("read")) {
                this.read = true;
                continue;
            }
            if (s0.equals("write")) {
                this.write = true;
                continue;
            }
            if (s0.equals("execute")) {
                this.execute = true;
                continue;
            }
            if (s0.equals("delete")) {
                this.delete = true;
                continue;
            }
            throw new IllegalArgumentException(s0 + " is no valid action");
        }
        StringBuffer buf = new StringBuffer(26);
        if (this.read) {
            buf.append("read,");
        }
        if (this.write) {
            buf.append("write,");
        }
        if (this.execute) {
            buf.append("execute,");
        }
        if (this.delete) {
            buf.append("delete,");
        }
        if (!(this.execute || this.delete || this.read || this.write)) {
            throw new IllegalArgumentException("no actions specified");
        }
        this.actions = buf.substring(0, buf.length() - 1);
    }

    private static String toAbsolutePath(String path) {
        if (path.startsWith(SEP)) {
            return path;
        }
        if (path.startsWith(".")) {
            int i;
            String newPath = CURRENTDIR;
            int dotCount = 1;
            int path_length = path.length();
            for (i = 1; i < path_length; ++i) {
                char ch = path.charAt(i);
                if (ch != '.') {
                    int slash;
                    if (path.indexOf(SEP, i) != i) break;
                    if (dotCount == 2 && (slash = newPath.lastIndexOf(SEP, newPath.length())) >= SEPLENGTH) {
                        newPath = newPath.substring(0, slash + SEPLENGTH);
                    }
                    i += SEPLENGTH - 1;
                    continue;
                }
                if (dotCount > 1) {
                    i -= dotCount;
                    break;
                }
                ++dotCount;
            }
            if (newPath == CURRENTDIR) {
                return path.substring(i);
            }
            return newPath + path.substring(i);
        }
        return path;
    }

    public FilePermission(String path, String actions) {
        super(FilePermission.toAbsolutePath(path));
        this.parseActions(actions);
    }

    public boolean implies(Permission p) {
        if (!(p instanceof FilePermission)) {
            return false;
        }
        FilePermission fp = (FilePermission)p;
        if (fp.read && !this.read || fp.write && !this.write || fp.execute && !this.execute || fp.delete && !this.delete) {
            return false;
        }
        String thisname = super.getName();
        String othername = p.getName();
        if (thisname == "<<ALL FILES>>") {
            return true;
        }
        if (thisname.endsWith(SEP_DASH)) {
            int l = thisname.length() - 1;
            boolean b = othername.startsWith(thisname.substring(0, l));
            return b &= othername.length() != l;
        }
        if (thisname.endsWith(SEP_STAR)) {
            int i = thisname.lastIndexOf(SEP_CHAR) + 1;
            int pos = othername.indexOf(SEP_CHAR, i + 1);
            int l = othername.length();
            return othername.startsWith(thisname.substring(0, i)) && (pos < 0 || pos == l - 1) && l != i;
        }
        return othername.equals(thisname);
    }

    public boolean equals(Object o) {
        if (!(o instanceof FilePermission)) {
            return false;
        }
        FilePermission fp = (FilePermission)o;
        if (fp.read != this.read || fp.write != this.write || fp.execute != this.execute || fp.delete != this.delete) {
            return false;
        }
        return fp.getName().equals(super.getName());
    }

    public int hashCode() {
        int h = super.getName().hashCode();
        if (this.read) {
            h ^= 0x80402010;
        }
        if (this.write) {
            h ^= 0x20408010;
        }
        if (this.execute) {
            h ^= 0x80102040;
        }
        if (this.delete) {
            h ^= 0x8040201;
        }
        return h;
    }

    public String getActions() {
        return this.actions;
    }

    public PermissionCollection newPermissionCollection() {
        return new FilePermissionCollection();
    }
}

