/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.DataInput;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UTFDataFormatException;
import wonka.vm.ArrayUtil;

public class DataInputStream
extends FilterInputStream
implements DataInput {
    private boolean lastWasReturn = false;
    private byte[] buffer = new byte[8];

    public DataInputStream(InputStream input) {
        super(input);
    }

    public final int read(byte[] bytes) throws IOException {
        return this.read(bytes, 0, bytes.length);
    }

    public final int read(byte[] bytes, int offset, int length) throws IOException {
        if (this.lastWasReturn) {
            int rd = this.in.read();
            if (rd == -1) {
                return -1;
            }
            if (rd == 10) {
                return this.in.read(bytes, offset, length);
            }
            bytes[offset++] = (byte)rd;
            if (this.in.available() > 0) {
                return this.in.read(bytes, offset, length - 1);
            }
            return 1;
        }
        return this.in.read(bytes, offset, length);
    }

    public final void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    public final void readFully(byte[] b, int off, int len) throws IOException {
        int read;
        if (off < 0 || len < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException();
        }
        for (int done = 0; done < len; done += read) {
            read = this.in.read(b, off + done, len - done);
            if (read >= 0) continue;
            throw new EOFException();
        }
    }

    public final int skipBytes(int n) throws IOException {
        int done;
        int skipped;
        for (done = 0; done < n; done += skipped) {
            skipped = (int)this.in.skip(n - done);
            if (skipped != 0) continue;
            throw new EOFException();
        }
        return done;
    }

    public final boolean readBoolean() throws IOException {
        int next = this.in.read();
        if (next == -1) {
            throw new EOFException();
        }
        return next > 0;
    }

    public final byte readByte() throws IOException {
        int next = this.in.read();
        if (next == -1) {
            throw new EOFException();
        }
        return (byte)next;
    }

    public final int readUnsignedByte() throws IOException {
        int next = this.in.read();
        if (next == -1) {
            throw new EOFException();
        }
        return next;
    }

    public final short readShort() throws IOException {
        return (short)this.readUnsignedShort();
    }

    public final int readUnsignedShort() throws IOException {
        int read = this.in.read(this.buffer, 0, 2);
        if (read == 1) {
            read = this.in.read(this.buffer, 1, 1);
        }
        if (read == -1) {
            throw new EOFException();
        }
        return (this.buffer[0] & 0xFF) << 8 | this.buffer[1] & 0xFF;
    }

    public final char readChar() throws IOException {
        return (char)this.readUnsignedShort();
    }

    public final int readInt() throws IOException {
        int read = this.in.read(this.buffer, 0, 4);
        if (read == -1 || read != 4) {
            throw new EOFException();
        }
        return ArrayUtil.bArrayToI(this.buffer, 0);
    }

    public final long readLong() throws IOException {
        int read = this.in.read(this.buffer, 0, 8);
        if (read == -1 || read != 8) {
            throw new EOFException();
        }
        return ArrayUtil.bArrayToL(this.buffer, 0);
    }

    public final float readFloat() throws IOException {
        int read = this.in.read(this.buffer, 0, 4);
        if (read == -1 || read != 4) {
            throw new EOFException();
        }
        return ArrayUtil.bArrayToF(this.buffer, 0);
    }

    public final double readDouble() throws IOException {
        int read = this.in.read(this.buffer, 0, 8);
        if (read == -1 || read != 8) {
            throw new EOFException();
        }
        return ArrayUtil.bArrayToD(this.buffer, 0);
    }

    public final String readLine() throws IOException {
        StringBuffer result = new StringBuffer();
        while (true) {
            int next;
            if ((next = this.in.read()) == -1) {
                if (result.length() != 0) break;
                return null;
            }
            if (next == 13) {
                this.lastWasReturn = true;
                break;
            }
            if (next == 10) {
                if (this.lastWasReturn) continue;
                break;
            }
            result.append((char)(next & 0xFF));
            this.lastWasReturn = false;
        }
        return result.toString();
    }

    public final String readUTF() throws IOException {
        int UTFlength = this.readUnsignedShort();
        if (UTFlength < 0) {
            throw new UTFDataFormatException();
        }
        byte[] bytes = new byte[UTFlength];
        this.readFully(bytes);
        return new String(bytes, "UTF8");
    }

    public static final String readUTF(DataInput in) throws IOException {
        int UTFlength = in.readUnsignedShort();
        if (UTFlength < 0) {
            throw new UTFDataFormatException();
        }
        byte[] bytes = new byte[UTFlength];
        in.readFully(bytes);
        return new String(bytes, "UTF8");
    }
}

