/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.Reader;

public class BufferedReader
extends Reader {
    private Reader in;
    private char[] buf;
    private int pos;
    private int count;
    private int markpos;
    private int marklimit;

    public BufferedReader(Reader in) {
        this(in, 8192);
    }

    public BufferedReader(Reader in, int size) {
        super(in);
        if (size <= 0) {
            throw new IllegalArgumentException("negative buffer size");
        }
        this.in = in;
        this.buf = new char[size];
        this.markpos = -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.buf == null) {
                throw new IOException("Reader is closed");
            }
            if (this.count <= this.pos && !this.updateBuffer()) {
                return -1;
            }
            return this.buf[this.pos++];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(char[] b, int off, int len) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.buf == null) {
                throw new IOException("Reader is closed");
            }
            if (off < 0 || len < 0 || off + len > b.length) {
                throw new IndexOutOfBoundsException();
            }
            int rd = 0;
            while (len > 0) {
                if (this.count > this.pos) {
                    int cp = this.count - this.pos;
                    if (len > cp) {
                        System.arraycopy(this.buf, this.pos, b, off, cp);
                        off += cp;
                        len -= cp;
                        this.pos += cp;
                        rd += cp;
                    } else {
                        System.arraycopy(this.buf, this.pos, b, off, len);
                        this.pos += len;
                        break;
                    }
                }
                if (len > this.buf.length && (this.markpos == -1 || this.pos > this.markpos + this.marklimit)) {
                    if ((len = this.in.read(b, off, len)) != -1 || rd <= 0) break;
                    len = 0;
                    break;
                }
                if (this.updateBuffer()) continue;
                len = rd == 0 ? -1 : 0;
                break;
            }
            return rd + len;
        }
    }

    private native int locateEnd(char[] var1, int var2, int var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readLine() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.buf == null) {
                throw new IOException("Reader is closed");
            }
            StringBuffer line = new StringBuffer(64);
            do {
                int end;
                if ((end = this.locateEnd(this.buf, this.pos, this.count)) != -1) {
                    line.append(this.buf, this.pos, end - this.pos);
                    this.pos = end;
                    if (this.buf[this.pos++] == '\r' && (this.count > this.pos || this.updateBuffer()) && this.buf[this.pos] == '\n') {
                        ++this.pos;
                    }
                    return line.toString();
                }
                line.append(this.buf, this.pos, this.count - this.pos);
                this.pos = this.count;
            } while (this.updateBuffer());
            if (line.length() == 0) {
                return null;
            }
            return line.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long skip(long n) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.buf == null) {
                throw new IOException("Reader is closed");
            }
            if (n < 0L) {
                throw new IllegalArgumentException();
            }
            long skipped = 0L;
            while (n > 0L) {
                if (n - (long)this.count + (long)this.pos > 0L) {
                    int skip = this.count - this.pos;
                    this.pos = this.count;
                    if (n - (long)skip > (long)this.buf.length && (this.markpos == -1 || this.pos > this.markpos + this.marklimit)) {
                        return this.in.skip(n - (long)skip) + (long)skip;
                    }
                    if (this.updateBuffer()) continue;
                    break;
                }
                this.pos += (int)n;
                skipped += n;
                break;
            }
            return skipped;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ready() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.buf == null) {
                throw new IOException("Reader is closed");
            }
            return this.count > this.pos || this.in.ready();
        }
    }

    public boolean markSupported() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mark(int readLimit) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.buf == null) {
                throw new IOException("Reader is closed");
            }
            if (readLimit < 0) {
                throw new IllegalArgumentException();
            }
            this.marklimit = readLimit;
            this.markpos = this.pos;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.buf == null || this.markpos == -1 || this.markpos + this.marklimit < this.pos) {
                throw new IOException();
            }
            this.pos = this.markpos;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.buf != null) {
                this.buf = null;
                this.in.close();
                this.in = null;
            }
        }
    }

    private boolean updateBuffer() throws IOException {
        if (this.markpos == -1 || this.pos >= this.markpos + this.marklimit) {
            int rd = this.in.read(this.buf, 0, this.buf.length);
            this.pos = 0;
            this.markpos = -1;
            if (rd == -1) {
                this.count = 0;
                return false;
            }
            if (rd < 1) {
                new Exception("OOPS - read on " + this.in + " returned " + rd).printStackTrace();
            }
            this.count = rd;
            return true;
        }
        char[] chars = this.buf;
        if (this.marklimit > this.buf.length) {
            chars = new char[this.marklimit];
        }
        int cp = this.count - this.markpos;
        System.arraycopy(this.buf, this.markpos, chars, 0, cp);
        int rd = this.in.read(chars, cp, chars.length - cp);
        this.pos = cp;
        this.markpos = 0;
        this.buf = chars;
        if (rd == -1) {
            this.count = cp;
            return false;
        }
        if (rd < 1) {
            new Exception("OOPS - read on " + this.in + " returned " + rd).printStackTrace();
        }
        this.count = cp + rd;
        return true;
    }
}

