/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class BufferedOutputStream
extends FilterOutputStream {
    protected byte[] buf;
    protected int count;

    public BufferedOutputStream(OutputStream out) {
        this(out, 512);
    }

    public BufferedOutputStream(OutputStream out, int size) {
        super(out);
        if (size < 1) {
            throw new IllegalArgumentException("size should be bigger than 0");
        }
        this.buf = new byte[size];
        this.count = 0;
    }

    public void write(int b) throws IOException, NullPointerException {
        if (this.count == this.buf.length) {
            this.out.write(this.buf, 0, this.count);
            this.count = 0;
        }
        this.buf[this.count++] = (byte)b;
    }

    public void write(byte[] b, int off, int len) throws IOException, NullPointerException {
        if (off + len > b.length || off < 0 || len < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (len > 0) {
            if (len + this.count > this.buf.length) {
                this.out.write(this.buf, 0, this.count);
                this.count = 0;
            }
            if (len >= this.buf.length) {
                this.out.write(b, off, len);
            } else {
                System.arraycopy(b, off, this.buf, this.count, len);
                this.count += len;
            }
        }
    }

    public void flush() throws IOException {
        if (this.count > 0) {
            this.out.write(this.buf, 0, this.count);
            this.count = 0;
        }
        this.out.flush();
    }
}

