/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.ColorModel;
import java.awt.image.ImageFilter;
import java.awt.image.IndexColorModel;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class RGBImageFilter
extends ImageFilter {
    protected boolean canFilterIndexColorModel;
    protected ColorModel newmodel;
    protected ColorModel origmodel;

    public IndexColorModel filterIndexColorModel(IndexColorModel icm) {
        ColorModel RGBmodel = ColorModel.getRGBdefault();
        byte[] cmap = new byte[icm.getMapSize() * 4];
        int j = 0;
        int i = 0;
        while (i < icm.getMapSize()) {
            int color = this.filterRGB(-1, -1, icm.getRGB(i));
            cmap[j++] = (byte)RGBmodel.getRed(color);
            cmap[j++] = (byte)RGBmodel.getGreen(color);
            cmap[j++] = (byte)RGBmodel.getBlue(color);
            cmap[j++] = (byte)RGBmodel.getAlpha(color);
            ++i;
        }
        return new IndexColorModel(icm.getPixelSize(), icm.getMapSize(), cmap, 0, true, icm.getTransparentPixel());
    }

    public abstract int filterRGB(int var1, int var2, int var3);

    public void filterRGBPixels(int x, int y, int w, int h, int[] pixels, int offset, int scansize) {
        int i = 0;
        while (i < h) {
            int j = 0;
            while (j < w) {
                pixels[i * scansize + j + offset] = this.filterRGB(x + j, y + i, pixels[i * scansize + j + offset]);
                ++j;
            }
            ++i;
        }
    }

    public void setColorModel(ColorModel model) {
        if (model instanceof IndexColorModel && this.canFilterIndexColorModel) {
            this.substituteColorModel(model, this.filterIndexColorModel((IndexColorModel)model));
            super.setColorModel(this.newmodel);
        } else {
            super.setColorModel(ColorModel.getRGBdefault());
        }
    }

    public void setPixels(int x, int y, int w, int h, ColorModel model, byte[] pixels, int off, int scansize) {
        if (this.newmodel == null) {
            int[] newpixels = new int[pixels.length];
            int i = 0;
            while (i < h) {
                int j = 0;
                while (j < w) {
                    newpixels[i * scansize + j + off] = model.getRGB(pixels[i * scansize + j + off]);
                    ++j;
                }
                ++i;
            }
            this.filterRGBPixels(x, y, w, h, newpixels, off, scansize);
            super.setPixels(x, y, w, h, ColorModel.getRGBdefault(), newpixels, 0, w);
        } else {
            super.setPixels(x, y, w, h, this.newmodel, pixels, 0, w);
        }
    }

    public void setPixels(int x, int y, int w, int h, ColorModel model, int[] pixels, int off, int scansize) {
        int[] newpixels = pixels;
        if (this.newmodel == null) {
            newpixels = new int[pixels.length];
            int i = 0;
            while (i < h) {
                int j = 0;
                while (j < w) {
                    newpixels[i * scansize + j + off] = model.getRGB(pixels[i * scansize + j + off]);
                    ++j;
                }
                ++i;
            }
            this.filterRGBPixels(x, y, w, h, newpixels, off, scansize);
            super.setPixels(x, y, w, h, ColorModel.getRGBdefault(), newpixels, off, scansize);
        } else {
            super.setPixels(x, y, w, h, this.newmodel, newpixels, 0, w);
        }
    }

    public void substituteColorModel(ColorModel oldcm, ColorModel newcm) {
        this.origmodel = oldcm;
        this.newmodel = newcm;
    }

    private final /* synthetic */ void this() {
        this.newmodel = null;
        this.origmodel = null;
    }

    public RGBImageFilter() {
        this.this();
    }
}

