/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.util.Hashtable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PixelGrabber
implements ImageConsumer {
    private int status;
    private int hints;
    private ColorModel colorModel;
    private Hashtable properties;
    private ImageProducer producer;
    private int sx;
    private int sy;
    private int sw;
    private int sh;
    private int off;
    private int scansize;
    private int[] pixels;
    private boolean rgb;

    public synchronized void abortGrabbing() {
    }

    public synchronized ColorModel getColorModel() {
        if (this.rgb) {
            return ColorModel.getRGBdefault();
        }
        return this.colorModel;
    }

    public synchronized int getHeight() {
        return this.sh;
    }

    public synchronized int getWidth() {
        return this.sw;
    }

    public synchronized Object getPixels() {
        return this.pixels;
    }

    public synchronized int getStatus() {
        return this.status;
    }

    public synchronized boolean grabPixels() throws InterruptedException {
        this.startGrabbing();
        while (this.status != 8) {
            Thread.sleep(1L);
        }
        return true;
    }

    public synchronized boolean grabPixels(long ms) throws InterruptedException {
        this.startGrabbing();
        while (this.status != 8) {
            Thread.sleep(1L);
        }
        return true;
    }

    public synchronized void startGrabbing() {
        this.producer.startProduction(this);
    }

    public void imageComplete(int status) {
        this.status = status;
    }

    public void setColorModel(ColorModel model) {
        this.colorModel = model;
    }

    public void setDimensions(int w, int h) {
        if (this.sw < 0) {
            this.sw = w;
        }
        if (this.sh < 0) {
            this.sh = h;
        }
        this.pixels = new int[w * h];
    }

    public void setHints(int hints) {
        this.hints = hints;
    }

    private final int convertRGB(int red, int green, int blue) {
        return 0xFF000000 | red << 16 | green << 8 | blue;
    }

    public void setPixels(int x, int y, int w, int h, ColorModel model, byte[] pixels, int offset, int scansize) {
        int ox = this.sx - x;
        int oy = this.sy - y;
        int nw = this.sw;
        int nh = this.sh;
        int ss = this.scansize;
        if (ox < 0) {
            nw += ox;
            ox = 0;
        }
        if (oy < 0) {
            nh += oy;
            oy = 0;
        }
        if (this.sx + this.sw > x + w) {
            nw -= this.sw - (x + w - this.sx);
        }
        if (this.sy + this.sh > y + h) {
            nh -= this.sh - (y + h - this.sy);
        }
        if (nw <= 0 || nh <= 0) {
            return;
        }
        if (this.rgb) {
            int j = 0;
            while (j < nh) {
                int i = 0;
                while (i < nw) {
                    byte pixel = pixels[(j + oy) * scansize + (i + ox) + offset];
                    this.pixels[(j + y) * ss + (i + x)] = this.convertRGB(model.getRed(pixel), model.getGreen(pixel), model.getBlue(pixel));
                    ++i;
                }
                ++j;
            }
        } else {
            int j = 0;
            while (j < nh) {
                int i = 0;
                while (i < nw) {
                    this.pixels[(j + y) * ss + (i + x)] = pixels[(j + oy) * scansize + (i + ox) + offset];
                    ++i;
                }
                ++j;
            }
        }
    }

    public void setPixels(int x, int y, int w, int h, ColorModel model, int[] pixels, int offset, int scansize) {
        int ox = this.sx - x;
        int oy = this.sy - y;
        int nw = this.sw;
        int nh = this.sh;
        int ss = this.scansize;
        if (ox < 0) {
            nw += ox;
            ox = 0;
        }
        if (oy < 0) {
            nh += oy;
            oy = 0;
        }
        if (this.sx + this.sw > x + w) {
            nw -= this.sw - (x + w - this.sx);
        }
        if (this.sy + this.sh > y + h) {
            nh -= this.sh - (y + h - this.sy);
        }
        if (nw <= 0 || nh <= 0) {
            return;
        }
        if (this.rgb) {
            int j = 0;
            while (j < nh) {
                int i = 0;
                while (i < nw) {
                    int pixel = pixels[(j + oy) * scansize + (i + ox) + offset];
                    this.pixels[(j + y) * ss + (i + x)] = this.convertRGB(model.getRed(pixel), model.getGreen(pixel), model.getBlue(pixel));
                    ++i;
                }
                ++j;
            }
        } else {
            int j = 0;
            while (j < nh) {
                int i = 0;
                while (i < nw) {
                    this.pixels[(j + y) * ss + (i + x)] = pixels[(j + oy) * scansize + (i + ox) + offset];
                    ++i;
                }
                ++j;
            }
        }
    }

    public void setProperties(Hashtable properties) {
        this.properties = properties;
    }

    public String toString() {
        return "[PixelGrabber] status: " + this.status + "  hints: " + this.hints + "  colormodel: " + this.colorModel + "  width: " + this.sw + "  height: " + this.sh + "  producer: " + this.producer + "  pixels: " + this.pixels;
    }

    private final /* synthetic */ void this() {
        this.colorModel = null;
    }

    public PixelGrabber(Image img, int x, int y, int w, int h, int[] pix, int off, int scansize) {
        this(img.getSource(), x, y, w, h, pix, off, scansize);
    }

    public PixelGrabber(ImageProducer ip, int x, int y, int w, int h, int[] pix, int off, int scansize) {
        this.this();
        this.sx = x;
        this.sy = y;
        this.sw = w;
        this.sh = h;
        this.pixels = pix;
        this.off = off;
        this.scansize = scansize;
        this.producer = ip;
        this.rgb = true;
    }

    public PixelGrabber(Image img, int x, int y, int w, int h, boolean forceRGB) {
        this.this();
        this.sx = x;
        this.sy = y;
        this.sw = w;
        this.sh = h;
        this.pixels = null;
        this.off = 0;
        this.scansize = w;
        this.producer = img.getSource();
        this.rgb = forceRGB;
    }
}

