/*
 * Decompiled with CFR 0.152.
 */
package java.awt.event;

import java.awt.Component;
import java.awt.event.ComponentEvent;

public class FocusEvent
extends ComponentEvent {
    public static final int FOCUS_GAINED = 1004;
    public static final int FOCUS_FIRST = 1004;
    public static final int FOCUS_LAST = 1005;
    public static final int FOCUS_LOST = 1005;
    protected boolean temporary;

    public FocusEvent(Component source, int id) {
        super(source, id);
        this.temporary = false;
    }

    public FocusEvent(Component source, int id, boolean temporary) {
        super(source, id);
        this.temporary = temporary;
    }

    public boolean isTemporary() {
        return this.temporary;
    }

    public String toString() {
        String commandstring = "[Unknown command " + this.id + "]";
        if (this.id == 1004) {
            commandstring = "[FOCUS_GAINED]";
        } else if (this.id == 1005) {
            commandstring = "[FOCUS_LOST]";
        }
        commandstring = commandstring + (this.temporary ? " temporary" : " permanent");
        return this.getClass().getName() + commandstring + this.source;
    }

    public String paramString() {
        return this.getClass().getName() + "[Function id=" + this.id + "] Temporary=" + this.temporary + "from=" + this.source;
    }
}

