/*
 * Decompiled with CFR 0.152.
 */
package java.awt.dnd;

import java.awt.Component;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class MouseDragGestureRecognizer
extends DragGestureRecognizer
implements MouseListener,
MouseMotionListener {
    private boolean initialiseDrag = false;
    private boolean entered = false;

    protected MouseDragGestureRecognizer(DragSource ds, Component c, int act, DragGestureListener dgl) {
        super(ds, c, act, dgl);
    }

    protected MouseDragGestureRecognizer(DragSource ds, Component c, int act) {
        super(ds, c, act);
    }

    protected MouseDragGestureRecognizer(DragSource ds, Component c) {
        super(ds, c);
    }

    protected MouseDragGestureRecognizer(DragSource ds) {
        super(ds);
    }

    protected void registerListeners() {
        this.component.addMouseMotionListener(this);
        this.component.addMouseListener(this);
    }

    protected void unregisterListeners() {
        this.component.removeMouseMotionListener(this);
        this.component.removeMouseListener(this);
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        if (this.entered) {
            this.initialiseDrag = true;
        }
    }

    public void mouseReleased(MouseEvent e) {
        this.initialiseDrag = false;
        if (this.entered) {
            this.resetRecognizer();
        }
    }

    public void mouseEntered(MouseEvent e) {
        this.entered = true;
    }

    public void mouseExited(MouseEvent e) {
        this.entered = false;
    }

    public void mouseDragged(MouseEvent e) {
        if (this.initialiseDrag) {
            this.initialiseDrag = false;
            this.appendEvent(e);
            this.fireDragGestureRecognized(this.getSourceActions(), e.getPoint());
        }
    }

    public void mouseMoved(MouseEvent e) {
    }
}

