/*
 * Decompiled with CFR 0.152.
 */
package java.awt.dnd;

import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetContext;
import java.awt.dnd.DropTargetEvent;
import java.util.List;

public class DropTargetDropEvent
extends DropTargetEvent {
    private Point location;
    private int dropAction;
    private int actions;
    private boolean isLocalTx;
    private static int[] constants = new int[]{1, 2, 3, 4};

    public DropTargetDropEvent(DropTargetContext dtc, Point cursorLocn, int dropAction, int srcActions) {
        super(dtc);
        if (cursorLocn == null) {
            throw new NullPointerException();
        }
        boolean legaldtc = false;
        boolean legalDropAction = false;
        boolean legalSourceAction = false;
        if (dtc != null) {
            legaldtc = true;
        }
        for (int i = 0; i < constants.length; ++i) {
            if (dropAction == constants[i]) {
                legalDropAction = true;
            }
            if (srcActions != constants[i]) continue;
            legalSourceAction = true;
        }
        if (!(legaldtc && legalDropAction && legalSourceAction)) {
            throw new IllegalArgumentException();
        }
        this.location = cursorLocn;
        this.dropAction = dropAction;
        this.actions = srcActions;
        this.isLocalTx = false;
    }

    public DropTargetDropEvent(DropTargetContext dtc, Point cursorLocn, int dropAction, int srcActions, boolean isLocal) {
        super(dtc);
        if (cursorLocn == null) {
            throw new NullPointerException();
        }
        boolean legaldtc = false;
        boolean legalDropAction = false;
        boolean legalSourceAction = false;
        if (dtc != null) {
            legaldtc = true;
        }
        for (int i = 0; i < constants.length; ++i) {
            if (dropAction == constants[i]) {
                legalDropAction = true;
            }
            if (srcActions != constants[i]) continue;
            legalSourceAction = true;
        }
        if (!(legaldtc && legalDropAction && legalSourceAction)) {
            throw new IllegalArgumentException();
        }
        this.location = cursorLocn;
        this.dropAction = dropAction;
        this.actions = srcActions;
        this.isLocalTx = isLocal;
    }

    public Point getLocation() {
        return this.location;
    }

    public DataFlavor[] getCurrentDataFlavors() {
        return this.context.getCurrentDataFlavors();
    }

    public List getCurrentDataFlavorsAsList() {
        return this.context.getCurrentDataFlavorsAsList();
    }

    public boolean isDataFlavorSupported(DataFlavor df) {
        return this.context.isDataFlavorSupported(df);
    }

    public int getSourceActions() {
        return this.actions;
    }

    public int getDropAction() {
        return this.dropAction;
    }

    public Transferable getTransferable() {
        return this.context.getTransferable();
    }

    public void acceptDrop(int dropAction) {
        this.context.acceptDrag(dropAction);
    }

    public void rejectDrop() {
        this.context.rejectDrop();
    }

    public void dropComplete(boolean success) {
        this.context.dropComplete(success);
    }

    public boolean isLocalTransfer() {
        return this.isLocalTx;
    }
}

