/*
 * Decompiled with CFR 0.152.
 */
package java.awt.dnd;

import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.dnd.peer.DropTargetContextPeer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class DropTargetContext {
    private Component component;
    private DropTargetContextPeer peer;
    private TransferableProxy transferableProxy;

    public DropTarget getDropTarget() {
        return this.peer.getDropTarget();
    }

    public Component getComponent() {
        return this.peer.getDropTarget().getComponent();
    }

    public void addNotify(DropTargetContextPeer dtcp) {
        this.peer = dtcp;
        this.transferableProxy = (TransferableProxy)this.createTransferableProxy(this.peer.getTransferable(), this.peer.isTransferableJVMLocal());
    }

    public void removeNotify() {
        this.peer = null;
    }

    protected void setTargetActions(int actions) {
        this.peer.setTargetActions(actions);
    }

    protected int getTargetActions() {
        return this.peer.getTargetActions();
    }

    public void dropComplete(boolean success) throws InvalidDnDOperationException {
        this.peer.dropComplete(success);
    }

    protected void acceptDrag(int dragOperation) {
        this.peer.acceptDrag(dragOperation);
    }

    protected void rejectDrag() {
        this.peer.rejectDrag();
    }

    protected void acceptDrop(int dropOperation) {
        this.peer.acceptDrop(dropOperation);
    }

    protected void rejectDrop() {
        this.peer.rejectDrop();
    }

    protected DataFlavor[] getCurrentDataFlavors() {
        return this.transferableProxy.getTransferDataFlavors();
    }

    protected List getCurrentDataFlavorsAsList() {
        DataFlavor[] temp = this.transferableProxy.getTransferDataFlavors();
        ArrayList theReturnList = new ArrayList();
        for (int i = 0; i < temp.length; ++i) {
            theReturnList.add(temp[i]);
        }
        return theReturnList;
    }

    protected boolean isDataFlavorSupported(DataFlavor df) {
        return this.transferableProxy.isDataFlavorSupported(df);
    }

    protected Transferable getTransferable() throws InvalidDnDOperationException {
        return this.transferableProxy;
    }

    protected Transferable createTransferableProxy(Transferable t, boolean local) {
        return new TransferableProxy(t, local);
    }

    protected class TransferableProxy
    implements Transferable {
        protected Transferable transferable;
        protected boolean isLocal;

        private TransferableProxy(Transferable t, boolean local) {
            this.transferable = t;
            this.isLocal = local;
        }

        public DataFlavor[] getTransferDataFlavors() {
            if (DropTargetContext.this.peer != null) {
                this.transferable = DropTargetContext.this.peer.getTransferable();
                this.isLocal = DropTargetContext.this.peer.isTransferableJVMLocal();
            }
            return this.transferable.getTransferDataFlavors();
        }

        public boolean isDataFlavorSupported(DataFlavor flavor) {
            if (DropTargetContext.this.peer != null) {
                this.transferable = DropTargetContext.this.peer.getTransferable();
                this.isLocal = DropTargetContext.this.peer.isTransferableJVMLocal();
            }
            return this.transferable.isDataFlavorSupported(flavor);
        }

        public Object getTransferData(DataFlavor df) throws UnsupportedFlavorException, IOException {
            if (DropTargetContext.this.peer != null) {
                this.transferable = DropTargetContext.this.peer.getTransferable();
                this.isLocal = DropTargetContext.this.peer.isTransferableJVMLocal();
            }
            return this.transferable.getTransferData(df);
        }
    }
}

