/*
 * Decompiled with CFR 0.152.
 */
package java.awt.datatransfer;

import com.acunia.wonka.rudolph.DefaultFlavorMap;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorMap;
import java.util.Map;

public final class SystemFlavorMap
implements FlavorMap {
    private static DefaultFlavorMap defaultfm = new DefaultFlavorMap();
    private static SystemFlavorMap sfm = new SystemFlavorMap();

    private SystemFlavorMap() {
    }

    public static FlavorMap getDefaultFlavorMap() {
        return sfm;
    }

    public Map getNativesForFlavors(DataFlavor[] flavors) {
        return defaultfm.getNativesForFlavors(flavors);
    }

    public Map getFlavorsForNatives(String[] natives) {
        return defaultfm.getFlavorsForNatives(natives);
    }

    public static String encodeJavaMIMEType(String mimeType) {
        return "JAVA_DATAFLAVOR:" + mimeType;
    }

    public static String encodeDataFlavor(DataFlavor df) {
        return "JAVA_DATAFLAVOR:" + df.getMimeType();
    }

    public static boolean isJavaMIMEType(String atom) {
        return atom.indexOf("JAVA_DATAFLAVOR:") >= 0;
    }

    public static String decodeJavaMIMEType(String atom) {
        if (SystemFlavorMap.isJavaMIMEType(atom)) {
            return atom.substring(atom.indexOf("JAVA_DATAFLAVOR:") + 16);
        }
        return null;
    }

    public static DataFlavor decodeDataFlavor(String atom) throws ClassNotFoundException {
        String mimeType = SystemFlavorMap.decodeJavaMIMEType(atom);
        if (mimeType != null) {
            return new DataFlavor(mimeType, "");
        }
        return null;
    }
}

