/*
 * Decompiled with CFR 0.152.
 */
package java.awt.datatransfer;

import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Reader;
import java.io.StringReader;

public class DataFlavor
implements Externalizable,
Cloneable {
    public static final DataFlavor javaFileListFlavor = new DataFlavor("application/x-java-file-list; class=java.util.List", "application/x-java-file-list");
    public static final DataFlavor plainTextFlavor = new DataFlavor("text/plain; charset=unicode", "Plain Text");
    public static final DataFlavor stringFlavor = new DataFlavor(class$java$lang$String == null ? (class$java$lang$String = DataFlavor.class$("java.lang.String")) : class$java$lang$String, "Unicode String");
    public static final String javaJVMLocalObjectMimeType = "application/x-java-jvm-local-objectref";
    public static final String javaRemoteObjectMimeType = "application/x-java-remote-object";
    public static final String javaSerializedObjectMimeType = "application/x-java-serialized-object";
    private Class defaultRepresentationClass = class$java$io$InputStream == null ? (class$java$io$InputStream = DataFlavor.class$("java.io.InputStream")) : class$java$io$InputStream;
    private Class representationClass;
    private String charset;
    private String mimeType;
    private String humanPresentableName;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$io$InputStream;
    static /* synthetic */ Class class$java$awt$datatransfer$DataFlavor;
    static /* synthetic */ Class class$java$io$Reader;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$io$Serializable;
    static /* synthetic */ Class class$java$rmi$Remote;

    public DataFlavor() {
    }

    public DataFlavor(String mimeType, String humanPresentableName) {
        String givenClass;
        this.mimeType = mimeType.indexOf(59) > 0 ? mimeType.substring(0, mimeType.indexOf(59)).trim() : mimeType;
        this.humanPresentableName = humanPresentableName;
        if (mimeType.indexOf("class=") >= 0) {
            givenClass = mimeType.substring(mimeType.lastIndexOf("class=") + 6).trim();
            if (givenClass.indexOf(59) >= 0) {
                givenClass = givenClass.substring(0, givenClass.indexOf(59)).trim();
            }
        } else {
            givenClass = mimeType.trim();
            if (mimeType.indexOf("application") >= 0) {
                throw new IllegalArgumentException("no representation class specified for:application/x-java-serialized-object");
            }
        }
        if (mimeType.indexOf("text/plain") >= 0) {
            if (mimeType.indexOf("charset=") >= 0) {
                this.charset = mimeType.substring(mimeType.lastIndexOf("charset=") + 8).trim();
            }
            try {
                this.representationClass = Class.forName("java.io.InputStream");
            }
            catch (ClassNotFoundException e) {
                System.out.println(e.getMessage());
            }
        } else {
            try {
                this.representationClass = Class.forName(givenClass);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("failed to parse:" + givenClass);
            }
        }
    }

    public DataFlavor(Class representationClass, String humanPresentableName) {
        this.representationClass = representationClass;
        this.humanPresentableName = humanPresentableName;
        this.mimeType = javaSerializedObjectMimeType;
    }

    public DataFlavor(String mimeType, String humanPresentableName, ClassLoader classLoader) throws ClassNotFoundException {
        String givenClass;
        this.mimeType = mimeType.indexOf(59) > 0 ? mimeType.substring(0, mimeType.indexOf(59)).trim() : mimeType;
        this.humanPresentableName = humanPresentableName;
        if (mimeType.indexOf("class=") >= 0) {
            givenClass = mimeType.substring(mimeType.lastIndexOf("class=") + 6).trim();
            if (givenClass.indexOf(59) >= 0) {
                givenClass = givenClass.substring(0, givenClass.indexOf(59)).trim();
            }
        } else {
            givenClass = mimeType.trim();
            if (mimeType.indexOf("application") >= 0) {
                throw new IllegalArgumentException("no representation class specified for:application/x-java-serialized-object");
            }
        }
        if (mimeType.indexOf("text/plain") >= 0) {
            if (mimeType.indexOf("charset=") >= 0) {
                this.charset = mimeType.substring(mimeType.lastIndexOf("charset=") + 8).trim();
            }
            this.representationClass = classLoader.loadClass("java.io.InputStream");
        } else {
            this.representationClass = classLoader.loadClass(givenClass);
        }
    }

    public String toString() {
        String data = (class$java$awt$datatransfer$DataFlavor == null ? (class$java$awt$datatransfer$DataFlavor = DataFlavor.class$("java.awt.datatransfer.DataFlavor")) : class$java$awt$datatransfer$DataFlavor).getName() + "[mimetype=" + this.mimeType + ";representationclass=" + this.representationClass.getName();
        if (this.charset != null) {
            data = data + ";charset=" + this.charset;
        }
        return data + "]";
    }

    public static final DataFlavor getTextPlainUnicodeFlavor() {
        return plainTextFlavor;
    }

    public static final DataFlavor selectBestTextFlavor(DataFlavor[] availableFlavors) {
        int i;
        for (i = 0; i < availableFlavors.length; ++i) {
            if (availableFlavors[i] != stringFlavor) continue;
            return availableFlavors[i];
        }
        for (i = 0; i < availableFlavors.length; ++i) {
            if (availableFlavors[i] != plainTextFlavor) continue;
            return availableFlavors[i];
        }
        return null;
    }

    public Reader getReaderForText(Transferable transferable) throws UnsupportedFlavorException, IOException {
        if (transferable == null) {
            throw new NullPointerException();
        }
        if (this.representationClass == (class$java$io$Reader == null ? (class$java$io$Reader = DataFlavor.class$("java.io.Reader")) : class$java$io$Reader)) {
            try {
                return (Reader)this.representationClass.newInstance();
            }
            catch (InstantiationException ie) {
                throw new UnsupportedFlavorException(this);
            }
            catch (IllegalAccessException iae) {
                throw new UnsupportedFlavorException(this);
            }
            catch (NoSuchMethodException nsme) {
                throw new UnsupportedFlavorException(this);
            }
        }
        if (!transferable.isDataFlavorSupported(this)) {
            throw new UnsupportedFlavorException(this);
        }
        if (transferable.getTransferData(this) == null) {
            throw new IllegalArgumentException("data of transferable is null");
        }
        if (this.representationClass != (class$java$lang$String == null ? (class$java$lang$String = DataFlavor.class$("java.lang.String")) : class$java$lang$String) && this.representationClass != (class$java$io$InputStream == null ? (class$java$io$InputStream = DataFlavor.class$("java.io.InputStream")) : class$java$io$InputStream)) {
            throw new IllegalArgumentException();
        }
        try {
            if (this.representationClass == (class$java$lang$String == null ? (class$java$lang$String = DataFlavor.class$("java.lang.String")) : class$java$lang$String)) {
                return new StringReader((String)transferable.getTransferData(stringFlavor));
            }
            return new InputStreamReader((InputStream)transferable.getTransferData(this), this.getParameter("charset"));
        }
        catch (ClassCastException cce) {
            throw new UnsupportedFlavorException(this);
        }
    }

    public String getMimeType() {
        if (this.mimeType.indexOf("application") >= 0) {
            return this.mimeType + "; class=" + this.representationClass.getName();
        }
        return this.mimeType + "; class=" + this.representationClass.getName() + "; charset=" + this.charset;
    }

    public Class getRepresentationClass() {
        return this.representationClass;
    }

    public String getHumanPresentableName() {
        return this.humanPresentableName;
    }

    public String getPrimaryType() {
        String primaryMimeType = this.mimeType;
        if (primaryMimeType.indexOf(47) > 0) {
            primaryMimeType = primaryMimeType.substring(0, primaryMimeType.indexOf(47));
        }
        return primaryMimeType;
    }

    public String getSubType() {
        String subMimeType = this.mimeType;
        if (subMimeType.indexOf(47) > 0) {
            subMimeType = subMimeType.substring(subMimeType.indexOf(47) + 1);
        }
        return subMimeType;
    }

    public String getParameter(String paramName) {
        if (paramName.equalsIgnoreCase("class")) {
            return this.representationClass.getName();
        }
        if (paramName.equalsIgnoreCase("charset")) {
            return this.charset;
        }
        return null;
    }

    public void setHumanPresentableName(String humanPresentableName) {
        this.humanPresentableName = humanPresentableName;
    }

    public boolean equals(Object o) {
        DataFlavor object;
        try {
            object = (DataFlavor)o;
        }
        catch (Exception e) {
            return false;
        }
        return this.mimeType.equalsIgnoreCase(object.mimeType) && this.representationClass == object.representationClass;
    }

    public boolean equals(DataFlavor dataFlavor) {
        return this.mimeType.equalsIgnoreCase(dataFlavor.mimeType) && this.representationClass.equals(dataFlavor.representationClass);
    }

    public boolean equals(String s) {
        return this.isMimeTypeEqual(s);
    }

    public int hashCode() {
        return this.mimeType.hashCode() + this.representationClass.hashCode();
    }

    public boolean match(DataFlavor that) {
        if (this.mimeType.toLowerCase().indexOf("text") >= 0) {
            return this.mimeType.equalsIgnoreCase(that.mimeType) && this.representationClass == that.representationClass && this.charset.equalsIgnoreCase(that.charset);
        }
        return this.mimeType.equalsIgnoreCase(that.mimeType) && this.representationClass == that.representationClass;
    }

    public boolean isMimeTypeEqual(String mimeType) {
        String thisMimeType = this.mimeType.toLowerCase().trim();
        String comparedMimeType = mimeType.toLowerCase().trim();
        if (thisMimeType.indexOf(59) >= 0) {
            thisMimeType = thisMimeType.substring(0, thisMimeType.indexOf(59)).trim();
        }
        if (comparedMimeType.indexOf(59) >= 0) {
            comparedMimeType = comparedMimeType.substring(0, comparedMimeType.indexOf(59)).trim();
        }
        System.out.println("thisMimeType = " + thisMimeType);
        System.out.println("comparedMimeType = " + comparedMimeType);
        return thisMimeType.equals(comparedMimeType);
    }

    public final boolean isMimeTypeEqual(DataFlavor dataFlavor) {
        return this.isMimeTypeEqual(dataFlavor.mimeType);
    }

    public boolean isMimeTypeSerializedObject() {
        return this.mimeType.indexOf("serialized") >= 0;
    }

    public final Class getDefaultRepresentationClass() {
        return this.defaultRepresentationClass;
    }

    public final String getDefaultRepresentationClassAsString() {
        return this.defaultRepresentationClass.getName();
    }

    public boolean isRepresentationClassInputStream() {
        boolean isInputStream = false;
        Class superclass = this.representationClass;
        while (!superclass.equals(class$java$lang$Object == null ? DataFlavor.class$("java.lang.Object") : class$java$lang$Object)) {
            if (superclass == (class$java$io$InputStream == null ? DataFlavor.class$("java.io.InputStream") : class$java$io$InputStream)) {
                isInputStream = true;
            }
            superclass = superclass.getSuperclass();
        }
        return isInputStream;
    }

    public boolean isRepresentationClassSerializable() {
        boolean isSerializable = false;
        Class[] classes = this.representationClass.getInterfaces();
        for (int i = 0; i < classes.length; ++i) {
            if (classes[i] != (class$java$io$Serializable == null ? DataFlavor.class$("java.io.Serializable") : class$java$io$Serializable)) continue;
            isSerializable = true;
        }
        return isSerializable;
    }

    public boolean isRepresentationClassRemote() {
        boolean isRemote = false;
        Class[] classes = this.representationClass.getInterfaces();
        for (int i = 0; i < classes.length; ++i) {
            if (classes[i] != (class$java$rmi$Remote == null ? DataFlavor.class$("java.rmi.Remote") : class$java$rmi$Remote)) continue;
            isRemote = true;
        }
        return isRemote;
    }

    public boolean isFlavorSerializedObjectType() {
        return this.isRepresentationClassSerializable();
    }

    public boolean isFlavorRemoteObjectType() {
        return this.isRepresentationClassRemote();
    }

    public boolean isFlavorJavaFileListType() {
        return javaFileListFlavor.getMimeType().equalsIgnoreCase(this.getMimeType());
    }

    public void readExternal(ObjectInput is) throws IOException, ClassNotFoundException {
        this.mimeType = (String)is.readObject();
        this.representationClass = (Class)is.readObject();
        this.humanPresentableName = (String)is.readObject();
        this.charset = (String)is.readObject();
    }

    public void writeExternal(ObjectOutput os) throws IOException {
        os.writeObject(this.mimeType);
        os.writeObject(this.representationClass);
        os.writeObject(this.humanPresentableName);
        os.writeObject(this.charset);
    }

    public Object clone() throws CloneNotSupportedException {
        DataFlavor result = new DataFlavor();
        result.charset = this.charset;
        result.humanPresentableName = this.humanPresentableName;
        result.mimeType = this.mimeType;
        result.representationClass = this.representationClass;
        return result;
    }

    protected static final Class tryToLoadClass(String className, ClassLoader fallback) throws ClassNotFoundException {
        return null;
    }

    protected String normalizeMimeType(String parameterName, String parameterValue) {
        return parameterName.toLowerCase().trim() + '=' + parameterValue.toLowerCase().trim();
    }

    protected String normalizeMimeType(String mimeType) {
        return mimeType;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

