/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.io.Serializable;

public class Polygon
implements Shape,
Serializable {
    private static final long serialVersionUID = -6460061437900069969L;
    protected Rectangle bounds;
    public int[] xpoints;
    public int[] ypoints;
    public int npoints;
    private boolean[] isPeak;

    public Rectangle getBounds() {
        return new Rectangle(this.bounds);
    }

    public Rectangle getBoundingBox() {
        return new Rectangle(this.bounds);
    }

    public Polygon(int[] x, int[] y, int size) {
        if (size < 0) {
            throw new NegativeArraySizeException();
        }
        if (size == 0) {
            this.npoints = 0;
            this.xpoints = new int[1];
            this.ypoints = new int[1];
            this.bounds = new Rectangle();
            this.isPeak = new boolean[1];
        } else if (size == 1) {
            this.npoints = 0;
            this.xpoints = new int[1];
            this.ypoints = new int[1];
            this.bounds = new Rectangle();
            if (x.length >= 1) {
                this.xpoints[0] = x[0];
                this.bounds.x = x[0];
            } else {
                this.xpoints[0] = 0;
            }
            if (y.length >= 1) {
                this.ypoints[0] = y[0];
                this.bounds.y = y[0];
            } else {
                this.ypoints[0] = 0;
            }
            this.isPeak = new boolean[1];
            this.isPeak[0] = true;
        } else {
            int i;
            this.npoints = size;
            this.xpoints = new int[size];
            this.ypoints = new int[size];
            this.isPeak = new boolean[size];
            this.bounds = new Rectangle(x[0], y[0], x[0], y[0]);
            this.xpoints[0] = x[0];
            this.ypoints[0] = y[0];
            for (i = 1; i < this.npoints && i < x.length; ++i) {
                this.xpoints[i] = x[i];
                if (x[i] < this.bounds.x) {
                    this.bounds.x = x[i];
                    continue;
                }
                if (x[i] <= this.bounds.width) continue;
                this.bounds.width = x[i];
            }
            this.bounds.width -= this.bounds.x;
            for (i = 1; i < this.npoints && i < y.length; ++i) {
                this.ypoints[i] = y[i];
                if (y[i] < this.bounds.y) {
                    this.bounds.y = y[i];
                    continue;
                }
                if (y[i] <= this.bounds.height) continue;
                this.bounds.height = y[i];
            }
            this.bounds.height -= this.bounds.y;
            this.isPeak[0] = this.ypoints[0] < this.ypoints[--size] && this.ypoints[0] < this.ypoints[1] || this.ypoints[0] > this.ypoints[size] && this.ypoints[0] > this.ypoints[1];
            for (i = 1; i < size; ++i) {
                this.isPeak[i] = this.ypoints[i] < this.ypoints[i - 1] && this.ypoints[i] < this.ypoints[i + 1] || this.ypoints[i] > this.ypoints[i - 1] && this.ypoints[i] > this.ypoints[i + 1];
            }
            this.isPeak[size] = this.ypoints[size] < this.ypoints[size - 1] && this.ypoints[size] < this.ypoints[0] || this.ypoints[size] > this.ypoints[size - 1] && this.ypoints[size] > this.ypoints[0];
        }
    }

    public Polygon() {
        this(null, null, 0);
    }

    public void addPoint(int x, int y) {
        if (this.npoints == 0) {
            this.xpoints[0] = x;
            this.ypoints[0] = y;
            this.isPeak[0] = true;
            this.bounds.setBounds(x, y, 0, 0);
            this.npoints = 1;
        } else if (this.npoints == 1) {
            this.xpoints = new int[2];
            this.xpoints[0] = this.bounds.x;
            this.xpoints[1] = x;
            this.ypoints = new int[2];
            this.ypoints[0] = this.bounds.y;
            this.ypoints[1] = y;
            this.isPeak = new boolean[2];
            this.isPeak[0] = true;
            this.isPeak[1] = true;
            if (x < this.bounds.x) {
                this.bounds.width = this.bounds.x - x;
                this.bounds.x = x;
            } else {
                this.bounds.width = x - this.bounds.x;
            }
            if (y < this.bounds.y) {
                this.bounds.height = this.bounds.y - y;
                this.bounds.y = y;
            } else {
                this.bounds.height = y - this.bounds.y;
            }
            this.npoints = 2;
        } else {
            int[] swapx = new int[this.npoints + 1];
            int[] swapy = new int[this.npoints + 1];
            boolean[] peaks = new boolean[this.npoints + 1];
            if (x < this.bounds.x) {
                this.bounds.width = this.bounds.width + this.bounds.x - x;
                this.bounds.x = x;
            } else if (x > this.bounds.x + this.bounds.width) {
                this.bounds.width = x - this.bounds.x;
            }
            if (y < this.bounds.y) {
                this.bounds.height = this.bounds.width + this.bounds.y - y;
                this.bounds.y = y;
            } else if (y > this.bounds.y + this.bounds.height) {
                this.bounds.height = y - this.bounds.y;
            }
            for (int i = 0; i < this.npoints; ++i) {
                swapx[i] = this.xpoints[i];
                swapy[i] = this.ypoints[i];
                peaks[i] = this.isPeak[i];
            }
            swapx[this.npoints] = x;
            swapy[this.npoints] = y;
            peaks[this.npoints - 1] = swapy[this.npoints - 2] > swapy[this.npoints - 1] && y > swapy[this.npoints - 1] || swapy[this.npoints - 2] < swapy[this.npoints - 1] && y < swapy[this.npoints - 1];
            peaks[this.npoints] = y > swapy[this.npoints - 1] && y > swapy[0] || y < swapy[this.npoints - 1] && y < swapy[0];
            peaks[0] = swapy[1] > swapy[0] && y > swapy[0] || swapy[1] < swapy[0] && y < swapy[0];
            this.xpoints = swapx;
            this.ypoints = swapy;
            this.isPeak = peaks;
            ++this.npoints;
        }
    }

    public void translate(int offsetx, int offsety) {
        int i = 0;
        while (i < this.npoints) {
            int n = i;
            this.xpoints[n] = this.xpoints[n] + offsetx;
            int n2 = i++;
            this.ypoints[n2] = this.ypoints[n2] + offsety;
        }
        this.bounds.translate(offsetx, offsety);
    }

    public boolean contains(Point p) {
        return this.contains(p.x, p.y);
    }

    public boolean contains(int x, int y) {
        if (!this.bounds.contains(x, y)) {
            return false;
        }
        int intersections = 0;
        int last = this.npoints - 1;
        for (int i = 0; i < last; ++i) {
            if (!(y == this.ypoints[i] && !this.isPeak[i] && this.xpoints[i] > x || this.ypoints[i] < y && this.ypoints[i + 1] > y && x < this.xpoints[i] + (this.xpoints[i + 1] - this.xpoints[i]) * (y - this.ypoints[i]) / (this.ypoints[i + 1] - this.ypoints[i])) && (this.ypoints[i] <= y || this.ypoints[i + 1] >= y || x >= this.xpoints[i] + (this.xpoints[i + 1] - this.xpoints[i]) * (y - this.ypoints[i]) / (this.ypoints[i + 1] - this.ypoints[i]))) continue;
            ++intersections;
        }
        if (y == this.ypoints[last] && !this.isPeak[last] && this.xpoints[last] > x || this.ypoints[last] < y && this.ypoints[0] > y && x < this.xpoints[last] + (this.xpoints[0] - this.xpoints[last]) * (y - this.ypoints[last]) / (this.ypoints[0] - this.ypoints[last]) || this.ypoints[last] > y && this.ypoints[0] < y && x < this.xpoints[last] + (this.xpoints[0] - this.xpoints[last]) * (y - this.ypoints[last]) / (this.ypoints[0] - this.ypoints[last])) {
            ++intersections;
        }
        return intersections % 2 > 0;
    }

    public boolean inside(int x, int y) {
        return this.contains(x, y);
    }

    public String toString() {
        return this.getClass().getName() + " number of points: " + this.npoints;
    }
}

